# Generated by Django 2.2.20 on 2021-04-08 15:42

from django.db import migrations


def move_industry(apps, schema_editor):
    """
    Move the industry field from memberships to profiles.
    """
    MembershipDefault = apps.get_model('memberships', 'MembershipDefault')
    Profile = apps.get_model('profiles', 'Profile')
    for profile in Profile.objects.all():
        [industry_id] = MembershipDefault.objects.filter(user=profile.user
                ).exclude(industry__isnull=True).exclude(
                    status_detail='archive').order_by('-create_dt'
                        ).values_list('industry', flat=True)[:1] or [None]
        if industry_id:
            profile.industry_id = industry_id
            profile.save(update_fields=['industry_id'])

class Migration(migrations.Migration):

    dependencies = [
        ('profiles', '0014_profile_industry'),
    ]

    operations = [
        migrations.RunPython(move_industry),
    ]
