# -*- coding: utf-8 -*-
# Generated by Django 1.11.18 on 2019-01-09 17:14


from django.db import migrations


def populate_from_contact_name(apps, schema_editor):
    """
    Populate the first_name and last_name from the contact_name.
    """
    from nameparser import HumanName
    Resume = apps.get_model("resumes", "Resume")
    for resume in Resume.objects.all():
        if resume.contact_name:
            name = HumanName(resume.contact_name)
            first_name, last_name = name.first, name.last
            if first_name or last_name:
                Resume.objects.filter(id=resume.id).update(first_name=first_name, last_name=last_name)

class Migration(migrations.Migration):

    dependencies = [
        ('resumes', '0003_auto_20190109_1714'),
    ]

    operations = [
        migrations.RunPython(populate_from_contact_name),
    ]
