/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.treasuredata.client.model.TDSavedQueryStartRequest;
import com.treasuredata.spark.thirdparty.com.google.common.base.MoreObjects;
import com.treasuredata.spark.thirdparty.com.google.common.base.Optional;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import com.treasuredata.spark.thirdparty.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;

final class ImmutableTDSavedQueryStartRequest
extends TDSavedQueryStartRequest {
    private final String name;
    private final Optional<Long> id;
    private final Date scheduledTime;
    private final Optional<Integer> num;
    private final Optional<String> domainKey;

    private ImmutableTDSavedQueryStartRequest(String name, Optional<Long> id, Date scheduledTime, Optional<Integer> num, Optional<String> domainKey) {
        this.name = name;
        this.id = id;
        this.scheduledTime = scheduledTime;
        this.num = num;
        this.domainKey = domainKey;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="id")
    public Optional<Long> id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="scheduledTime")
    public Date scheduledTime() {
        return this.scheduledTime;
    }

    @Override
    @JsonProperty(value="num")
    public Optional<Integer> num() {
        return this.num;
    }

    @Override
    @JsonProperty(value="domainKey")
    public Optional<String> domainKey() {
        return this.domainKey;
    }

    public final ImmutableTDSavedQueryStartRequest withName(String name) {
        if (this.name.equals(name)) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(name, "name");
        return new ImmutableTDSavedQueryStartRequest(newValue, this.id, this.scheduledTime, this.num, this.domainKey);
    }

    public final ImmutableTDSavedQueryStartRequest withId(long value) {
        Optional<Long> newValue = Optional.of(value);
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableTDSavedQueryStartRequest(this.name, newValue, this.scheduledTime, this.num, this.domainKey);
    }

    public final ImmutableTDSavedQueryStartRequest withId(Optional<Long> optional) {
        Optional<Long> value = Preconditions.checkNotNull(optional, "id");
        if (this.id.equals(value)) {
            return this;
        }
        return new ImmutableTDSavedQueryStartRequest(this.name, value, this.scheduledTime, this.num, this.domainKey);
    }

    public final ImmutableTDSavedQueryStartRequest withScheduledTime(Date scheduledTime) {
        if (this.scheduledTime == scheduledTime) {
            return this;
        }
        Date newValue = Preconditions.checkNotNull(scheduledTime, "scheduledTime");
        return new ImmutableTDSavedQueryStartRequest(this.name, this.id, newValue, this.num, this.domainKey);
    }

    public final ImmutableTDSavedQueryStartRequest withNum(int value) {
        Optional<Integer> newValue = Optional.of(value);
        if (this.num.equals(newValue)) {
            return this;
        }
        return new ImmutableTDSavedQueryStartRequest(this.name, this.id, this.scheduledTime, newValue, this.domainKey);
    }

    public final ImmutableTDSavedQueryStartRequest withNum(Optional<Integer> optional) {
        Optional<Integer> value = Preconditions.checkNotNull(optional, "num");
        if (this.num.equals(value)) {
            return this;
        }
        return new ImmutableTDSavedQueryStartRequest(this.name, this.id, this.scheduledTime, value, this.domainKey);
    }

    public final ImmutableTDSavedQueryStartRequest withDomainKey(String value) {
        Optional<String> newValue = Optional.of(value);
        if (this.domainKey.equals(newValue)) {
            return this;
        }
        return new ImmutableTDSavedQueryStartRequest(this.name, this.id, this.scheduledTime, this.num, newValue);
    }

    public final ImmutableTDSavedQueryStartRequest withDomainKey(Optional<String> optional) {
        Optional<String> value = Preconditions.checkNotNull(optional, "domainKey");
        if (this.domainKey.equals(value)) {
            return this;
        }
        return new ImmutableTDSavedQueryStartRequest(this.name, this.id, this.scheduledTime, this.num, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTDSavedQueryStartRequest && this.equalTo((ImmutableTDSavedQueryStartRequest)another);
    }

    private boolean equalTo(ImmutableTDSavedQueryStartRequest another) {
        return this.name.equals(another.name) && this.id.equals(another.id) && this.scheduledTime.equals(another.scheduledTime) && this.num.equals(another.num) && this.domainKey.equals(another.domainKey);
    }

    public int hashCode() {
        int h2 = 31;
        h2 = h2 * 17 + this.name.hashCode();
        h2 = h2 * 17 + this.id.hashCode();
        h2 = h2 * 17 + this.scheduledTime.hashCode();
        h2 = h2 * 17 + this.num.hashCode();
        h2 = h2 * 17 + this.domainKey.hashCode();
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TDSavedQueryStartRequest").omitNullValues().add("name", this.name).add("id", this.id.orNull()).add("scheduledTime", this.scheduledTime).add("num", this.num.orNull()).add("domainKey", this.domainKey.orNull()).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableTDSavedQueryStartRequest fromJson(Json json) {
        Builder builder = ImmutableTDSavedQueryStartRequest.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.scheduledTime != null) {
            builder.scheduledTime(json.scheduledTime);
        }
        if (json.num != null) {
            builder.num((Optional)json.num);
        }
        if (json.domainKey != null) {
            builder.domainKey((Optional)json.domainKey);
        }
        return builder.build();
    }

    public static ImmutableTDSavedQueryStartRequest copyOf(TDSavedQueryStartRequest instance) {
        if (instance instanceof ImmutableTDSavedQueryStartRequest) {
            return (ImmutableTDSavedQueryStartRequest)instance;
        }
        return ImmutableTDSavedQueryStartRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements TDSavedQueryStartRequest.Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_SCHEDULED_TIME = 2L;
        private long initBits = 3L;
        private String name;
        private Optional<Long> id = Optional.absent();
        private Date scheduledTime;
        private Optional<Integer> num = Optional.absent();
        private Optional<String> domainKey = Optional.absent();

        private Builder() {
        }

        public final Builder from(TDSavedQueryStartRequest instance) {
            Optional<String> domainKeyOptional;
            Preconditions.checkNotNull(instance, "instance");
            this.name(instance.name());
            Optional<Long> idOptional = instance.id();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            this.scheduledTime(instance.scheduledTime());
            Optional<Integer> numOptional = instance.num();
            if (numOptional.isPresent()) {
                this.num((Optional)numOptional);
            }
            if ((domainKeyOptional = instance.domainKey()).isPresent()) {
                this.domainKey((Optional)domainKeyOptional);
            }
            return this;
        }

        @Override
        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public final Builder id(long id) {
            this.id = Optional.of(id);
            return this;
        }

        public final Builder id(Optional<Long> id) {
            this.id = Preconditions.checkNotNull(id, "id");
            return this;
        }

        @Override
        public final Builder scheduledTime(Date scheduledTime) {
            this.scheduledTime = Preconditions.checkNotNull(scheduledTime, "scheduledTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public final Builder num(int num) {
            this.num = Optional.of(num);
            return this;
        }

        @Override
        public final Builder num(Optional<Integer> num) {
            this.num = Preconditions.checkNotNull(num, "num");
            return this;
        }

        @Override
        public final Builder domainKey(String domainKey) {
            this.domainKey = Optional.of(domainKey);
            return this;
        }

        @Override
        public final Builder domainKey(Optional<String> domainKey) {
            this.domainKey = Preconditions.checkNotNull(domainKey, "domainKey");
            return this;
        }

        @Override
        public ImmutableTDSavedQueryStartRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTDSavedQueryStartRequest(this.name, this.id, this.scheduledTime, this.num, this.domainKey);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scheduledTime");
            }
            return "Cannot build TDSavedQueryStartRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends TDSavedQueryStartRequest {
        String name;
        Optional<Long> id = Optional.absent();
        Date scheduledTime;
        Optional<Integer> num = Optional.absent();
        Optional<String> domainKey = Optional.absent();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="id")
        public void setId(Optional<Long> id) {
            this.id = id;
        }

        @JsonProperty(value="scheduledTime")
        public void setScheduledTime(Date scheduledTime) {
            this.scheduledTime = scheduledTime;
        }

        @JsonProperty(value="num")
        public void setNum(Optional<Integer> num) {
            this.num = num;
        }

        @JsonProperty(value="domainKey")
        public void setDomainKey(Optional<String> domainKey) {
            this.domainKey = domainKey;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Date scheduledTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> num() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> domainKey() {
            throw new UnsupportedOperationException();
        }
    }
}

