/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.bucket;

import com.treasuredata.partition.bucket.BucketBlock;
import com.treasuredata.partition.bucket.BucketColumnType;
import com.treasuredata.partition.bucket.BucketFunction;
import com.treasuredata.partition.bucket.IntegerBucketBlock;
import com.treasuredata.partition.bucket.SliceBucketBlock;
import com.treasuredata.partition.bucket.StringBucketBlock;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import java.util.List;

public class HashBucketFunction
implements BucketFunction {
    private final HashFunction[] functions;
    private final int bucketCount;

    public HashBucketFunction(int n, List<BucketColumnType> list) {
        if (n <= 0) {
            throw new IllegalArgumentException("bucketCount must be at least one");
        }
        this.bucketCount = n;
        this.functions = new HashFunction[list.size()];
        for (int i = 0; i < this.functions.length; ++i) {
            this.functions[i] = HashBucketFunction.getHashFunction(list.get(i));
        }
    }

    private static HashFunction getHashFunction(BucketColumnType bucketColumnType) {
        switch (bucketColumnType) {
            case INTEGER: {
                return HashBucketFunction.longHashFunction();
            }
            case STRING: {
                return HashBucketFunction.bytesHashFunction();
            }
            case STRING_SLICE: {
                return HashBucketFunction.sliceHashFunction();
            }
        }
        throw new UnsupportedOperationException("Bucketing is supported for integer and string type " + (Object)((Object)bucketColumnType));
    }

    @Override
    public int getBucket(BucketBlock[] bucketBlockArray, int n) {
        int n2;
        long l = 0L;
        for (n2 = 0; n2 < bucketBlockArray.length; ++n2) {
            BucketBlock bucketBlock = bucketBlockArray[n2];
            long l2 = this.functions[n2].hash(bucketBlock, n);
            l = l * 31L + l2;
        }
        n2 = (int)(l & Integer.MAX_VALUE);
        return n2 % this.bucketCount;
    }

    private static HashFunction longHashFunction() {
        return new HashFunction(){

            @Override
            public long hash(BucketBlock bucketBlock, int n) {
                return bucketBlock.isNull(n) ? 0L : XxHash64.hash(((IntegerBucketBlock)bucketBlock).getLong(n));
            }
        };
    }

    private static HashFunction bytesHashFunction() {
        return new HashFunction(){

            @Override
            public long hash(BucketBlock bucketBlock, int n) {
                return bucketBlock.isNull(n) ? 0L : XxHash64.hash(Slices.wrappedBuffer(((StringBucketBlock)bucketBlock).getBytes(n), 0, ((StringBucketBlock)bucketBlock).getBytes(n).length));
            }
        };
    }

    private static HashFunction sliceHashFunction() {
        return new HashFunction(){

            @Override
            public long hash(BucketBlock bucketBlock, int n) {
                return bucketBlock.isNull(n) ? 0L : XxHash64.hash(((SliceBucketBlock)bucketBlock).getSlice(n));
            }
        };
    }

    private static interface HashFunction {
        public long hash(BucketBlock var1, int var2);
    }
}

