/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io;

import com.treasuredata.partition.io.IOConfig;
import com.treasuredata.partition.io.IOPriority;
import com.treasuredata.partition.io.IORequest;
import com.treasuredata.partition.io.buffer.IOBufferListener;
import com.treasuredata.spark.thirdparty.com.google.common.annotations.VisibleForTesting;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class IOGroup
implements IOBufferListener {
    private static final Logger log = Logger.getLogger(IOGroup.class.getName());
    private static final int HEADER_SIZE = 600;
    private final String id;
    private final IOConfig config;
    private final int maxBufferCount;
    private final int maxRequestBufferCount;
    private final int maxRequestSize;
    private final int requestSize;
    private final AtomicLong updateTime;
    private final AtomicLong availableDownload;
    private final AtomicLong systemAvailableDownload;
    private final AtomicInteger availableBuffers;
    private final AtomicInteger[] numRequests;
    private final AtomicInteger sharedCounter = new AtomicInteger();

    public IOGroup(String string, IOConfig iOConfig, AtomicLong atomicLong, int n) {
        this.id = Objects.requireNonNull(string, "id is null");
        this.config = Objects.requireNonNull(iOConfig, "config is null");
        this.updateTime = new AtomicLong(System.currentTimeMillis());
        this.availableDownload = new AtomicLong(iOConfig.getGroupDownloadSize());
        this.systemAvailableDownload = Preconditions.checkNotNull(atomicLong);
        this.maxBufferCount = (int)(iOConfig.getGroupBufferSize() / (long)iOConfig.getBufferSize());
        this.availableBuffers = new AtomicInteger(this.maxBufferCount);
        this.maxRequestBufferCount = Math.min(16, Math.max(2, this.maxBufferCount / n));
        this.maxRequestSize = this.maxRequestBufferCount * iOConfig.getBufferSize() * 2 - 600;
        this.requestSize = this.maxRequestBufferCount * iOConfig.getBufferSize() - 600;
        this.numRequests = new AtomicInteger[IOPriority.LOW.ordinal() + 1];
        for (int i = 0; i < this.numRequests.length; ++i) {
            this.numRequests[i] = new AtomicInteger();
        }
    }

    public String getId() {
        return this.id;
    }

    public void enter() {
        this.sharedCounter.incrementAndGet();
    }

    public int getSharedCount() {
        return this.sharedCounter.get();
    }

    public boolean leave() {
        if (this.sharedCounter.decrementAndGet() == 0) {
            long l = this.config.getGroupDownloadSize() - this.availableDownload.getAndSet(this.config.getGroupDownloadSize());
            if (l > 0L) {
                this.systemAvailableDownload.addAndGet(l);
                log.severe("Resource release leak");
            }
            return true;
        }
        return false;
    }

    boolean needStart(IORequest iORequest) {
        if (this.checkStart(iORequest)) {
            return true;
        }
        this.updateTime.incrementAndGet();
        return false;
    }

    private boolean checkStart(IORequest iORequest) {
        if (iORequest.getHandler().isFinished()) {
            return false;
        }
        if (iORequest.getQueuedBufferCount() >= this.maxRequestBufferCount) {
            return false;
        }
        if (iORequest.started()) {
            return true;
        }
        if (iORequest.getRetryContext().getRetryCount() > 0) {
            return true;
        }
        if (iORequest.getFileSize() > 0L && (this.availableDownload.get() < 0L || this.systemAvailableDownload.get() < 0L)) {
            return false;
        }
        if (this.numRequests[iORequest.getPriority().ordinal()].get() >= iORequest.getPriority().getMaxRequests()) {
            return false;
        }
        return this.availableBuffers.get() > 0;
    }

    void start(IORequest iORequest) {
        this.numRequests[iORequest.getPriority().ordinal()].incrementAndGet();
    }

    void complete(IORequest iORequest) {
        this.numRequests[iORequest.getPriority().ordinal()].decrementAndGet();
    }

    public final long getUpdateTime() {
        return this.updateTime.get();
    }

    public int getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public int getRequestSize() {
        return this.requestSize;
    }

    @Override
    public void bufferAllocated() {
        this.availableBuffers.decrementAndGet();
    }

    @Override
    public void bufferReleased() {
        this.availableBuffers.incrementAndGet();
    }

    public void reserveDiskSpace(long l) {
        this.releaseDiskSpace(-1L * l);
    }

    public void releaseDiskSpace(long l) {
        this.availableDownload.addAndGet(l);
        this.systemAvailableDownload.addAndGet(l);
    }

    @VisibleForTesting
    boolean validate(IOConfig iOConfig) {
        try {
            this.assertEquals(this.sharedCounter.get(), 0, "not finished", new String[0]);
            for (AtomicInteger atomicInteger : this.numRequests) {
                this.assertEquals(atomicInteger.get(), 0, "number of requests is not zero", new String[0]);
            }
            this.assertEquals(this.availableBuffers.get(), this.maxBufferCount, "availableBuffers != maxRequestBufferCount", new String[0]);
            this.assertEquals(this.availableDownload.get(), iOConfig.getGroupDownloadSize(), "availableDownload != config.getGroupDownloadSize()", new String[0]);
        }
        catch (AssertionError assertionError) {
            log.warning(((Throwable)((Object)assertionError)).getMessage());
            return false;
        }
        return true;
    }

    private void assertEquals(Object object, Object object2, String string, String ... stringArray) {
        if (!object.equals(object2)) {
            String string2 = String.format(string, stringArray);
            throw new AssertionError((Object)String.format("%s != %s : %s", object, object2, string2));
        }
    }
}

