/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io;

import com.treasuredata.partition.io.IOPriority;
import com.treasuredata.partition.io.IORequest;
import com.treasuredata.partition.io.IORequestFilter;
import java.util.concurrent.atomic.AtomicLong;

public class RangeFilter
implements IORequestFilter {
    private final AtomicLong remaining;

    public RangeFilter(long l) {
        this.remaining = new AtomicLong(l);
    }

    @Override
    public IORequest filter(IORequest iORequest) {
        if (iORequest.getSize() < 0L) {
            return iORequest;
        }
        long l = iORequest.getSize() - this.remaining.get();
        long l2 = iORequest.getOffset() + l;
        long l3 = iORequest.getSize() - l;
        if (iORequest.getPriority().ordinal() < IOPriority.NORMAL.ordinal() && l3 > (long)iORequest.getGroup().getMaxRequestSize()) {
            l3 = iORequest.getGroup().getRequestSize();
        }
        String string = String.format("bytes=%d-%d", l2, l2 + l3 - 1L);
        this.remaining.addAndGet(-l3);
        return iORequest.addHeader("Range", string);
    }

    @Override
    public boolean hasMore() {
        return this.remaining.get() > 0L;
    }
}

