/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io.impl.alluxio;

import alluxio.AlluxioURI;
import alluxio.client.ReadType;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.options.OpenFileOptions;
import alluxio.exception.AlluxioException;
import com.treasuredata.partition.io.IOHandler;
import com.treasuredata.partition.io.IOManager;
import com.treasuredata.partition.io.IORequest;
import com.treasuredata.partition.io.buffer.IOBuffer;
import com.treasuredata.partition.io.buffer.IOBufferPool;
import java.io.EOFException;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;

public class AlluxioResponseHandler
implements Runnable {
    private static final Logger log = Logger.getLogger(AlluxioResponseHandler.class.getName());
    private final IOManager manager;
    private final IORequest request;
    private final FileSystem fileSystem;
    private final AlluxioURI uri;
    private final IOHandler handler;

    public AlluxioResponseHandler(IOManager iOManager, IORequest iORequest, FileSystem fileSystem, AlluxioURI alluxioURI) {
        this.manager = Objects.requireNonNull(iOManager, "manager is null");
        this.request = Objects.requireNonNull(iORequest, "request is null");
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.uri = Objects.requireNonNull(alluxioURI, "uri is null");
        this.handler = iORequest.getHandler();
    }

    @Override
    public void run() {
        Optional<Throwable> optional = Optional.empty();
        try {
            this.runInternal();
        }
        catch (Throwable throwable) {
            optional = Optional.of(throwable);
        }
        finally {
            this.request.complete();
            this.manager.completeRequest(this.request, optional);
        }
    }

    private void runInternal() throws IOException, AlluxioException {
        long l = System.currentTimeMillis();
        if (this.handler.isFinished()) {
            log.info("handler has been finished");
            return;
        }
        long l2 = this.request.getOffset();
        IOBufferPool iOBufferPool = this.manager.getBufferPool();
        byte[] byArray = new byte[iOBufferPool.getBufferSize()];
        OpenFileOptions openFileOptions = OpenFileOptions.defaults().setReadType(ReadType.CACHE_PROMOTE);
        try (FileInStream fileInStream = this.fileSystem.openFile(this.uri, openFileOptions);){
            int n;
            fileInStream.seek(l2);
            long l3 = System.currentTimeMillis();
            for (long i = this.request.getSize(); i > 0L; i -= (long)n) {
                n = Math.toIntExact(Math.min(i, (long)byArray.length));
                if (fileInStream.read(byArray, 0, n) < 0) {
                    throw new EOFException("Expected more bytes: " + i);
                }
                IOBuffer iOBuffer = iOBufferPool.allocate(this.request);
                iOBuffer.getByteBuffer().put(byArray, 0, n).flip();
                this.handler.content(this.request, iOBuffer.slice());
            }
            this.calculateElapsed(l, l3);
            if (this.handler.isFinished()) {
                return;
            }
        }
    }

    private void calculateElapsed(long l, long l2) {
        this.handler.elapse(this.request, l2 - l, System.currentTimeMillis() - l2);
    }
}

