/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io.impl.jetty;

import com.treasuredata.partition.io.IOHandler;
import com.treasuredata.partition.io.IOManager;
import com.treasuredata.partition.io.IORequest;
import com.treasuredata.partition.io.buffer.IOBuffer;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;

public class JettyResponseHandler
extends Response.Listener.Adapter {
    private final AtomicLong bodyStartTime = new AtomicLong();
    private final IOHandler handler;
    private final IOManager manager;
    private final IORequest request;

    public JettyResponseHandler(IOManager iOManager, IORequest iORequest) {
        this.manager = iOManager;
        this.request = iORequest;
        this.handler = iORequest.getHandler();
    }

    @Override
    public void onHeaders(Response response) {
        this.bodyStartTime.set(System.currentTimeMillis());
    }

    @Override
    public void onBegin(Response response) {
        if (this.abortIfFinished(response)) {
            return;
        }
    }

    private boolean abortIfFinished(Response response) {
        boolean bl = this.handler.isFinished();
        if (bl) {
            response.abort(new Exception("handler has been finished"));
        }
        return bl;
    }

    @Override
    public void onContent(Response response, ByteBuffer byteBuffer) {
        IOBuffer iOBuffer = new IOBuffer(this.manager.getBufferPool(), this.request, byteBuffer);
        this.raiseResponseError(response, iOBuffer);
        this.handler.content(this.request, iOBuffer);
    }

    @Override
    public void onSuccess(Response response) {
        this.request.complete();
    }

    @Override
    public void onFailure(Response response, Throwable throwable) {
        this.request.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete(Result result) {
        Optional<Throwable> optional = Optional.empty();
        try {
            int n;
            Response response = result.getResponse();
            optional = Optional.ofNullable(result.getFailure());
            this.calculateElapsed(response);
            if (this.handler.isFinished()) {
                return;
            }
            if (!optional.isPresent() && (n = response.getStatus()) != 206 && n != 200) {
                optional = Optional.of(new HttpResponseException(response.getReason(), response));
            }
        }
        catch (Throwable throwable) {
            optional = Optional.of(throwable);
        }
        finally {
            this.manager.completeRequest(this.request, optional);
        }
    }

    protected void raiseResponseError(Response response, IOBuffer iOBuffer) {
        if (this.handler.isFinished()) {
            iOBuffer.release();
            throw new RuntimeException("handler has been finished");
        }
        int n = response.getStatus();
        if (n != 206 && n != 200) {
            byte[] byArray = new byte[iOBuffer.remaining()];
            iOBuffer.getByteBuffer().get(byArray);
            StringBuilder stringBuilder = new StringBuilder();
            Request request = response.getRequest();
            stringBuilder.append(n).append(' ').append(response.getReason()).append('\n').append(request.getMethod()).append(' ').append(request.getPath()).append('\n');
            request.getHeaders().getFieldNamesCollection().forEach(string -> stringBuilder.append((String)string).append(": ").append(request.getHeaders().get((String)string)).append('\n'));
            stringBuilder.append(new String(byArray));
            iOBuffer.release();
            throw new HttpResponseException(stringBuilder.toString(), response);
        }
    }

    private void calculateElapsed(Response response) {
        Long l = (Long)response.getRequest().getAttributes().get("_JETTY_START_TIME_");
        long l2 = this.bodyStartTime.get();
        if (l == null || l2 == 0L) {
            return;
        }
        this.handler.elapse(this.request, l2 - l, System.currentTimeMillis() - l2);
    }
}

