/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.io.impl.jetty;

import com.treasuredata.partition.io.IORequest;
import com.treasuredata.partition.io.buffer.IOBuffer;
import com.treasuredata.partition.io.impl.jetty.FileChannelEndPoint;
import com.treasuredata.partition.io.impl.jetty.ManagedHttpConnection;
import com.treasuredata.partition.io.impl.jetty.ReflectionUtils;
import com.treasuredata.spark.thirdparty.com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.http.HttpChannelOverHTTP;
import org.eclipse.jetty.client.http.HttpReceiverOverHTTP;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.CompletableCallback;

public class ManagedReceiver
extends HttpReceiverOverHTTP {
    private static final Logger log = Logger.getLogger(ManagedReceiver.class.getName());
    private static final IOBuffer IN_USE_IO_BUFFER = new IOBuffer.NonManagedIOBuffer(ByteBuffer.allocate(0));
    private static final IOBuffer FINISHED_IO_BUFFER = new IOBuffer.NonManagedIOBuffer(ByteBuffer.allocate(0));
    private final HttpParser parser;
    private final ManagedHttpConnection connection;
    private final EndPoint endPoint;
    private final AtomicReference<IOBuffer> bufferReference = new AtomicReference();
    private final FileChannelEndPoint fileEndPoint;
    private IOBuffer buffer;
    private boolean shutdown;
    private int offset = -1;

    public ManagedReceiver(HttpChannelOverHTTP httpChannelOverHTTP) {
        super(httpChannelOverHTTP);
        this.parser = (HttpParser)ReflectionUtils.getPrivateField(this.getClass().getSuperclass(), this, "parser");
        this.connection = this.getHttpConnection();
        this.endPoint = this.connection.getEndPoint();
        this.fileEndPoint = new FileChannelEndPoint(this.endPoint);
    }

    private ManagedHttpConnection getHttpConnection() {
        return (ManagedHttpConnection)this.getHttpChannel().getHttpConnection();
    }

    @Override
    public void receive() {
        this.loadBufferReference();
        ProcessResult processResult = this.process();
        this.saveBufferReverence();
        if (processResult == ProcessResult.CONTINUE) {
            this.fillInterested();
        }
    }

    private ProcessResult process() {
        try {
            int n;
            do {
                Object object;
                boolean bl;
                boolean bl2 = bl = this.connection != this.endPoint.getConnection();
                if (this.connection.isClosed() || bl) {
                    this.releaseBuffer();
                    return ProcessResult.CLOSED;
                }
                HttpExchange httpExchange = this.getHttpExchange();
                if (httpExchange == null) {
                    this.releaseBuffer();
                    return ProcessResult.CONTINUE;
                }
                IORequest iORequest = this.getIoRequest(httpExchange);
                if (iORequest.completed()) {
                    this.releaseBuffer();
                    return ProcessResult.CONTINUE;
                }
                FileChannel fileChannel = iORequest.getFileChannel();
                if (this.fileEndPoint.enabled() && fileChannel != null && !this.isStart()) {
                    if (this.buffer != null && !this.publishContent(httpExchange)) {
                        iORequest.closeFileChannel();
                        Preconditions.checkState(this.buffer == null, "Buffer is not null");
                        return ProcessResult.COMPLETED;
                    }
                    object = new AtomicInteger();
                    if (!this.fillContent(httpExchange, fileChannel, iORequest.getFileSize(), (AtomicInteger)object)) {
                        iORequest.closeFileChannel();
                        Preconditions.checkState(this.buffer == null, "Buffer is not null");
                        return ProcessResult.COMPLETED;
                    }
                    n = ((AtomicInteger)object).get();
                } else {
                    this.loadBuffer(iORequest);
                    object = this.buffer.getByteBuffer();
                    ByteBuffer byteBuffer = ((ByteBuffer)object).slice();
                    byteBuffer.limit(0);
                    n = this.endPoint.fill(byteBuffer);
                    if (n > 0) {
                        ((ByteBuffer)object).position(((Buffer)object).position() + n);
                        if (this.parse(byteBuffer)) {
                            this.releaseBuffer();
                            return ProcessResult.COMPLETED;
                        }
                    }
                }
                if (n != 0) continue;
                return ProcessResult.CONTINUE;
            } while (n >= 0);
            this.releaseBuffer();
            this.shutdown();
            return ProcessResult.CLOSED;
        }
        catch (Throwable throwable) {
            this.releaseBuffer();
            this.failAndClose(throwable);
            return ProcessResult.CLOSED;
        }
    }

    private boolean parse(ByteBuffer byteBuffer) {
        boolean bl;
        while (!(bl = this.parser.parseNext(byteBuffer)) && byteBuffer.hasRemaining()) {
        }
        return bl;
    }

    private void loadBuffer(IORequest iORequest) {
        if (this.buffer == null) {
            this.buffer = this.connection.getBufferPool().allocate(iORequest);
        }
    }

    @Override
    public boolean content(ByteBuffer byteBuffer) {
        HttpExchange httpExchange = this.getHttpExchange();
        if (httpExchange == null) {
            return false;
        }
        if (this.isStart()) {
            this.offset = byteBuffer.position() + this.buffer.position() - byteBuffer.limit();
            Preconditions.checkState(this.offset > 0, "Invalid Buffer state");
        }
        if (this.buffer.isFull()) {
            return !this.publishContent(httpExchange);
        }
        return false;
    }

    @Override
    public boolean messageComplete() {
        HttpExchange httpExchange = this.getHttpExchange();
        if (httpExchange == null) {
            return false;
        }
        if (this.buffer != null && !this.publishContent(httpExchange)) {
            return true;
        }
        return !this.responseSuccess(httpExchange);
    }

    @Override
    public void reset() {
        this.offset = -1;
        Preconditions.checkState(this.buffer == null, "buffer is not null");
        super.reset();
    }

    @Override
    public void dispose() {
        this.offset = -1;
        this.release();
        super.dispose();
    }

    @Override
    public void earlyEOF() {
        HttpExchange httpExchange = this.getHttpExchange();
        if (httpExchange != null) {
            log.info("EOF " + this.getIoRequest(httpExchange).getUri());
        }
        super.earlyEOF();
    }

    private IORequest getIoRequest(HttpExchange httpExchange) {
        Preconditions.checkNotNull(httpExchange, "exchange is null");
        return (IORequest)httpExchange.getRequest().getAttributes().get("_IO_REQUEST_");
    }

    private boolean fillContent(HttpExchange httpExchange, final FileChannel fileChannel, long l, final AtomicInteger atomicInteger) throws IOException {
        Preconditions.checkState(this.buffer == null, "buffer is not null");
        CompletableCallback completableCallback = new CompletableCallback(){

            @Override
            public void succeeded() {
                try {
                    atomicInteger.set(ManagedReceiver.this.fileEndPoint.fill(fileChannel));
                    super.succeeded();
                }
                catch (IOException iOException) {
                    log.info("Failed to fill file contents " + iOException.getMessage());
                    atomicInteger.set(-1);
                }
            }

            @Override
            public void resume() {
                Preconditions.checkState(false, "Callback will not resume");
            }

            @Override
            public void abort(Throwable throwable) {
                ManagedReceiver.this.failAndClose(throwable);
            }
        };
        if (!this.responseContent(httpExchange, BufferUtil.EMPTY_BUFFER, completableCallback)) {
            return false;
        }
        if (atomicInteger.get() >= 0) {
            long l2 = fileChannel.position();
            if (l2 == l) {
                return !this.messageComplete();
            }
            if (l2 > l) {
                throw new IOException(String.format("File position %d is bigger than expected size %d", l2, l));
            }
        }
        return true;
    }

    private boolean publishContent(HttpExchange httpExchange) {
        Preconditions.checkNotNull(this.buffer, "buffer is null");
        BufferUtil.flipToFlush(this.buffer.getByteBuffer(), this.offset);
        final IOBuffer iOBuffer = this.buffer;
        this.buffer = null;
        this.offset = 0;
        CompletableCallback completableCallback = new CompletableCallback(){

            @Override
            public void resume() {
                Preconditions.checkState(false, "Callback will not resume");
            }

            @Override
            public void abort(Throwable throwable) {
                if (throwable instanceof IllegalStateException && throwable.getMessage().startsWith("Invalid response state")) {
                    log.info("already failed even before callback starts");
                    iOBuffer.release();
                }
                ManagedReceiver.this.failAndClose(throwable);
            }
        };
        boolean bl = this.responseContent(httpExchange, iOBuffer.getByteBuffer(), completableCallback);
        Preconditions.checkState(!completableCallback.tryComplete(), "Callback will not be idle");
        return bl;
    }

    private void failAndClose(Throwable throwable) {
        if (this.responseFailure(throwable)) {
            this.getHttpConnection().close(throwable);
        }
    }

    private void releaseBuffer() {
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
    }

    private void shutdown() {
        this.shutdown = true;
        this.parser.atEOF();
        this.parser.parseNext(BufferUtil.EMPTY_BUFFER);
    }

    @Override
    protected boolean isShutdown() {
        return this.shutdown;
    }

    private void loadBufferReference() {
        this.buffer = this.bufferReference.getAndSet(IN_USE_IO_BUFFER);
        Preconditions.checkState(this.buffer != IN_USE_IO_BUFFER, "Invalid buffer state");
    }

    private void saveBufferReverence() {
        if (!this.bufferReference.compareAndSet(IN_USE_IO_BUFFER, this.buffer)) {
            Preconditions.checkState(this.bufferReference.compareAndSet(FINISHED_IO_BUFFER, null), "Invalid buffer state, not finished buffer");
            this.releaseBuffer();
        }
    }

    private boolean isStart() {
        return this.offset < 0;
    }

    public void release() {
        IOBuffer iOBuffer = this.bufferReference.getAndSet(FINISHED_IO_BUFFER);
        if (iOBuffer != null && iOBuffer != IN_USE_IO_BUFFER && iOBuffer != FINISHED_IO_BUFFER) {
            iOBuffer.release();
        }
    }

    private static enum ProcessResult {
        CONTINUE,
        COMPLETED,
        CLOSED;

    }
}

