/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.merge;

import com.treasuredata.partition.mpc.writer.BlockBuilder;
import com.treasuredata.spark.thirdparty.com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;

public class GZIPBlockBuilder
extends BlockBuilder {
    private OutputStream output;

    public GZIPBlockBuilder(File file) {
        super(null);
        try {
            this.output = new GZIPOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]), 65536);
        }
        catch (IOException iOException) {
            throw Throwables.propagate(iOException);
        }
    }

    @Override
    public void fillNil(long l) throws IOException {
        for (long i = 0L; i < l; ++i) {
            this.output.write(-64);
        }
    }

    public OutputStream getOutput() {
        return Objects.requireNonNull(this.output, "output closed");
    }

    @Override
    public void close() throws IOException {
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
    }
}

