/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.merge;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;

public class ResettableWritableChannel
implements WritableByteChannel {
    private WritableByteChannel out;

    public ResettableWritableChannel(WritableByteChannel writableByteChannel) {
        this.reset(writableByteChannel);
    }

    public void reset(WritableByteChannel writableByteChannel) {
        this.out = Objects.requireNonNull(writableByteChannel, "out is null");
    }

    @Override
    public boolean isOpen() {
        return this.out != null;
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        return this.out.write(byteBuffer);
    }
}

