/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.reader.columnar;

import com.treasuredata.partition.mpc.reader.columnar.ColumnReader;
import com.treasuredata.partition.mpc.reader.columnar.ColumnValueHolder;
import com.treasuredata.partition.mpc.reader.columnar.TypeConversionException;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.value.Value;
import org.msgpack.value.ValueType;

public abstract class AbstractColumnReader
implements ColumnReader {
    protected final MessageUnpacker unpacker;
    private boolean isAccessed = false;

    public AbstractColumnReader(MessageUnpacker messageUnpacker) {
        this.unpacker = messageUnpacker;
    }

    protected abstract ColumnValueHolder current();

    protected MessageUnpacker getUnpacker() throws IOException {
        return this.unpacker;
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.getUnpacker().hasNext();
    }

    @Override
    public void advance() throws IOException {
        if (!this.isAccessed) {
            this.isAccessed = true;
        } else if (!this.current().isRead()) {
            this.getUnpacker().skipValue();
        }
        this.current().reset();
    }

    @Override
    public void skip() throws IOException {
        this.getUnpacker().skipValue();
        this.current().reset();
    }

    @Override
    public boolean isNull() throws IOException {
        return !this.current().update();
    }

    @Override
    public void close() throws IOException {
        this.getUnpacker().close();
        this.current().close();
    }

    public static TypeConversionException typeError(ValueType valueType) {
        return new TypeConversionException(valueType);
    }

    @Override
    public long getLong() throws IOException {
        throw AbstractColumnReader.typeError(ValueType.INTEGER);
    }

    @Override
    public double getDouble() throws IOException {
        throw AbstractColumnReader.typeError(ValueType.FLOAT);
    }

    @Override
    public boolean getBoolean() throws IOException {
        throw AbstractColumnReader.typeError(ValueType.BOOLEAN);
    }

    @Override
    public byte[] getByteArray() throws IOException {
        throw AbstractColumnReader.typeError(ValueType.BINARY);
    }

    @Override
    public List<?> getList() throws IOException {
        throw AbstractColumnReader.typeError(ValueType.ARRAY);
    }

    @Override
    public Map<?, ?> getMap() throws IOException {
        throw AbstractColumnReader.typeError(ValueType.MAP);
    }

    @Override
    public Value getValue() throws IOException {
        throw AbstractColumnReader.typeError(ValueType.EXTENSION);
    }

    @Override
    public MessageBuffer getMemoryReference() throws IOException {
        throw AbstractColumnReader.typeError(ValueType.BINARY);
    }

    @Override
    public int elementSize() throws IOException {
        return 0;
    }

    @Override
    public List<ColumnReader> getChildren() {
        return ImmutableList.of();
    }
}

