/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.partition.mpc.reader.columnar;

import com.treasuredata.partition.mpc.reader.columnar.AbstractColumnReader;
import com.treasuredata.partition.mpc.reader.columnar.ColumnReader;
import com.treasuredata.partition.mpc.reader.columnar.ColumnValueHolder;
import com.treasuredata.partition.mpc.reader.columnar.ColumnValueType;
import com.treasuredata.partition.mpc.reader.columnar.MPCColumnReader;
import com.treasuredata.spark.thirdparty.com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;
import org.msgpack.value.ValueType;

public class ArrayColumnReader
extends AbstractColumnReader {
    private final ArrayHolder holder;

    public ArrayColumnReader(MessageUnpacker messageUnpacker, ColumnValueType columnValueType) {
        super(messageUnpacker);
        this.holder = new ArrayHolder(columnValueType);
    }

    @Override
    protected ArrayHolder current() {
        return this.holder;
    }

    @Override
    public List<?> getList() throws IOException {
        return this.holder.getOrElseUpdate();
    }

    @Override
    public int elementSize() throws IOException {
        return this.holder.getOrElseUpdateHeader();
    }

    @Override
    public Value getValue() throws IOException {
        if (this.isNull()) {
            return ValueFactory.newNil();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < this.elementSize(); ++i) {
            builder.add(this.current().elementReader.getValue());
        }
        return ValueFactory.newArray((List<? extends Value>)((Object)builder.build()));
    }

    @Override
    public List<ColumnReader> getChildren() {
        return ImmutableList.of(this.holder.elementReader);
    }

    private class ArrayHolder
    extends ColumnValueHolder {
        private List<Object> value;
        private final ColumnValueType elementType;
        private final ColumnReader elementReader;
        private int elementSize;

        public ArrayHolder(ColumnValueType columnValueType) {
            this.elementType = columnValueType;
            this.elementReader = MPCColumnReader.createColumnReader(ArrayColumnReader.this.unpacker, this.elementType, false);
        }

        @Override
        protected boolean update() throws IOException {
            if (!this.isRead) {
                this.value = null;
                ValueType valueType = ArrayColumnReader.this.unpacker.getNextFormat().getValueType();
                switch (valueType) {
                    case ARRAY: {
                        this.elementSize = ArrayColumnReader.this.unpacker.unpackArrayHeader();
                        break;
                    }
                    case NIL: {
                        this.isValid = false;
                        ArrayColumnReader.this.unpacker.skipValue();
                        break;
                    }
                    default: {
                        this.isValid = false;
                        ArrayColumnReader.this.unpacker.skipValue();
                    }
                }
                this.isRead = true;
            }
            return this.isValid;
        }

        @Override
        public void reset() {
            super.reset();
            this.value = null;
        }

        public List<?> getOrElseUpdate() throws IOException {
            this.update();
            if (this.isValid && this.value == null) {
                this.value = new ArrayList<Object>(this.elementSize);
                for (int i = 0; i < this.elementSize; ++i) {
                    this.value.add(ArrayHolder.readItem(this.elementReader, this.elementType));
                }
            }
            return this.value;
        }

        public int getOrElseUpdateHeader() throws IOException {
            this.update();
            return this.elementSize;
        }
    }
}

