/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.jackson.datatype.guava.deser;

import io.prestosql.jdbc.$internal.guava.collect.ImmutableRangeSet;
import io.prestosql.jdbc.$internal.guava.collect.Range;
import io.prestosql.jdbc.$internal.guava.collect.RangeSet;
import io.prestosql.jdbc.$internal.jackson.core.JsonParseException;
import io.prestosql.jdbc.$internal.jackson.core.JsonParser;
import io.prestosql.jdbc.$internal.jackson.databind.BeanProperty;
import io.prestosql.jdbc.$internal.jackson.databind.DeserializationContext;
import io.prestosql.jdbc.$internal.jackson.databind.JavaType;
import io.prestosql.jdbc.$internal.jackson.databind.JsonDeserializer;
import io.prestosql.jdbc.$internal.jackson.databind.deser.ContextualDeserializer;
import java.io.IOException;
import java.util.List;

public class RangeSetDeserializer
extends JsonDeserializer<RangeSet<Comparable<?>>>
implements ContextualDeserializer {
    private JavaType genericRangeListType;

    @Override
    public RangeSet<Comparable<?>> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this.genericRangeListType == null) {
            throw new JsonParseException(p, "RangeSetJsonSerializer was not contextualized (no deserialize target type). You need to specify the generic type down to the generic parameter of RangeSet.");
        }
        Iterable ranges = (Iterable)ctxt.findContextualValueDeserializer(this.genericRangeListType, null).deserialize(p, ctxt);
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        for (Range range : ranges) {
            builder.add(range);
        }
        return builder.build();
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        JavaType genericType = ctxt.getContextualType().containedType(0);
        if (genericType == null) {
            return this;
        }
        RangeSetDeserializer deserializer = new RangeSetDeserializer();
        deserializer.genericRangeListType = ctxt.getTypeFactory().constructCollectionType(List.class, ctxt.getTypeFactory().constructParametricType(Range.class, genericType));
        return deserializer;
    }
}

