/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.jackson.datatype.joda.ser;

import io.prestosql.jdbc.$internal.jackson.core.JsonGenerator;
import io.prestosql.jdbc.$internal.jackson.databind.SerializationFeature;
import io.prestosql.jdbc.$internal.jackson.databind.SerializerProvider;
import io.prestosql.jdbc.$internal.jackson.datatype.joda.cfg.FormatConfig;
import io.prestosql.jdbc.$internal.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import io.prestosql.jdbc.$internal.jackson.datatype.joda.ser.JodaDateSerializerBase;
import io.prestosql.jdbc.$internal.joda.time.LocalTime;
import java.io.IOException;

public class LocalTimeSerializer
extends JodaDateSerializerBase<LocalTime> {
    private static final long serialVersionUID = 1L;

    public LocalTimeSerializer() {
        this(FormatConfig.DEFAULT_LOCAL_TIMEONLY_PRINTER, 0);
    }

    public LocalTimeSerializer(JacksonJodaDateFormat format) {
        this(format, 0);
    }

    public LocalTimeSerializer(JacksonJodaDateFormat format, int shapeOverride) {
        super(LocalTime.class, format, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, 3, shapeOverride);
    }

    public LocalTimeSerializer withFormat(JacksonJodaDateFormat formatter, int shapeOverride) {
        return new LocalTimeSerializer(formatter, shapeOverride);
    }

    @Override
    public void serialize(LocalTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._serializationShape(provider) == 1) {
            gen.writeString(this._format.createFormatter(provider).print(value));
            return;
        }
        gen.writeStartArray();
        gen.writeNumber(value.hourOfDay().get());
        gen.writeNumber(value.minuteOfHour().get());
        gen.writeNumber(value.secondOfMinute().get());
        gen.writeNumber(value.millisOfSecond().get());
        gen.writeEndArray();
    }
}

