/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorServiceUtils.class);

    public static ExecutorService newSingleThreadDaemonExecutor() {
        return Executors.newSingleThreadExecutor(r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        });
    }

    public static ScheduledExecutorService newScheduledDaemonThreadPool(int corePoolSize) {
        return Executors.newScheduledThreadPool(corePoolSize, r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        });
    }

    public static void finishExecutorService(ExecutorService executorService) {
        ExecutorServiceUtils.finishExecutorService(executorService, 3L);
    }

    public static void finishExecutorService(ExecutorService executorService, long waitSecond) {
        executorService.shutdown();
        try {
            executorService.awaitTermination(waitSecond, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("1st awaitTermination was interrupted", e);
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            LOG.warn("Failed to await the termination of executorService", e);
        }
        if (!executorService.isTerminated()) {
            executorService.shutdownNow();
        }
    }
}

