/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.msgpack.spi;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt;
import scala.runtime.RichLong$;
import scala.runtime.RichShort;
import wvlet.airframe.msgpack.spi.Code$;
import wvlet.airframe.msgpack.spi.ErrorCode$INVALID_EXT_FORMAT$;
import wvlet.airframe.msgpack.spi.ErrorCode$INVALID_TYPE$;
import wvlet.airframe.msgpack.spi.ErrorCode$NEVER_USED_FORMAT$;
import wvlet.airframe.msgpack.spi.ExtTypeHeader;
import wvlet.airframe.msgpack.spi.MessageException;
import wvlet.airframe.msgpack.spi.MessageException$;
import wvlet.airframe.msgpack.spi.MessageFormat;
import wvlet.airframe.msgpack.spi.MessageFormat$;
import wvlet.airframe.msgpack.spi.MessageFormat$ARRAY16$;
import wvlet.airframe.msgpack.spi.MessageFormat$ARRAY32$;
import wvlet.airframe.msgpack.spi.MessageFormat$BIN16$;
import wvlet.airframe.msgpack.spi.MessageFormat$BIN32$;
import wvlet.airframe.msgpack.spi.MessageFormat$BIN8$;
import wvlet.airframe.msgpack.spi.MessageFormat$BOOLEAN$;
import wvlet.airframe.msgpack.spi.MessageFormat$EXT16$;
import wvlet.airframe.msgpack.spi.MessageFormat$EXT32$;
import wvlet.airframe.msgpack.spi.MessageFormat$EXT8$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXARRAY$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXEXT1$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXEXT16$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXEXT2$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXEXT4$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXEXT8$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXMAP$;
import wvlet.airframe.msgpack.spi.MessageFormat$FIXSTR$;
import wvlet.airframe.msgpack.spi.MessageFormat$FLOAT32$;
import wvlet.airframe.msgpack.spi.MessageFormat$FLOAT64$;
import wvlet.airframe.msgpack.spi.MessageFormat$INT16$;
import wvlet.airframe.msgpack.spi.MessageFormat$INT32$;
import wvlet.airframe.msgpack.spi.MessageFormat$INT64$;
import wvlet.airframe.msgpack.spi.MessageFormat$INT8$;
import wvlet.airframe.msgpack.spi.MessageFormat$MAP16$;
import wvlet.airframe.msgpack.spi.MessageFormat$MAP32$;
import wvlet.airframe.msgpack.spi.MessageFormat$NEGFIXINT$;
import wvlet.airframe.msgpack.spi.MessageFormat$NEVER_USED$;
import wvlet.airframe.msgpack.spi.MessageFormat$NIL$;
import wvlet.airframe.msgpack.spi.MessageFormat$POSFIXINT$;
import wvlet.airframe.msgpack.spi.MessageFormat$STR16$;
import wvlet.airframe.msgpack.spi.MessageFormat$STR32$;
import wvlet.airframe.msgpack.spi.MessageFormat$STR8$;
import wvlet.airframe.msgpack.spi.MessageFormat$UINT16$;
import wvlet.airframe.msgpack.spi.MessageFormat$UINT32$;
import wvlet.airframe.msgpack.spi.MessageFormat$UINT64$;
import wvlet.airframe.msgpack.spi.MessageFormat$UINT8$;
import wvlet.airframe.msgpack.spi.ReadBuffer;
import wvlet.airframe.msgpack.spi.ReadCursor;
import wvlet.airframe.msgpack.spi.TooLargeMessageException;
import wvlet.airframe.msgpack.spi.Value;
import wvlet.airframe.msgpack.spi.Value$NilValue$;
import wvlet.airframe.msgpack.spi.ValueType;
import wvlet.airframe.msgpack.spi.ValueType$ARRAY$;
import wvlet.airframe.msgpack.spi.ValueType$BINARY$;
import wvlet.airframe.msgpack.spi.ValueType$BOOLEAN$;
import wvlet.airframe.msgpack.spi.ValueType$EXTENSION$;
import wvlet.airframe.msgpack.spi.ValueType$FLOAT$;
import wvlet.airframe.msgpack.spi.ValueType$INTEGER$;
import wvlet.airframe.msgpack.spi.ValueType$MAP$;
import wvlet.airframe.msgpack.spi.ValueType$NIL$;
import wvlet.airframe.msgpack.spi.ValueType$STRING$;
import wvlet.airframe.msgpack.spi.WriteBuffer;

public final class OffsetUnpacker$ {
    public static OffsetUnpacker$ MODULE$;
    private final String EMPTY_STRING;

    static {
        new OffsetUnpacker$();
    }

    /*
     * WARNING - void declaration
     */
    public MessageFormat peekNextFormat(ReadCursor cursor) {
        void var3_3;
        byte b = cursor.peekByte();
        MessageFormat mf = MessageFormat$.MODULE$.of(b);
        return var3_3;
    }

    public void skipValue(ReadCursor cursor, int skipCount) {
        for (int count = skipCount; count > 0; --count) {
            BoxedUnit boxedUnit;
            byte b = cursor.readByte();
            MessageFormat mf = MessageFormat$.MODULE$.of(b);
            MessageFormat messageFormat = mf;
            boolean bl = MessageFormat$POSFIXINT$.MODULE$.equals(messageFormat) ? true : (MessageFormat$NEGFIXINT$.MODULE$.equals(messageFormat) ? true : (MessageFormat$BOOLEAN$.MODULE$.equals(messageFormat) ? true : MessageFormat$NIL$.MODULE$.equals(messageFormat)));
            if (bl) {
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$FIXMAP$.MODULE$.equals(messageFormat)) {
                int mapLen = b & 0xF;
                count += mapLen * 2;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$FIXARRAY$.MODULE$.equals(messageFormat)) {
                int arrayLen = b & 0xF;
                count += arrayLen;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$FIXSTR$.MODULE$.equals(messageFormat)) {
                int strLen = b & 0x1F;
                this.skipPayload(cursor, strLen);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boolean bl2 = MessageFormat$INT8$.MODULE$.equals(messageFormat) ? true : MessageFormat$UINT8$.MODULE$.equals(messageFormat);
            if (bl2) {
                this.skipPayload(cursor, 1);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boolean bl3 = MessageFormat$INT16$.MODULE$.equals(messageFormat) ? true : MessageFormat$UINT16$.MODULE$.equals(messageFormat);
            if (bl3) {
                this.skipPayload(cursor, 2);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boolean bl4 = MessageFormat$INT32$.MODULE$.equals(messageFormat) ? true : (MessageFormat$UINT32$.MODULE$.equals(messageFormat) ? true : MessageFormat$FLOAT32$.MODULE$.equals(messageFormat));
            if (bl4) {
                this.skipPayload(cursor, 4);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boolean bl5 = MessageFormat$INT64$.MODULE$.equals(messageFormat) ? true : (MessageFormat$UINT64$.MODULE$.equals(messageFormat) ? true : MessageFormat$FLOAT64$.MODULE$.equals(messageFormat));
            if (bl5) {
                this.skipPayload(cursor, 8);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boolean bl6 = MessageFormat$BIN8$.MODULE$.equals(messageFormat) ? true : MessageFormat$STR8$.MODULE$.equals(messageFormat);
            if (bl6) {
                this.skipPayload(cursor, this.readNextLength8(cursor));
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boolean bl7 = MessageFormat$BIN16$.MODULE$.equals(messageFormat) ? true : MessageFormat$STR16$.MODULE$.equals(messageFormat);
            if (bl7) {
                this.skipPayload(cursor, this.readNextLength16(cursor));
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boolean bl8 = MessageFormat$BIN32$.MODULE$.equals(messageFormat) ? true : MessageFormat$STR32$.MODULE$.equals(messageFormat);
            if (bl8) {
                this.skipPayload(cursor, this.readNextLength32(cursor));
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$FIXEXT1$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, 2);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$FIXEXT2$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, 3);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$FIXEXT4$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, 5);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$FIXEXT8$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, 9);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$FIXEXT16$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, 17);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$EXT8$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, this.readNextLength8(cursor) + 1);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$EXT16$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, this.readNextLength16(cursor) + 1);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$EXT32$.MODULE$.equals(messageFormat)) {
                this.skipPayload(cursor, this.readNextLength32(cursor) + 1);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$ARRAY16$.MODULE$.equals(messageFormat)) {
                count += this.readNextLength16(cursor);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$ARRAY32$.MODULE$.equals(messageFormat)) {
                count += this.readNextLength32(cursor);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$MAP16$.MODULE$.equals(messageFormat)) {
                count += this.readNextLength16(cursor) * 2;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$MAP32$.MODULE$.equals(messageFormat)) {
                count += this.readNextLength32(cursor) * 2;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (MessageFormat$NEVER_USED$.MODULE$.equals(messageFormat)) {
                throw new MessageException(ErrorCode$NEVER_USED_FORMAT$.MODULE$, "Found 0xC1 (NEVER_USED) byte while skipping a value", MessageException$.MODULE$.$lessinit$greater$default$3());
            }
            throw new MatchError((Object)messageFormat);
        }
    }

    public int skipValue$default$2() {
        return 1;
    }

    public void skipPayload(ReadCursor cursor, int numBytes) {
        cursor.skipBytes(numBytes);
    }

    public Value unpackValue(ReadCursor cursor) {
        Value value;
        byte b = cursor.peekByte();
        MessageFormat mf = MessageFormat$.MODULE$.of(b);
        ValueType valueType = mf.valueType();
        if (ValueType$NIL$.MODULE$.equals(valueType)) {
            cursor.skipBytes(1);
            value = Value$NilValue$.MODULE$;
        } else if (ValueType$BOOLEAN$.MODULE$.equals(valueType)) {
            value = new Value.BooleanValue(this.unpackBoolean(cursor));
        } else if (ValueType$INTEGER$.MODULE$.equals(valueType)) {
            MessageFormat messageFormat = mf;
            Product product = MessageFormat$UINT64$.MODULE$.equals(messageFormat) ? new Value.BigIntegerValue(this.unpackBigInteger(cursor)) : new Value.LongValue(this.unpackLong(cursor));
            value = product;
        } else if (ValueType$FLOAT$.MODULE$.equals(valueType)) {
            value = new Value.DoubleValue(this.unpackDouble(cursor));
        } else if (ValueType$STRING$.MODULE$.equals(valueType)) {
            value = new Value.StringValue(this.unpackString(cursor));
        } else if (ValueType$BINARY$.MODULE$.equals(valueType)) {
            int binaryLength = this.unpackBinaryHeader(cursor);
            byte[] data = this.readPayload(cursor, binaryLength);
            value = new Value.BinaryValue(data);
        } else if (ValueType$EXTENSION$.MODULE$.equals(valueType)) {
            ExtTypeHeader extHeader = this.unpackExtTypeHeader(cursor);
            value = this.unpackExt(extHeader, cursor);
        } else if (ValueType$ARRAY$.MODULE$.equals(valueType)) {
            int arrayLength = this.unpackArrayHeader(cursor);
            Builder arr = package$.MODULE$.IndexedSeq().newBuilder();
            arr.sizeHint(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                arr.$plus$eq((Object)this.unpackValue(cursor));
            }
            value = new Value.ArrayValue((IndexedSeq<Value>)((IndexedSeq)arr.result()));
        } else if (ValueType$MAP$.MODULE$.equals(valueType)) {
            boolean readLen = false;
            int mapLength = this.unpackMapHeader(cursor);
            Builder map = ListMap$.MODULE$.newBuilder();
            map.sizeHint(mapLength);
            for (int i = 0; i < mapLength; ++i) {
                Value key = this.unpackValue(cursor);
                Value value2 = this.unpackValue(cursor);
                map.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value2));
            }
            value = new Value.MapValue((Map<Value, Value>)((Map)map.result()));
        } else {
            throw new MatchError((Object)valueType);
        }
        return value;
    }

    public Value unpackExt(ExtTypeHeader extHeader, ReadCursor cursor) {
        Product product;
        if (extHeader.extType() == Code$.MODULE$.EXT_TIMESTAMP()) {
            Instant instant = this.unpackTimestamp(extHeader, cursor);
            product = new Value.TimestampValue(instant);
        } else {
            byte[] extData = this.readPayload(cursor, extHeader.byteLength());
            product = new Value.ExtensionValue(extHeader.extType(), extData);
        }
        return product;
    }

    public void unpackNil(ReadCursor cursor) {
        byte by = cursor.readByte();
        if (Code$.MODULE$.NIL() != by) {
            cursor.reverseCursor();
            throw this.unexpected(ValueType$NIL$.MODULE$, by);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public boolean tryUnpackNil(ReadCursor cursor) {
        boolean bl;
        byte by = cursor.readByte();
        if (Code$.MODULE$.NIL() == by) {
            bl = true;
        } else {
            cursor.reverseCursor();
            bl = false;
        }
        return bl;
    }

    public boolean unpackBoolean(ReadCursor cursor) {
        boolean bl;
        byte by = cursor.readByte();
        if (Code$.MODULE$.FALSE() == by) {
            bl = false;
        } else if (Code$.MODULE$.TRUE() == by) {
            bl = true;
        } else {
            cursor.reverseCursor();
            throw this.unexpected(ValueType$BOOLEAN$.MODULE$, by);
        }
        return bl;
    }

    public byte unpackByte(ReadCursor cursor) {
        byte by;
        byte b = cursor.readByte();
        byte by2 = b;
        if (Code$.MODULE$.isFixInt(by2)) {
            by = by2;
        } else if (Code$.MODULE$.UINT8() == by2) {
            byte u8 = cursor.readByte();
            if (u8 < 0) {
                throw MessageException$.MODULE$.overflowU8(u8);
            }
            by = u8;
        } else if (Code$.MODULE$.UINT16() == by2) {
            short u16 = cursor.readShort();
            if (u16 < 0 || !new RichShort(Predef$.MODULE$.shortWrapper(u16)).isValidByte()) {
                throw MessageException$.MODULE$.overflowU16(u16);
            }
            by = (byte)u16;
        } else if (Code$.MODULE$.UINT32() == by2) {
            int u32 = cursor.readInt();
            if (u32 < 0 || !new RichInt(Predef$.MODULE$.intWrapper(u32)).isValidByte()) {
                throw MessageException$.MODULE$.overflowU32(u32);
            }
            by = (byte)u32;
        } else if (Code$.MODULE$.UINT64() == by2) {
            long u64 = cursor.readLong();
            if (u64 < 0L || !RichLong$.MODULE$.isValidByte$extension(Predef$.MODULE$.longWrapper(u64))) {
                throw MessageException$.MODULE$.overflowU64(u64);
            }
            by = (byte)u64;
        } else if (Code$.MODULE$.INT8() == by2) {
            byte i8;
            by = i8 = cursor.readByte();
        } else if (Code$.MODULE$.INT16() == by2) {
            short i16 = cursor.readShort();
            if (!new RichShort(Predef$.MODULE$.shortWrapper(i16)).isValidByte()) {
                throw MessageException$.MODULE$.overflowI16(i16);
            }
            by = (byte)i16;
        } else if (Code$.MODULE$.INT32() == by2) {
            int i32 = cursor.readInt();
            if (!new RichInt(Predef$.MODULE$.intWrapper(i32)).isValidByte()) {
                throw MessageException$.MODULE$.overflowI32(i32);
            }
            by = (byte)i32;
        } else if (Code$.MODULE$.INT64() == by2) {
            long i64 = cursor.readLong();
            if (!RichLong$.MODULE$.isValidByte$extension(Predef$.MODULE$.longWrapper(i64))) {
                throw MessageException$.MODULE$.overflowI64(i64);
            }
            by = (byte)i64;
        } else {
            cursor.reverseCursor();
            throw this.unexpected(ValueType$INTEGER$.MODULE$, b);
        }
        return by;
    }

    public short unpackShort(ReadCursor cursor) {
        short s2;
        short b = cursor.readByte();
        short s3 = b;
        if (Code$.MODULE$.isFixInt((byte)s3)) {
            s2 = s3;
        } else if (Code$.MODULE$.UINT8() == s3) {
            byte u8 = cursor.readByte();
            s2 = (short)(u8 & 0xFF);
        } else if (Code$.MODULE$.UINT16() == s3) {
            short u16 = cursor.readShort();
            if (u16 < 0) {
                throw MessageException$.MODULE$.overflowU16(u16);
            }
            s2 = u16;
        } else if (Code$.MODULE$.UINT32() == s3) {
            int u32 = cursor.readInt();
            if (u32 < 0 || !new RichInt(Predef$.MODULE$.intWrapper(u32)).isValidShort()) {
                throw MessageException$.MODULE$.overflowU32(u32);
            }
            s2 = (short)u32;
        } else if (Code$.MODULE$.UINT64() == s3) {
            long u64 = cursor.readLong();
            if (u64 < 0L || !RichLong$.MODULE$.isValidShort$extension(Predef$.MODULE$.longWrapper(u64))) {
                throw MessageException$.MODULE$.overflowU64(u64);
            }
            s2 = (short)u64;
        } else if (Code$.MODULE$.INT8() == s3) {
            byte i8 = cursor.readByte();
            s2 = i8;
        } else if (Code$.MODULE$.INT16() == s3) {
            short i16;
            s2 = i16 = cursor.readShort();
        } else if (Code$.MODULE$.INT32() == s3) {
            int i32 = cursor.readInt();
            if (!new RichInt(Predef$.MODULE$.intWrapper(i32)).isValidShort()) {
                throw MessageException$.MODULE$.overflowI32(i32);
            }
            s2 = (short)i32;
        } else if (Code$.MODULE$.INT64() == s3) {
            long i64 = cursor.readLong();
            if (!RichLong$.MODULE$.isValidShort$extension(Predef$.MODULE$.longWrapper(i64))) {
                throw MessageException$.MODULE$.overflowI64(i64);
            }
            s2 = (short)i64;
        } else {
            cursor.reverseCursor();
            throw this.unexpected(ValueType$INTEGER$.MODULE$, (byte)b);
        }
        return s2;
    }

    public int unpackInt(ReadCursor cursor) {
        int n;
        int b = cursor.readByte();
        int n2 = b;
        if (Code$.MODULE$.isFixInt((byte)n2)) {
            n = n2;
        } else if (Code$.MODULE$.UINT8() == n2) {
            byte u8 = cursor.readByte();
            n = u8 & 0xFF;
        } else if (Code$.MODULE$.UINT16() == n2) {
            short u16 = cursor.readShort();
            n = u16 & 0xFFFF;
        } else if (Code$.MODULE$.UINT32() == n2) {
            int u32 = cursor.readInt();
            if (u32 < 0) {
                throw MessageException$.MODULE$.overflowU32(u32);
            }
            n = u32;
        } else if (Code$.MODULE$.UINT64() == n2) {
            long u64 = cursor.readLong();
            if (u64 < 0L || !RichLong$.MODULE$.isValidInt$extension(Predef$.MODULE$.longWrapper(u64))) {
                throw MessageException$.MODULE$.overflowU64(u64);
            }
            n = (int)u64;
        } else if (Code$.MODULE$.INT8() == n2) {
            byte i8 = cursor.readByte();
            n = i8;
        } else if (Code$.MODULE$.INT16() == n2) {
            short i16 = cursor.readShort();
            n = i16;
        } else if (Code$.MODULE$.INT32() == n2) {
            int i32;
            n = i32 = cursor.readInt();
        } else if (Code$.MODULE$.INT64() == n2) {
            long i64 = cursor.readLong();
            if (!RichLong$.MODULE$.isValidInt$extension(Predef$.MODULE$.longWrapper(i64))) {
                throw MessageException$.MODULE$.overflowI64(i64);
            }
            n = (int)i64;
        } else {
            cursor.reverseCursor();
            throw this.unexpected(ValueType$INTEGER$.MODULE$, (byte)b);
        }
        return n;
    }

    public long unpackLong(ReadCursor cursor) {
        long l;
        byte b = cursor.readByte();
        byte by = b;
        if (Code$.MODULE$.isFixInt(by)) {
            l = by;
        } else if (Code$.MODULE$.UINT8() == by) {
            byte u8 = cursor.readByte();
            l = u8 & 0xFF;
        } else if (Code$.MODULE$.UINT16() == by) {
            short u16 = cursor.readShort();
            l = u16 & 0xFFFF;
        } else if (Code$.MODULE$.UINT32() == by) {
            int u32 = cursor.readInt();
            l = u32 < 0 ? (long)(u32 & Integer.MAX_VALUE) + 0x80000000L : (long)u32;
        } else if (Code$.MODULE$.UINT64() == by) {
            long u64 = cursor.readLong();
            if (u64 < 0L) {
                throw MessageException$.MODULE$.overflowU64(u64);
            }
            l = u64;
        } else if (Code$.MODULE$.INT8() == by) {
            byte i8 = cursor.readByte();
            l = i8;
        } else if (Code$.MODULE$.INT16() == by) {
            short i16 = cursor.readShort();
            l = i16;
        } else if (Code$.MODULE$.INT32() == by) {
            int i32 = cursor.readInt();
            l = i32;
        } else if (Code$.MODULE$.INT64() == by) {
            long i64;
            l = i64 = cursor.readLong();
        } else {
            cursor.reverseCursor();
            throw this.unexpected(ValueType$INTEGER$.MODULE$, b);
        }
        return l;
    }

    public BigInteger unpackBigInteger(ReadCursor cursor) {
        BigInteger bigInteger;
        byte b = cursor.readByte();
        byte by = b;
        if (Code$.MODULE$.isFixInt(by)) {
            bigInteger = BigInteger.valueOf(by);
        } else if (Code$.MODULE$.UINT8() == by) {
            byte u8 = cursor.readByte();
            bigInteger = BigInteger.valueOf(u8 & 0xFF);
        } else if (Code$.MODULE$.UINT16() == by) {
            short u16 = cursor.readShort();
            bigInteger = BigInteger.valueOf(u16 & 0xFFFF);
        } else if (Code$.MODULE$.UINT32() == by) {
            int u32 = cursor.readInt();
            bigInteger = u32 < 0 ? BigInteger.valueOf((long)(u32 & Integer.MAX_VALUE) + 0x80000000L) : BigInteger.valueOf(u32);
        } else if (Code$.MODULE$.UINT64() == by) {
            long u64 = cursor.readLong();
            bigInteger = u64 < 0L ? BigInteger.valueOf(u64 + Long.MAX_VALUE + 1L).setBit(63) : BigInteger.valueOf(u64);
        } else if (Code$.MODULE$.INT8() == by) {
            byte i8 = cursor.readByte();
            bigInteger = BigInteger.valueOf(i8);
        } else if (Code$.MODULE$.INT16() == by) {
            short i16 = cursor.readShort();
            bigInteger = BigInteger.valueOf(i16);
        } else if (Code$.MODULE$.INT32() == by) {
            int i32 = cursor.readInt();
            bigInteger = BigInteger.valueOf(i32);
        } else if (Code$.MODULE$.INT64() == by) {
            long i64 = cursor.readLong();
            bigInteger = BigInteger.valueOf(i64);
        } else {
            cursor.reverseCursor();
            throw this.unexpected(ValueType$INTEGER$.MODULE$, b);
        }
        return bigInteger;
    }

    public float unpackFloat(ReadCursor cursor) {
        float f;
        byte by = cursor.readByte();
        if (Code$.MODULE$.FLOAT32() == by) {
            float f2;
            f = f2 = cursor.readFloat();
        } else if (Code$.MODULE$.FLOAT64() == by) {
            double d = cursor.readDouble();
            f = (float)d;
        } else {
            cursor.reverseCursor();
            throw this.unexpected(ValueType$FLOAT$.MODULE$, by);
        }
        return f;
    }

    public double unpackDouble(ReadCursor cursor) {
        double d;
        byte by = cursor.readByte();
        if (Code$.MODULE$.FLOAT32() == by) {
            float f = cursor.readFloat();
            d = f;
        } else if (Code$.MODULE$.FLOAT64() == by) {
            double d2;
            d = d2 = cursor.readDouble();
        } else {
            cursor.reverseCursor();
            throw this.unexpected(ValueType$FLOAT$.MODULE$, by);
        }
        return d;
    }

    private int readNextLength8(ReadCursor cursor) {
        byte u8 = cursor.readByte();
        return u8 & 0xFF;
    }

    private int readNextLength16(ReadCursor cursor) {
        short u16 = cursor.readShort();
        return u16 & 0xFFFF;
    }

    /*
     * WARNING - void declaration
     */
    private int readNextLength32(ReadCursor cursor) {
        void var2_2;
        int u32 = cursor.readInt();
        if (u32 < 0) {
            cursor.reverseCursor();
            throw MessageException$.MODULE$.overflowU32Size(u32);
        }
        return (int)var2_2;
    }

    private int tryReadStringHeader(byte b, ReadCursor cursor) {
        byte by = b;
        int n = Code$.MODULE$.STR8() == by ? this.readNextLength8(cursor) : (Code$.MODULE$.STR16() == by ? this.readNextLength16(cursor) : (Code$.MODULE$.STR32() == by ? this.readNextLength32(cursor) : -1));
        return n;
    }

    private int tryReadBinaryHeader(byte b, ReadCursor cursor) {
        byte by = b;
        int n = Code$.MODULE$.BIN8() == by ? this.readNextLength8(cursor) : (Code$.MODULE$.BIN16() == by ? this.readNextLength16(cursor) : (Code$.MODULE$.BIN32() == by ? this.readNextLength32(cursor) : -1));
        return n;
    }

    public int unpackRawStringHeader(ReadCursor cursor) {
        int n;
        byte b = cursor.readByte();
        if (Code$.MODULE$.isFixedRaw(b)) {
            n = b & 0x1F;
        } else {
            int slen = this.tryReadStringHeader(b, cursor);
            if (slen >= 0) {
                n = slen;
            } else {
                int blen = this.tryReadBinaryHeader(b, cursor);
                if (blen >= 0) {
                    n = blen;
                } else {
                    cursor.reverseCursor();
                    throw this.unexpected(ValueType$STRING$.MODULE$, b);
                }
            }
        }
        return n;
    }

    public int unpackBinaryHeader(ReadCursor cursor) {
        int n;
        byte b = cursor.readByte();
        if (Code$.MODULE$.isFixedRaw(b)) {
            n = b & 0x1F;
        } else {
            int blen = this.tryReadBinaryHeader(b, cursor);
            if (blen >= 0) {
                n = blen;
            } else {
                int slen = this.tryReadStringHeader(b, cursor);
                if (slen >= 0) {
                    n = slen;
                } else {
                    cursor.reverseCursor();
                    throw this.unexpected(ValueType$BINARY$.MODULE$, b);
                }
            }
        }
        return n;
    }

    public String unpackString(ReadCursor cursor) {
        String string;
        int len = this.unpackRawStringHeader(cursor);
        int headerLen = cursor.lastReadLength();
        if (len == 0) {
            string = this.EMPTY_STRING();
        } else {
            if (len >= Integer.MAX_VALUE) {
                cursor.reverseCursor();
                throw new TooLargeMessageException(len);
            }
            byte[] str = cursor.readBytes(len);
            string = new String(str, 0, str.length, StandardCharsets.UTF_8);
        }
        return string;
    }

    public int unpackArrayHeader(ReadCursor cursor) {
        int n;
        byte b = cursor.readByte();
        byte by = b;
        if (Code$.MODULE$.isFixedArray(by)) {
            n = by & 0xF;
        } else if (Code$.MODULE$.ARRAY16() == by) {
            int len;
            n = len = this.readNextLength16(cursor);
        } else if (Code$.MODULE$.ARRAY32() == by) {
            int len;
            n = len = this.readNextLength32(cursor);
        } else {
            cursor.reverseCursor();
            throw this.unexpected(ValueType$ARRAY$.MODULE$, b);
        }
        return n;
    }

    public int unpackMapHeader(ReadCursor cursor) {
        int n;
        byte b = cursor.readByte();
        byte by = b;
        if (Code$.MODULE$.isFixedMap(by)) {
            n = by & 0xF;
        } else if (Code$.MODULE$.MAP16() == by) {
            int len;
            n = len = this.readNextLength16(cursor);
        } else if (Code$.MODULE$.MAP32() == by) {
            int len;
            n = len = this.readNextLength32(cursor);
        } else {
            cursor.reverseCursor();
            throw this.unexpected(ValueType$MAP$.MODULE$, b);
        }
        return n;
    }

    public ExtTypeHeader unpackExtTypeHeader(ReadCursor cursor) {
        ExtTypeHeader extTypeHeader;
        byte by = cursor.readByte();
        if (Code$.MODULE$.FIXEXT1() == by) {
            byte tpe = cursor.readByte();
            extTypeHeader = new ExtTypeHeader(tpe, 1);
        } else if (Code$.MODULE$.FIXEXT2() == by) {
            byte tpe = cursor.readByte();
            extTypeHeader = new ExtTypeHeader(tpe, 2);
        } else if (Code$.MODULE$.FIXEXT4() == by) {
            byte tpe = cursor.readByte();
            extTypeHeader = new ExtTypeHeader(tpe, 4);
        } else if (Code$.MODULE$.FIXEXT8() == by) {
            byte tpe = cursor.readByte();
            extTypeHeader = new ExtTypeHeader(tpe, 8);
        } else if (Code$.MODULE$.FIXEXT16() == by) {
            byte tpe = cursor.readByte();
            extTypeHeader = new ExtTypeHeader(tpe, 16);
        } else if (Code$.MODULE$.EXT8() == by) {
            byte u8 = cursor.readByte();
            int len = u8 & 0xFF;
            byte tpe = cursor.readByte();
            extTypeHeader = new ExtTypeHeader(tpe, len);
        } else if (Code$.MODULE$.EXT16() == by) {
            short u16 = cursor.readShort();
            int len = u16 & 0xFFFF;
            byte tpe = cursor.readByte();
            extTypeHeader = new ExtTypeHeader(tpe, len);
        } else if (Code$.MODULE$.EXT32() == by) {
            int u32 = cursor.readInt();
            if (u32 < 0) {
                cursor.reverseCursor();
                throw MessageException$.MODULE$.overflowU32Size(u32);
            }
            byte tpe = cursor.readByte();
            extTypeHeader = new ExtTypeHeader(tpe, u32);
        } else {
            cursor.reverseCursor();
            throw this.unexpected(ValueType$EXTENSION$.MODULE$, by);
        }
        return extTypeHeader;
    }

    /*
     * WARNING - void declaration
     */
    public Instant unpackTimestamp(ReadCursor cursor) {
        void var3_3;
        ExtTypeHeader extTypeHeader = this.unpackExtTypeHeader(cursor);
        Instant instant = this.unpackTimestamp(extTypeHeader, cursor);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Instant unpackTimestamp(ExtTypeHeader extTypeHeader, ReadCursor cursor) {
        void var3_10;
        Instant instant;
        if (extTypeHeader.extType() != Code$.MODULE$.EXT_TIMESTAMP()) {
            cursor.reverseCursor();
            throw this.unexpected(ValueType$EXTENSION$.MODULE$, extTypeHeader.extType());
        }
        int n = extTypeHeader.byteLength();
        switch (n) {
            case 4: {
                long u32 = (long)cursor.readInt() & 0xFFFFFFFFL;
                instant = Instant.ofEpochSecond(u32);
                break;
            }
            case 8: {
                long d64 = cursor.readLong();
                long sec = d64 & 0x3FFFFFFFFL;
                int nsec = (int)(d64 >>> 34);
                instant = Instant.ofEpochSecond(sec, nsec);
                break;
            }
            case 12: {
                long nsecU32 = (long)cursor.readInt() & 0xFFFFFFFFL;
                long sec = cursor.readLong();
                instant = Instant.ofEpochSecond(sec, nsecU32);
                break;
            }
            default: {
                cursor.reverseCursor();
                throw new MessageException(ErrorCode$INVALID_EXT_FORMAT$.MODULE$, new StringBuilder(66).append("Timestamp type expects 4, 8, or 12 bytes of payload but got ").append(n).append(" bytes").toString(), MessageException$.MODULE$.$lessinit$greater$default$3());
            }
        }
        Instant instant2 = instant;
        return var3_10;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] readPayload(ReadCursor cursor, int length) {
        void var3_3;
        byte[] data = cursor.readBytes(length);
        return var3_3;
    }

    public void readPayload(ReadCursor cursor, int length, byte[] dest, int destOffset) {
        cursor.readBytes(length, dest, destOffset);
    }

    public ReadBuffer readPayload(ReadCursor cursor, int length, WriteBuffer dest, int destIndex) {
        cursor.readBytes(length, dest, destIndex);
        return dest.slice(destIndex, length);
    }

    private String EMPTY_STRING() {
        return this.EMPTY_STRING;
    }

    public Nothing$ unexpected(ValueType expectedCode, byte actual) {
        MessageFormat f;
        MessageFormat messageFormat = f = MessageFormat$.MODULE$.of(actual);
        MessageFormat$NEVER_USED$ messageFormat$NEVER_USED$ = MessageFormat$NEVER_USED$.MODULE$;
        if (!(messageFormat != null ? !messageFormat.equals(messageFormat$NEVER_USED$) : messageFormat$NEVER_USED$ != null)) {
            throw new MessageException(ErrorCode$NEVER_USED_FORMAT$.MODULE$, new StringBuilder(43).append("Expected ").append(expectedCode).append(", but found 0xC1 (NEVER_USED) byte").toString(), MessageException$.MODULE$.$lessinit$greater$default$3());
        }
        String name = f.valueType().name();
        String typeName = new StringBuilder(0).append(name.substring(0, 1)).append(name.substring(1).toLowerCase()).toString();
        ValueType arg$macro$1 = expectedCode;
        String arg$macro$2 = typeName;
        byte arg$macro$3 = actual;
        throw new MessageException(ErrorCode$INVALID_TYPE$.MODULE$, new StringOps("Expected %s, but got %s (%02x)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, BoxesRunTime.boxToByte((byte)arg$macro$3)})), MessageException$.MODULE$.$lessinit$greater$default$3());
    }

    private OffsetUnpacker$() {
        MODULE$ = this;
        this.EMPTY_STRING = "";
    }
}

