/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.concurrent.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import wvlet.log.ConsoleLogHandler;
import wvlet.log.ConsoleLogHandler$;
import wvlet.log.LogEnv$;
import wvlet.log.LogFormatter;
import wvlet.log.LogLevel;
import wvlet.log.LogLevel$;
import wvlet.log.Logger;

public final class Logger$
implements scala.Serializable {
    public static Logger$ MODULE$;
    private Map<String, Logger> loggerCache;
    private Logger rootLogger;
    private volatile byte bitmap$0;

    static {
        new Logger$();
    }

    private Map<String, Logger> loggerCache$lzycompute() {
        Logger$ logger$ = this;
        synchronized (logger$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.loggerCache = (Map)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.loggerCache;
    }

    private Map<String, Logger> loggerCache() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.loggerCache$lzycompute() : this.loggerCache;
    }

    private Logger rootLogger$lzycompute() {
        Logger$ logger$ = this;
        synchronized (logger$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String x$1 = "";
                Seq x$2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Handler[]{LogEnv$.MODULE$.defaultHandler()}));
                Option<LogLevel> x$3 = this.initLogger$default$2();
                boolean x$4 = this.initLogger$default$4();
                this.rootLogger = this.initLogger(x$1, x$3, (Seq<Handler>)x$2, x$4);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.rootLogger;
    }

    public Logger rootLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.rootLogger$lzycompute() : this.rootLogger;
    }

    public Logger initLogger(String name, Option<LogLevel> level, Seq<Handler> handlers, boolean useParents) {
        Logger logger = this.apply(name);
        logger.clearHandlers();
        level.foreach((Function1 & Serializable & scala.Serializable)l -> {
            logger.setLogLevel(l);
            return BoxedUnit.UNIT;
        });
        handlers.foreach((Function1 & Serializable & scala.Serializable)h2 -> {
            logger.addHandler(h2);
            return BoxedUnit.UNIT;
        });
        logger.setUseParentHandlers(useParents);
        return logger;
    }

    public <A> Logger of(ClassTag<A> evidence$1) {
        return this.apply(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass().getName());
    }

    public Logger apply(String loggerName) {
        return (Logger)this.loggerCache().getOrElseUpdate((Object)loggerName, (Function0 & Serializable & scala.Serializable)() -> new Logger(loggerName, java.util.logging.Logger.getLogger(loggerName)));
    }

    public LogLevel getDefaultLogLevel() {
        return this.rootLogger().getLogLevel();
    }

    public void setDefaultLogLevel(LogLevel level) {
        this.rootLogger().setLogLevel(level);
    }

    public synchronized void setDefaultFormatter(LogFormatter formatter) {
        this.rootLogger().resetHandler(new ConsoleLogHandler(formatter, ConsoleLogHandler$.MODULE$.$lessinit$greater$default$2()));
    }

    public void setDefaultHandler(Handler handler) {
        this.rootLogger().resetHandler(handler);
    }

    public void resetDefaultLogLevel() {
        this.rootLogger().resetLogLevel();
    }

    public void clearAllHandlers() {
        this.rootLogger().clearAllHandlers();
    }

    public void init() {
        this.clearAllHandlers();
        this.resetDefaultLogLevel();
        this.rootLogger().resetHandler(LogEnv$.MODULE$.defaultHandler());
    }

    public Option<LogLevel> initLogger$default$2() {
        return None$.MODULE$;
    }

    public Seq<Handler> initLogger$default$3() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public boolean initLogger$default$4() {
        return true;
    }

    public void setLogLevels(Properties logLevels) {
        ((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(logLevels).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Logger$.$anonfun$setLogLevels$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            Logger$.$anonfun$setLogLevels$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void scheduleLogLevelScan() {
        LogEnv$.MODULE$.scheduleLogLevelScan();
    }

    public void stopScheduledLogLevelScan() {
        LogEnv$.MODULE$.stopScheduledLogLevelScan();
    }

    public void scanLogLevels() {
        LogEnv$.MODULE$.scanLogLevels();
    }

    public void scanLogLevels(Seq<String> loglevelFileCandidates) {
        LogEnv$.MODULE$.scanLogLevels(loglevelFileCandidates);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$setLogLevels$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$setLogLevels$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String loggerName = (String)tuple2._1();
        String level = (String)tuple2._2();
        Option<LogLevel> option2 = LogLevel$.MODULE$.unapply(level);
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            LogLevel lv = (LogLevel)some.value();
            MODULE$.apply(loggerName).setLogLevel(lv);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
            Console$.MODULE$.err().println(new StringBuilder(35).append("Unknown loglevel ").append(level).append(" is specified for ").append(loggerName).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Logger$() {
        MODULE$ = this;
        package$.MODULE$.props().put((Object)"java.util.logging.manager", (Object)"wvlet.log.AirframeLogManager");
    }
}

