from fontbakery.utils import TEST_FILE
from fontbakery.checkrunner import (
              DEBUG
            , INFO
            , WARN
            , ERROR
            , SKIP
            , PASS
            , FAIL
            )

check_statuses = (ERROR, FAIL, SKIP, PASS, WARN, INFO, DEBUG)

from fontTools.ttLib import TTFont

def test_check_dsig():
  """ Does the font have a DSIG table ? """
  from fontbakery.profiles.dsig import com_google_fonts_check_dsig as check

  # Our reference Cabin Regular font is good (theres a DSIG table declared):
  ttFont = TTFont(TEST_FILE("cabin/Cabin-Regular.ttf"))

  # So it must PASS the check:
  print ("Test PASS with a good font...")
  status, message = list(check(ttFont))[-1]
  assert status == PASS

  # Then we remove the DSIG table so that we get a FAIL:
  print ("Test FAIL with a font lacking a DSIG table...")
  del ttFont['DSIG']
  status, message = list(check(ttFont))[-1]
  assert status == FAIL and message.code == "lacks-signature"
