# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from __future__ import annotations

from darabonba.model import DaraModel

class DescribeVulnerabilityProtectedListRequest(DaraModel):
    def __init__(
        self,
        attack_type: str = None,
        buy_version: int = None,
        current_page: str = None,
        end_time: str = None,
        lang: str = None,
        member_uid: str = None,
        order: str = None,
        page_size: str = None,
        rule_tag: str = None,
        sort_key: str = None,
        source_ip: str = None,
        start_time: str = None,
        user_type: str = None,
        vuln_cve_name: str = None,
        vuln_level: str = None,
        vuln_resource: str = None,
        vuln_status: str = None,
        vuln_type: str = None,
    ):
        # The attack type of the vulnerability prevention event. Valid values:
        # 
        # *   **1**: suspicious connection
        # *   **2**: command execution
        # *   **3**: brute-force attack
        # *   **4**: scanning
        # *   **5**: others
        # *   **6**: information leakage
        # *   **7**: DoS attack
        # *   **8**: buffer overflow attack
        # *   **9**: web attack
        # *   **10**: webshell
        # *   **11**: computer worm
        # *   **12**: mining
        # *   **13**: reverse shell
        # 
        # >  If you do not specify this parameter, the intrusion events of all attack types are queried.
        self.attack_type = attack_type
        # The edition of Cloud Firewall. If you use Cloud Firewall that uses the pay-as-you-go billing method, set the value to 10. You do not need to specify this parameter for other editions.
        self.buy_version = buy_version
        # The number of the page to return. Default value: 1.
        self.current_page = current_page
        # The end of the time range to query. The value is a UNIX timestamp. Unit: seconds.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The language of the content within the response. Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # The UID of the member that is managed by your Alibaba Cloud account.
        self.member_uid = member_uid
        # The order in which you want to sort the queried information. Valid values:
        # 
        # *   **asc**: the ascending order.
        # *   **desc**: the descending order. This is the default value.
        self.order = order
        # The number of entries to return on each page. Maximum value: 50.
        self.page_size = page_size
        # 漏洞标签，取值：
        # 
        #  - **AI**： AI组件相关漏洞
        self.rule_tag = rule_tag
        # The sorting basis. Set the value to **attackCnt**, which indicates the number of attacks.
        self.sort_key = sort_key
        # The IP address of the access source.
        self.source_ip = source_ip
        # The beginning of the time range to query. The value is a UNIX timestamp. Unit: seconds.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The type of the user. Set the value to **buy**, which indicates user of a paid edition of Cloud Firewall.
        self.user_type = user_type
        # The Common Vulnerabilities and Exposures (CVE) ID of the vulnerability.
        self.vuln_cve_name = vuln_cve_name
        # The risk level of the vulnerability. Valid values:
        # 
        # *   **high**
        # *   **medium**
        # *   **low**
        self.vuln_level = vuln_level
        # The number of assets that are affected by the vulnerability.
        self.vuln_resource = vuln_resource
        # The status of vulnerability protection. Valid values:
        # 
        # *   **partProtected**: partially protected
        # *   **protected**: protected
        # *   **unProtected**: unprotected
        self.vuln_status = vuln_status
        # The type of the vulnerability. Valid values:
        # 
        # *   **App**: application vulnerability
        # *   **emg**: urgent vulnerability
        # *   **cms**: Web-CMS vulnerability
        self.vuln_type = vuln_type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        _map = super().to_map()
        if _map is not None:
            result = _map
        if self.attack_type is not None:
            result['AttackType'] = self.attack_type

        if self.buy_version is not None:
            result['BuyVersion'] = self.buy_version

        if self.current_page is not None:
            result['CurrentPage'] = self.current_page

        if self.end_time is not None:
            result['EndTime'] = self.end_time

        if self.lang is not None:
            result['Lang'] = self.lang

        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid

        if self.order is not None:
            result['Order'] = self.order

        if self.page_size is not None:
            result['PageSize'] = self.page_size

        if self.rule_tag is not None:
            result['RuleTag'] = self.rule_tag

        if self.sort_key is not None:
            result['SortKey'] = self.sort_key

        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip

        if self.start_time is not None:
            result['StartTime'] = self.start_time

        if self.user_type is not None:
            result['UserType'] = self.user_type

        if self.vuln_cve_name is not None:
            result['VulnCveName'] = self.vuln_cve_name

        if self.vuln_level is not None:
            result['VulnLevel'] = self.vuln_level

        if self.vuln_resource is not None:
            result['VulnResource'] = self.vuln_resource

        if self.vuln_status is not None:
            result['VulnStatus'] = self.vuln_status

        if self.vuln_type is not None:
            result['VulnType'] = self.vuln_type

        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttackType') is not None:
            self.attack_type = m.get('AttackType')

        if m.get('BuyVersion') is not None:
            self.buy_version = m.get('BuyVersion')

        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')

        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')

        if m.get('Lang') is not None:
            self.lang = m.get('Lang')

        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')

        if m.get('Order') is not None:
            self.order = m.get('Order')

        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')

        if m.get('RuleTag') is not None:
            self.rule_tag = m.get('RuleTag')

        if m.get('SortKey') is not None:
            self.sort_key = m.get('SortKey')

        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')

        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')

        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')

        if m.get('VulnCveName') is not None:
            self.vuln_cve_name = m.get('VulnCveName')

        if m.get('VulnLevel') is not None:
            self.vuln_level = m.get('VulnLevel')

        if m.get('VulnResource') is not None:
            self.vuln_resource = m.get('VulnResource')

        if m.get('VulnStatus') is not None:
            self.vuln_status = m.get('VulnStatus')

        if m.get('VulnType') is not None:
            self.vuln_type = m.get('VulnType')

        return self

