"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserIdentity = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const aws_cognito_identitypool_alpha_1 = require("@aws-cdk/aws-cognito-identitypool-alpha");
const aws_cognito_1 = require("aws-cdk-lib/aws-cognito");
const constructs_1 = require("constructs");
/**
 * Creates an Identity Pool with sane defaults configured.
 */
class UserIdentity extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        // Unless explicitly stated, created a default Cognito User Pool and Web Client.
        if (!props?.userPool) {
            this.userPool = new aws_cognito_1.UserPool(this, "UserPool");
            this.userPoolClient = this.userPool.addClient("WebClient", {
                authFlows: {
                    userPassword: true,
                    userSrp: true,
                },
            });
        }
        else {
            this.userPool = props.userPool;
        }
        this.identityPool = new aws_cognito_identitypool_alpha_1.IdentityPool(this, "IdentityPool", {
            ...props?.identityPoolOptions,
            authenticationProviders: {
                ...props?.identityPoolOptions?.authenticationProviders,
                userPools: [
                    ...(props?.identityPoolOptions?.authenticationProviders?.userPools ||
                        []),
                    ...(!props?.userPool
                        ? [new aws_cognito_identitypool_alpha_1.UserPoolAuthenticationProvider({ userPool: this.userPool })]
                        : []),
                ],
            },
        });
    }
}
exports.UserIdentity = UserIdentity;
_a = JSII_RTTI_SYMBOL_1;
UserIdentity[_a] = { fqn: "@aws-prototyping-sdk/identity.UserIdentity", version: "0.2.9" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXNlci1pZGVudGl0eS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy91c2VyLWlkZW50aXR5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUE7Ozs7Ozs7Ozs7Ozs7O3dIQWN3SDtBQUN4SCw0RkFJaUQ7QUFDakQseURBQW1FO0FBQ25FLDJDQUF1QztBQW1CdkM7O0dBRUc7QUFDSCxNQUFhLFlBQWEsU0FBUSxzQkFBUztJQUt6QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXlCO1FBQ2pFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsZ0ZBQWdGO1FBQ2hGLElBQUksQ0FBQyxLQUFLLEVBQUUsUUFBUSxFQUFFO1lBQ3BCLElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxzQkFBUSxDQUFDLElBQUksRUFBRSxVQUFVLENBQUMsQ0FBQztZQUMvQyxJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLFdBQVcsRUFBRTtnQkFDekQsU0FBUyxFQUFFO29CQUNULFlBQVksRUFBRSxJQUFJO29CQUNsQixPQUFPLEVBQUUsSUFBSTtpQkFDZDthQUNGLENBQUMsQ0FBQztTQUNKO2FBQU07WUFDTCxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7U0FDaEM7UUFFRCxJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksNkNBQVksQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUFFO1lBQ3pELEdBQUcsS0FBSyxFQUFFLG1CQUFtQjtZQUM3Qix1QkFBdUIsRUFBRTtnQkFDdkIsR0FBRyxLQUFLLEVBQUUsbUJBQW1CLEVBQUUsdUJBQXVCO2dCQUN0RCxTQUFTLEVBQUU7b0JBQ1QsR0FBRyxDQUFDLEtBQUssRUFBRSxtQkFBbUIsRUFBRSx1QkFBdUIsRUFBRSxTQUFTO3dCQUNoRSxFQUFFLENBQUM7b0JBQ0wsR0FBRyxDQUFDLENBQUMsS0FBSyxFQUFFLFFBQVE7d0JBQ2xCLENBQUMsQ0FBQyxDQUFDLElBQUksK0RBQThCLENBQUMsRUFBRSxRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7d0JBQ25FLENBQUMsQ0FBQyxFQUFFLENBQUM7aUJBQ1I7YUFDRjtTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBbENILG9DQW1DQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKipcbiBDb3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblxuIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuXG4gWW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZSB3aXRoIHRoZSBMaWNlbnNlLlxuIFlvdSBtYXkgb2J0YWluIGEgY29weSBvZiB0aGUgTGljZW5zZSBhdFxuXG4gaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG5cbiBVbmxlc3MgcmVxdWlyZWQgYnkgYXBwbGljYWJsZSBsYXcgb3IgYWdyZWVkIHRvIGluIHdyaXRpbmcsIHNvZnR3YXJlXG4gZGlzdHJpYnV0ZWQgdW5kZXIgdGhlIExpY2Vuc2UgaXMgZGlzdHJpYnV0ZWQgb24gYW4gXCJBUyBJU1wiIEJBU0lTLFxuIFdJVEhPVVQgV0FSUkFOVElFUyBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBlaXRoZXIgZXhwcmVzcyBvciBpbXBsaWVkLlxuIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlIHNwZWNpZmljIGxhbmd1YWdlIGdvdmVybmluZyBwZXJtaXNzaW9ucyBhbmRcbiBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKiAqL1xuaW1wb3J0IHtcbiAgSWRlbnRpdHlQb29sLFxuICBJZGVudGl0eVBvb2xQcm9wcyxcbiAgVXNlclBvb2xBdXRoZW50aWNhdGlvblByb3ZpZGVyLFxufSBmcm9tIFwiQGF3cy1jZGsvYXdzLWNvZ25pdG8taWRlbnRpdHlwb29sLWFscGhhXCI7XG5pbXBvcnQgeyBVc2VyUG9vbCwgVXNlclBvb2xDbGllbnQgfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWNvZ25pdG9cIjtcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5cbi8qKlxuICogUHJvcGVydGllcyB3aGljaCBjb25maWd1cmVzIHRoZSBJZGVudGl0eSBQb29sLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFVzZXJJZGVudGl0eVByb3BzIHtcbiAgLyoqXG4gICAqIFVzZXIgcHJvdmlkZWQgQ29nbml0byBVc2VyUG9vbC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBhIHVzZXJwb29sIHdpbGwgYmUgY3JlYXRlZC5cbiAgICovXG4gIHJlYWRvbmx5IHVzZXJQb29sPzogVXNlclBvb2w7XG5cbiAgLyoqXG4gICAqIENvbmZpZ3VyYXRpb24gZm9yIHRoZSBJZGVudGl0eSBQb29sLlxuICAgKi9cbiAgcmVhZG9ubHkgaWRlbnRpdHlQb29sT3B0aW9ucz86IElkZW50aXR5UG9vbFByb3BzO1xufVxuXG4vKipcbiAqIENyZWF0ZXMgYW4gSWRlbnRpdHkgUG9vbCB3aXRoIHNhbmUgZGVmYXVsdHMgY29uZmlndXJlZC5cbiAqL1xuZXhwb3J0IGNsYXNzIFVzZXJJZGVudGl0eSBleHRlbmRzIENvbnN0cnVjdCB7XG4gIHB1YmxpYyByZWFkb25seSBpZGVudGl0eVBvb2w6IElkZW50aXR5UG9vbDtcbiAgcHVibGljIHJlYWRvbmx5IHVzZXJQb29sOiBVc2VyUG9vbDtcbiAgcHVibGljIHJlYWRvbmx5IHVzZXJQb29sQ2xpZW50PzogVXNlclBvb2xDbGllbnQ7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM/OiBVc2VySWRlbnRpdHlQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICAvLyBVbmxlc3MgZXhwbGljaXRseSBzdGF0ZWQsIGNyZWF0ZWQgYSBkZWZhdWx0IENvZ25pdG8gVXNlciBQb29sIGFuZCBXZWIgQ2xpZW50LlxuICAgIGlmICghcHJvcHM/LnVzZXJQb29sKSB7XG4gICAgICB0aGlzLnVzZXJQb29sID0gbmV3IFVzZXJQb29sKHRoaXMsIFwiVXNlclBvb2xcIik7XG4gICAgICB0aGlzLnVzZXJQb29sQ2xpZW50ID0gdGhpcy51c2VyUG9vbC5hZGRDbGllbnQoXCJXZWJDbGllbnRcIiwge1xuICAgICAgICBhdXRoRmxvd3M6IHtcbiAgICAgICAgICB1c2VyUGFzc3dvcmQ6IHRydWUsXG4gICAgICAgICAgdXNlclNycDogdHJ1ZSxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLnVzZXJQb29sID0gcHJvcHMudXNlclBvb2w7XG4gICAgfVxuXG4gICAgdGhpcy5pZGVudGl0eVBvb2wgPSBuZXcgSWRlbnRpdHlQb29sKHRoaXMsIFwiSWRlbnRpdHlQb29sXCIsIHtcbiAgICAgIC4uLnByb3BzPy5pZGVudGl0eVBvb2xPcHRpb25zLFxuICAgICAgYXV0aGVudGljYXRpb25Qcm92aWRlcnM6IHtcbiAgICAgICAgLi4ucHJvcHM/LmlkZW50aXR5UG9vbE9wdGlvbnM/LmF1dGhlbnRpY2F0aW9uUHJvdmlkZXJzLFxuICAgICAgICB1c2VyUG9vbHM6IFtcbiAgICAgICAgICAuLi4ocHJvcHM/LmlkZW50aXR5UG9vbE9wdGlvbnM/LmF1dGhlbnRpY2F0aW9uUHJvdmlkZXJzPy51c2VyUG9vbHMgfHxcbiAgICAgICAgICAgIFtdKSxcbiAgICAgICAgICAuLi4oIXByb3BzPy51c2VyUG9vbFxuICAgICAgICAgICAgPyBbbmV3IFVzZXJQb29sQXV0aGVudGljYXRpb25Qcm92aWRlcih7IHVzZXJQb29sOiB0aGlzLnVzZXJQb29sIH0pXVxuICAgICAgICAgICAgOiBbXSksXG4gICAgICAgIF0sXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG59XG4iXX0=