/*
 * Decompiled with CFR 0.152.
 */
package com.outlyer.jmx.jmxquery;

import com.outlyer.jmx.jmxquery.JMXMetric;
import com.outlyer.jmx.jmxquery.tools.JMXTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.TabularDataSupport;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JMXConnector {
    private javax.management.remote.JMXConnector connector;
    private MBeanServerConnection connection;

    public JMXConnector(String processName) throws IOException {
        this.connectLocalProcess(processName);
    }

    public JMXConnector(String url, String username, String password) throws IOException {
        this.connect(url, username, password);
    }

    private void connectLocalProcess(String processName) throws IOException {
        String url = JMXTools.getLocalJMXConnection(processName);
        this.connect(url, null, null);
    }

    private void connect(String url, String username, String password) throws IOException {
        if (url == null) {
            throw new IOException("Cannot connect to null URL. If connecting via -proc option, check the JVM process name is correct or running.");
        }
        JMXServiceURL jmxUrl = new JMXServiceURL(url);
        if (username != null) {
            HashMap<String, String[]> m = new HashMap<String, String[]>();
            m.put("jmx.remote.credentials", new String[]{username, password});
            this.connector = JMXConnectorFactory.connect(jmxUrl, m);
        } else {
            this.connector = JMXConnectorFactory.connect(jmxUrl);
        }
        this.connection = this.connector.getMBeanServerConnection();
    }

    public void disconnect() throws IOException {
        if (this.connector != null) {
            this.connector.close();
            this.connector = null;
        }
    }

    public ArrayList<JMXMetric> getMetrics(ArrayList<JMXMetric> metricsList) throws IOException, MalformedObjectNameException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        ArrayList<JMXMetric> newMetricList = new ArrayList<JMXMetric>();
        for (JMXMetric metric : metricsList) {
            ArrayList<JMXMetric> fetchedMetrics = this.getMetrics(metric);
            newMetricList.addAll(fetchedMetrics);
        }
        return newMetricList;
    }

    private ArrayList<JMXMetric> getMetrics(JMXMetric metricQuery) throws IOException, MalformedObjectNameException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        ArrayList<JMXMetric> metrics = new ArrayList<JMXMetric>();
        MBeanInfo info = null;
        JMXMetric attributeMetric = null;
        Set<ObjectInstance> instances = this.connection.queryMBeans(new ObjectName(metricQuery.getmBeanName()), null);
        for (ObjectInstance instance : instances) {
            try {
                MBeanAttributeInfo[] attributes;
                info = this.connection.getMBeanInfo(new ObjectName(instance.getObjectName().toString()));
                for (MBeanAttributeInfo attribute : attributes = info.getAttributes()) {
                    attributeMetric = new JMXMetric(instance.getObjectName().toString(), attribute.getName(), null);
                    attributeMetric.setmetricName(metricQuery.getmetricName());
                    attributeMetric.setmetricLabels(metricQuery.getmetricLabels());
                    if (metricQuery.getAttribute() != null && !metricQuery.getAttribute().equals("*")) {
                        if (!attribute.getName().equals(metricQuery.getAttribute())) continue;
                        attributeMetric.setAttributeType(attribute.getType());
                        attributeMetric.setAttribute(attribute.getName());
                        metrics.addAll(this.getAttributes(attributeMetric));
                        continue;
                    }
                    attributeMetric.setAttributeType(attribute.getType());
                    attributeMetric.setAttribute(attribute.getName());
                    metrics.addAll(this.getAttributes(attributeMetric));
                }
            }
            catch (NullPointerException e) {
                attributeMetric.setAttributeType(null);
                attributeMetric.setValue(null);
                metrics.add(attributeMetric);
            }
        }
        return metrics;
    }

    private ArrayList<JMXMetric> getAttributes(JMXMetric attribute) {
        return this.getAttributes(attribute, null);
    }

    private ArrayList<JMXMetric> getAttributes(JMXMetric attribute, Object value) {
        ArrayList<JMXMetric> attributes = new ArrayList<JMXMetric>();
        if (value == null) {
            try {
                value = this.connection.getAttribute(new ObjectName(attribute.getmBeanName()), attribute.getAttribute());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value instanceof CompositeData) {
            CompositeData cData = (CompositeData)value;
            if (attribute.getAttributeKey() != null) {
                try {
                    JMXMetric foundKey = new JMXMetric(attribute.getmBeanName(), attribute.getAttribute(), attribute.getAttributeKey());
                    foundKey.setAttributeType(cData.get(attribute.getAttributeKey()));
                    foundKey.setmetricName(attribute.getmetricName());
                    foundKey.setmetricLabels(attribute.getmetricLabels());
                    attributes.addAll(this.getAttributes(foundKey, cData.get(attribute.getAttributeKey())));
                }
                catch (InvalidKeyException foundKey) {}
            } else {
                Set<String> keys = cData.getCompositeType().keySet();
                for (String key : keys) {
                    JMXMetric foundKey = new JMXMetric(attribute.getmBeanName(), attribute.getAttribute(), key);
                    foundKey.setAttributeType(cData.get(key));
                    foundKey.setmetricName(attribute.getmetricName());
                    foundKey.setmetricLabels(attribute.getmetricLabels());
                    attributes.addAll(this.getAttributes(foundKey, cData.get(key)));
                }
            }
        } else if (value instanceof TabularDataSupport) {
            attribute.setAttributeType(value);
            attributes.add(attribute);
        } else {
            attribute.setAttributeType(value);
            attribute.setValue(value);
            attributes.add(attribute);
        }
        return attributes;
    }
}

