/*
 * Decompiled with CFR 0.152.
 */
package com.outlyer.jmx.jmxquery.tests;

import com.outlyer.jmx.jmxquery.JMXMetric;
import com.outlyer.jmx.jmxquery.ParseError;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JMXParserTest {
    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testMetricNameOptional() throws ParseError {
        String q = "java.lang:type=Memory/HeapMemoryUsage/used";
        JMXMetric m = new JMXMetric(q);
        Assert.assertEquals(null, (Object)m.getmetricName());
        Assert.assertEquals((Object)0, (Object)m.getmetricLabels().size());
        Assert.assertEquals((Object)"java.lang:type=Memory", (Object)m.getmBeanName());
        Assert.assertEquals((Object)"HeapMemoryUsage", (Object)m.getAttribute());
        Assert.assertEquals((Object)"used", (Object)m.getAttributeKey());
        Assert.assertEquals((Object)"java.lang:type=Memory/HeapMemoryUsage/used", (Object)m.toString());
    }

    @Test
    public void testMetricNameWithoutLabels() throws ParseError {
        String q = "java_{token}_name==java.lang:type=Memory/HeapMemoryUsage/used";
        JMXMetric m = new JMXMetric(q);
        Assert.assertEquals((Object)"java_{token}_name", (Object)m.getmetricName());
        Assert.assertEquals((Object)0, (Object)m.getmetricLabels().size());
        Assert.assertEquals((Object)"java.lang:type=Memory", (Object)m.getmBeanName());
        Assert.assertEquals((Object)"HeapMemoryUsage", (Object)m.getAttribute());
        Assert.assertEquals((Object)"used", (Object)m.getAttributeKey());
        Assert.assertEquals((Object)"java_{token}_name<>", (Object)m.toString());
    }

    @Test
    public void testMetricNameWithLabels() throws ParseError {
        String q = "java_{token}_name<label1={token},label2=value>==java.lang:type=Memory/HeapMemoryUsage/used";
        JMXMetric m = new JMXMetric(q);
        Assert.assertEquals((Object)"java_{token}_name", (Object)m.getmetricName());
        Assert.assertEquals((Object)2, (Object)m.getmetricLabels().size());
        Assert.assertEquals((Object)"{token}", (Object)m.getmetricLabels().get("label1"));
        Assert.assertEquals((Object)"value", (Object)m.getmetricLabels().get("label2"));
        Assert.assertEquals((Object)"java.lang:type=Memory", (Object)m.getmBeanName());
        Assert.assertEquals((Object)"HeapMemoryUsage", (Object)m.getAttribute());
        Assert.assertEquals((Object)"used", (Object)m.getAttributeKey());
        Assert.assertEquals((Object)"java_{token}_name<label1={token},label2=value>", (Object)m.toString());
    }

    @Test
    public void testTokenReplacements() throws ParseError {
        String q = "tomcat_{attribute}_{attributeKey}<host={host},type={type},name={name}>==Tomcat:type=DataSource,context=/,host=localhost,class=javax.sql.DataSource,name=\"jdbc/storage\"/numIdle/key";
        JMXMetric m = new JMXMetric(q);
        Assert.assertEquals((Object)"Tomcat:type=DataSource,context=/,host=localhost,class=javax.sql.DataSource,name=\"jdbc/storage\"", (Object)m.getmBeanName());
        Assert.assertEquals((Object)"numIdle", (Object)m.getAttribute());
        Assert.assertEquals((Object)"key", (Object)m.getAttributeKey());
        Assert.assertEquals((Object)"tomcat_{attribute}_{attributeKey}", (Object)m.getmetricName());
        Assert.assertEquals((Object)"{host}", (Object)m.getmetricLabels().get("host"));
        Assert.assertEquals((Object)"{type}", (Object)m.getmetricLabels().get("type"));
        Assert.assertEquals((Object)"{name}", (Object)m.getmetricLabels().get("name"));
        m.replaceTokens();
        Assert.assertEquals((Object)"tomcat_numIdle_key", (Object)m.getmetricName());
        Assert.assertEquals((Object)"localhost", (Object)m.getmetricLabels().get("host"));
        Assert.assertEquals((Object)"DataSource", (Object)m.getmetricLabels().get("type"));
        Assert.assertEquals((Object)"jdbc/storage", (Object)m.getmetricLabels().get("name"));
        Assert.assertEquals((Object)"tomcat_numIdle_key<host=localhost,name=jdbc/storage,type=DataSource>", (Object)m.toString());
    }

    @Test
    public void testSlashesInsidePath() throws ParseError {
        String q = "Tomcat:type=DataSource,context=/,host=localhost,class=javax.sql.DataSource,name=\"jdbc/storage\"/numIdle";
        JMXMetric m = new JMXMetric(q);
        Assert.assertEquals((Object)"Tomcat:type=DataSource,context=/,host=localhost,class=javax.sql.DataSource,name=\"jdbc/storage\"", (Object)m.getmBeanName());
        Assert.assertEquals((Object)"numIdle", (Object)m.getAttribute());
    }

    @Test
    public void testAttributeKey() throws ParseError {
        String q = "java.lang:type=Memory/HeapMemoryUsage/used";
        JMXMetric m = new JMXMetric(q);
        Assert.assertEquals((Object)"java.lang:type=Memory", (Object)m.getmBeanName());
        Assert.assertEquals((Object)"HeapMemoryUsage", (Object)m.getAttribute());
        Assert.assertEquals((Object)"used", (Object)m.getAttributeKey());
    }
}

