# Generated by Django 4.0.7 on 2022-08-13 09:01

import cjkcms.blocks.base_blocks
import cjkcms.blocks.html_blocks
import cjkcms.fields
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import modelcluster.contrib.taggit
import modelcluster.fields
import wagtail.blocks
import wagtail.contrib.table_block.blocks
import wagtail.documents.blocks
import wagtail.embeds.blocks
import wagtail.fields
import wagtail.images.blocks
import wagtail.snippets.blocks
import wagtailcache.cache


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('wagtailcore', '0069_log_entry_jsonfield'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('wagtailimages', '0024_index_image_file_hash'),
        ('taggit', '0004_alter_taggeditem_content_type_alter_taggeditem_tag'),
    ]

    operations = [
        migrations.CreateModel(
            name='Accordion',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
            ],
            options={
                'verbose_name': 'Accordion',
                'verbose_name_plural': 'Accordions',
            },
        ),
        migrations.CreateModel(
            name='Carousel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('show_controls', models.BooleanField(default=True, help_text='Shows arrows on the left and right of the carousel to advance next or previous slides.', verbose_name='Show controls')),
                ('show_indicators', models.BooleanField(default=True, help_text='Shows small indicators at the bottom of the carousel based on the number of slides.', verbose_name='Show indicators')),
                ('animation', models.CharField(blank=True, default='', help_text='The animation when transitioning between slides.', max_length=20, verbose_name='Animation')),
            ],
            options={
                'verbose_name': 'Carousel',
            },
        ),
        migrations.CreateModel(
            name='CjkcmsPage',
            fields=[
                ('page_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='wagtailcore.page')),
                ('canonical_url', models.URLField(blank=True, help_text="Leave blank to use the page's URL.", max_length=255, verbose_name='Canonical URL')),
                ('struct_org_type', models.CharField(blank=True, choices=[('Organization', 'Organization'), ('Airline', 'Organization > Airline'), ('Corporation', 'Organization > Corporation'), ('EducationalOrganization', 'Organization > EducationalOrganization'), ('CollegeOrUniversity', 'Organization > EducationalOrganization > CollegeOrUniversity'), ('ElementarySchool', 'Organization > EducationalOrganization > ElementarySchool'), ('HighSchool', 'Organization > EducationalOrganization > HighSchool'), ('MiddleSchool', 'Organization > EducationalOrganization > MiddleSchool'), ('Preschool', 'Organization > EducationalOrganization > Preschool'), ('School', 'Organization > EducationalOrganization > School'), ('GovernmentOrganization', 'Organization > GovernmentOrganization'), ('LocalBusiness', 'Organization > LocalBusiness'), ('AnimalShelter', 'Organization > LocalBusiness > AnimalShelter'), ('AutomotiveBusiness', 'Organization > LocalBusiness > AutomotiveBusiness'), ('AutoBodyShop', 'Organization > LocalBusiness > AutomotiveBusiness > AutoBodyShop'), ('AutoDealer', 'Organization > LocalBusiness > AutomotiveBusiness > AutoDealer'), ('AutoPartsStore', 'Organization > LocalBusiness > AutomotiveBusiness > AutoPartsStore'), ('AutoRental', 'Organization > LocalBusiness > AutomotiveBusiness > AutoRental'), ('AutoRepair', 'Organization > LocalBusiness > AutomotiveBusiness > AutoRepair'), ('AutoWash', 'Organization > LocalBusiness > AutomotiveBusiness > AutoWash'), ('GasStation', 'Organization > LocalBusiness > AutomotiveBusiness > GasStation'), ('MotorcycleDealer', 'Organization > LocalBusiness > AutomotiveBusiness > MotorcycleDealer'), ('MotorcycleRepair', 'Organization > LocalBusiness > AutomotiveBusiness > MotorcycleRepair'), ('ChildCare', 'Organization > LocalBusiness > ChildCare'), ('Dentist', 'Organization > LocalBusiness > Dentist'), ('DryCleaningOrLaundry', 'Organization > LocalBusiness > DryCleaningOrLaundry'), ('EmergencyService', 'Organization > LocalBusiness > EmergencyService'), ('FireStation', 'Organization > LocalBusiness > EmergencyService > FireStation'), ('Hospital', 'Organization > LocalBusiness > EmergencyService > Hospital'), ('PoliceStation', 'Organization > LocalBusiness > EmergencyService > PoliceStation'), ('EmploymentAgency', 'Organization > LocalBusiness > EmploymentAgency'), ('EntertainmentBusiness', 'Organization > LocalBusiness > EntertainmentBusiness'), ('AdultEntertainment', 'Organization > LocalBusiness > EntertainmentBusiness > AdultEntertainment'), ('AmusementPark', 'Organization > LocalBusiness > EntertainmentBusiness > AmusementPark'), ('ArtGallery', 'Organization > LocalBusiness > EntertainmentBusiness > ArtGallery'), ('Casino', 'Organization > LocalBusiness > EntertainmentBusiness > Casino'), ('ComedyClub', 'Organization > LocalBusiness > EntertainmentBusiness > ComedyClub'), ('MovieTheater', 'Organization > LocalBusiness > EntertainmentBusiness > MovieTheater'), ('NightClub', 'Organization > LocalBusiness > EntertainmentBusiness > NightClub'), ('FinancialService', 'Organization > LocalBusiness > FinancialService'), ('AccountingService', 'Organization > LocalBusiness > FinancialService > AccountingService'), ('AutomatedTeller', 'Organization > LocalBusiness > FinancialService > AutomatedTeller'), ('BankOrCreditUnion', 'Organization > LocalBusiness > FinancialService > BankOrCreditUnion'), ('InsuranceAgency', 'Organization > LocalBusiness > FinancialService > InsuranceAgency'), ('FoodEstablishment', 'Organization > LocalBusiness > FoodEstablishment'), ('Bakery', 'Organization > LocalBusiness > FoodEstablishment > Bakery'), ('BarOrPub', 'Organization > LocalBusiness > FoodEstablishment > BarOrPub'), ('Brewery', 'Organization > LocalBusiness > FoodEstablishment > Brewery'), ('CafeOrCoffeeShop', 'Organization > LocalBusiness > FoodEstablishment > CafeOrCoffeeShop'), ('FastFoodRestaurant', 'Organization > LocalBusiness > FoodEstablishment > FastFoodRestaurant'), ('IceCreamShop', 'Organization > LocalBusiness > FoodEstablishment > IceCreamShop'), ('Restaurant', 'Organization > LocalBusiness > FoodEstablishment > Restaurant'), ('Winery', 'Organization > LocalBusiness > FoodEstablishment > Winery'), ('GovernmentOffice', 'Organization > LocalBusiness > GovernmentOffice'), ('PostOffice', 'Organization > LocalBusiness > GovernmentOffice > PostOffice'), ('HealthAndBeautyBusiness', 'Organization > LocalBusiness > HealthAndBeautyBusiness'), ('BeautySalon', 'Organization > LocalBusiness > HealthAndBeautyBusiness > BeautySalon'), ('DaySpa', 'Organization > LocalBusiness > HealthAndBeautyBusiness > DaySpa'), ('HairSalon', 'Organization > LocalBusiness > HealthAndBeautyBusiness > HairSalon'), ('HealthClub', 'Organization > LocalBusiness > HealthAndBeautyBusiness > HealthClub'), ('NailSalon', 'Organization > LocalBusiness > HealthAndBeautyBusiness > NailSalon'), ('TattooParlor', 'Organization > LocalBusiness > HealthAndBeautyBusiness > TattooParlor'), ('HomeAndConstructionBusiness', 'Organization > LocalBusiness > HomeAndConstructionBusiness'), ('Electrician', 'Organization > LocalBusiness > HomeAndConstructionBusiness > Electrician'), ('GeneralContractor', 'Organization > LocalBusiness > HomeAndConstructionBusiness > GeneralContractor'), ('HVACBusiness', 'Organization > LocalBusiness > HomeAndConstructionBusiness > HVACBusiness'), ('HousePainter', 'Organization > LocalBusiness > HomeAndConstructionBusiness > HousePainter'), ('Locksmith', 'Organization > LocalBusiness > HomeAndConstructionBusiness > Locksmith'), ('MovingCompany', 'Organization > LocalBusiness > HomeAndConstructionBusiness > MovingCompany'), ('Plumber', 'Organization > LocalBusiness > HomeAndConstructionBusiness > Plumber'), ('RoofingContractor', 'Organization > LocalBusiness > HomeAndConstructionBusiness > RoofingContractor'), ('InternetCafe', 'Organization > LocalBusiness > InternetCafe'), ('LegalService', 'Organization > LocalBusiness > LegalService'), ('Attorney', 'Organization > LocalBusiness > LegalService > Attorney'), ('Notary', 'Organization > LocalBusiness > LegalService > Notary'), ('Library', 'Organization > LocalBusiness > Library'), ('LodgingBusiness', 'Organization > LocalBusiness > LodgingBusiness'), ('BedAndBreakfast', 'Organization > LocalBusiness > LodgingBusiness > BedAndBreakfast'), ('Campground', 'Organization > LocalBusiness > LodgingBusiness > Campground'), ('Hostel', 'Organization > LocalBusiness > LodgingBusiness > Hostel'), ('Hotel', 'Organization > LocalBusiness > LodgingBusiness > Hotel'), ('Motel', 'Organization > LocalBusiness > LodgingBusiness > Motel'), ('Resort', 'Organization > LocalBusiness > LodgingBusiness > Resort'), ('ProfessionalService', 'Organization > LocalBusiness > ProfessionalService'), ('RadioStation', 'Organization > LocalBusiness > RadioStation'), ('RealEstateAgent', 'Organization > LocalBusiness > RealEstateAgent'), ('RecyclingCenter', 'Organization > LocalBusiness > RecyclingCenter'), ('SelfStorage', 'Organization > LocalBusiness > SelfStorage'), ('ShoppingCenter', 'Organization > LocalBusiness > ShoppingCenter'), ('SportsActivityLocation', 'Organization > LocalBusiness > SportsActivityLocation'), ('BowlingAlley', 'Organization > LocalBusiness > SportsActivityLocation > BowlingAlley'), ('ExerciseGym', 'Organization > LocalBusiness > SportsActivityLocation > ExerciseGym'), ('GolfCourse', 'Organization > LocalBusiness > SportsActivityLocation > GolfCourse'), ('HealthClub', 'Organization > LocalBusiness > SportsActivityLocation > HealthClub'), ('PublicSwimmingPool', 'Organization > LocalBusiness > SportsActivityLocation > PublicSwimmingPool'), ('SkiResort', 'Organization > LocalBusiness > SportsActivityLocation > SkiResort'), ('SportsClub', 'Organization > LocalBusiness > SportsActivityLocation > SportsClub'), ('StadiumOrArena', 'Organization > LocalBusiness > SportsActivityLocation > StadiumOrArena'), ('TennisComplex', 'Organization > LocalBusiness > SportsActivityLocation > TennisComplex'), ('Store', 'Organization > LocalBusiness > Store'), ('AutoPartsStore', 'Organization > LocalBusiness > Store > AutoPartsStore'), ('BikeStore', 'Organization > LocalBusiness > Store > BikeStore'), ('BookStore', 'Organization > LocalBusiness > Store > BookStore'), ('ClothingStore', 'Organization > LocalBusiness > Store > ClothingStore'), ('ComputerStore', 'Organization > LocalBusiness > Store > ComputerStore'), ('ConvenienceStore', 'Organization > LocalBusiness > Store > ConvenienceStore'), ('DepartmentStore', 'Organization > LocalBusiness > Store > DepartmentStore'), ('ElectronicsStore', 'Organization > LocalBusiness > Store > ElectronicsStore'), ('Florist', 'Organization > LocalBusiness > Store > Florist'), ('FurnitureStore', 'Organization > LocalBusiness > Store > FurnitureStore'), ('GardenStore', 'Organization > LocalBusiness > Store > GardenStore'), ('GroceryStore', 'Organization > LocalBusiness > Store > GroceryStore'), ('HardwareStore', 'Organization > LocalBusiness > Store > HardwareStore'), ('HobbyShop', 'Organization > LocalBusiness > Store > HobbyShop'), ('HomeGoodsStore', 'Organization > LocalBusiness > Store > HomeGoodsStore'), ('JewelryStore', 'Organization > LocalBusiness > Store > JewelryStore'), ('LiquorStore', 'Organization > LocalBusiness > Store > LiquorStore'), ('MensClothingStore', 'Organization > LocalBusiness > Store > MensClothingStore'), ('MobilePhoneStore', 'Organization > LocalBusiness > Store > MobilePhoneStore'), ('MovieRentalStore', 'Organization > LocalBusiness > Store > MovieRentalStore'), ('MusicStore', 'Organization > LocalBusiness > Store > MusicStore'), ('OfficeEquipmentStore', 'Organization > LocalBusiness > Store > OfficeEquipmentStore'), ('OutletStore', 'Organization > LocalBusiness > Store > OutletStore'), ('PawnShop', 'Organization > LocalBusiness > Store > PawnShop'), ('PetStore', 'Organization > LocalBusiness > Store > PetStore'), ('ShoeStore', 'Organization > LocalBusiness > Store > ShoeStore'), ('SportingGoodsStore', 'Organization > LocalBusiness > Store > SportingGoodsStore'), ('TireShop', 'Organization > LocalBusiness > Store > TireShop'), ('ToyStore', 'Organization > LocalBusiness > Store > ToyStore'), ('WholesaleStore', 'Organization > LocalBusiness > Store > WholesaleStore'), ('TelevisionStation', 'Organization > LocalBusiness > TelevisionStation'), ('TouristInformationCenter', 'Organization > LocalBusiness > TouristInformationCenter'), ('TravelAgency', 'Organization > LocalBusiness > TravelAgency'), ('MedicalOrganization', 'Organization > MedicalOrganization'), ('Dentist', 'Organization > MedicalOrganization > Dentist'), ('Hospital', 'Organization > MedicalOrganization > Hospital'), ('Pharmacy', 'Organization > MedicalOrganization > Pharmacy'), ('Physician', 'Organization > MedicalOrganization > Physician'), ('NGO', 'Organization > NGO'), ('PerformingGroup', 'Organization > PerformingGroup'), ('DanceGroup', 'Organization > PerformingGroup > DanceGroup'), ('MusicGroup', 'Organization > PerformingGroup > MusicGroup'), ('TheaterGroup', 'Organization > PerformingGroup > TheaterGroup'), ('SportsOrganization', 'Organization > SportsOrganization'), ('SportsTeam', 'Organization > SportsOrganization > SportsTeam')], default='', help_text='If blank, no structured data will be used on this page.', max_length=255, verbose_name='Organization type')),
                ('struct_org_name', models.CharField(blank=True, default='', help_text='Leave blank to use the site name in Settings > Sites', max_length=255, verbose_name='Organization name')),
                ('struct_org_phone', models.CharField(blank=True, help_text='Include country code for best results. For example: +1-216-555-8000', max_length=255, verbose_name='Telephone number')),
                ('struct_org_address_street', models.CharField(blank=True, help_text='House number and street. For example, 55 Public Square Suite 1710', max_length=255, verbose_name='Street address')),
                ('struct_org_address_locality', models.CharField(blank=True, help_text='City or locality. For example, Cleveland', max_length=255, verbose_name='City')),
                ('struct_org_address_region', models.CharField(blank=True, help_text='State, province, county, or region. For example, OH', max_length=255, verbose_name='State')),
                ('struct_org_address_postal', models.CharField(blank=True, help_text='Zip or postal code. For example, 44113', max_length=255, verbose_name='Postal code')),
                ('struct_org_address_country', models.CharField(blank=True, help_text='For example, USA. Two-letter ISO 3166-1 alpha-2 country code is also acceptable https://en.wikipedia.org/wiki/ISO_3166-1', max_length=255, verbose_name='Country')),
                ('struct_org_geo_lat', models.DecimalField(blank=True, decimal_places=8, max_digits=11, null=True, verbose_name='Geographic latitude')),
                ('struct_org_geo_lng', models.DecimalField(blank=True, decimal_places=8, max_digits=11, null=True, verbose_name='Geographic longitude')),
                ('struct_org_hours', wagtail.fields.StreamField([('hours', wagtail.blocks.StructBlock([('days', wagtail.blocks.MultipleChoiceBlock(choices=[('Monday', 'Monday'), ('Tuesday', 'Tuesday'), ('Wednesday', 'Wednesday'), ('Thursday', 'Thursday'), ('Friday', 'Friday'), ('Saturday', 'Saturday'), ('Sunday', 'Sunday')], help_text='For late night hours past 23:59, define each day in a separate block.', verbose_name='Days')), ('start_time', wagtail.blocks.TimeBlock(verbose_name='Opening time')), ('end_time', wagtail.blocks.TimeBlock(verbose_name='Closing time'))]))], blank=True, use_json_field=True, verbose_name='Hours of operation')),
                ('struct_org_actions', wagtail.fields.StreamField([('actions', wagtail.blocks.StructBlock([('action_type', wagtail.blocks.ChoiceBlock(choices=[('OrderAction', 'OrderAction'), ('ReserveAction', 'ReserveAction')], verbose_name='Action Type')), ('target', wagtail.blocks.URLBlock(verbose_name='Target URL')), ('language', wagtail.blocks.CharBlock(default='en-US', help_text='If the action is offered in multiple languages, create separate actions for each language.', verbose_name='Language')), ('result_type', wagtail.blocks.ChoiceBlock(choices=[('Reservation', 'Reservation'), ('BusReservation', 'BusReservation'), ('EventReservation', 'EventReservation'), ('FlightReservation', 'FlightReservation'), ('FoodEstablishmentReservation', 'FoodEstablishmentReservation'), ('LodgingReservation', 'LodgingReservation'), ('RentalCarReservation', 'RentalCarReservation'), ('ReservationPackage', 'ReservationPackage'), ('TaxiReservation', 'TaxiReservation'), ('TrainReservation', 'TrainReservation')], help_text='Leave blank for OrderAction', required=False, verbose_name='Result Type')), ('result_name', wagtail.blocks.CharBlock(help_text='Example: "Reserve a table", "Book an appointment", etc.', required=False, verbose_name='Result Name')), ('extra_json', wagtail.blocks.RawHTMLBlock(form_classname='monospace', help_text='Additional JSON-LD inserted into the Action dictionary. Must be properties of https://schema.org/Action.', required=False, verbose_name='Additional action markup'))]))], blank=True, use_json_field=True, verbose_name='Actions')),
                ('struct_org_extra_json', models.TextField(blank=True, help_text='Additional JSON-LD inserted into the Organization dictionary. Must be properties of https://schema.org/Organization or the selected organization type.', verbose_name='Additional Organization markup')),
                ('index_show_subpages', models.BooleanField(default=False, verbose_name='Show list of child pages')),
                ('index_order_by', models.CharField(blank=True, choices=[('', 'Default Ordering'), ('-first_published_at', 'Date first published, newest to oldest'), ('first_published_at', 'Date first published, oldest to newest'), ('-last_published_at', 'Date updated, newest to oldest'), ('last_published_at', 'Date updated, oldest to newest'), ('title', 'Title, alphabetical'), ('-title', 'Title, reverse alphabetical')], default='', max_length=255, verbose_name='Order child pages by')),
                ('index_num_per_page', models.PositiveIntegerField(default=10, verbose_name='Number per page')),
                ('custom_template', models.CharField(blank=True, max_length=255, verbose_name='Template')),
            ],
            options={
                'verbose_name': 'CjkCMS Page',
            },
            bases=(wagtailcache.cache.WagtailCacheMixin, 'wagtailcore.page'),
        ),
        migrations.CreateModel(
            name='Classifier',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.SlugField(allow_unicode=True, unique=True, verbose_name='Slug')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
            ],
            options={
                'verbose_name': 'Classifier',
                'verbose_name_plural': 'Classifiers',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Footer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('custom_css_class', models.CharField(blank=True, max_length=255, verbose_name='Custom CSS Class')),
                ('custom_id', models.CharField(blank=True, max_length=255, verbose_name='Custom ID')),
                ('content', cjkcms.fields.CjkcmsStreamField(use_json_field=None, verbose_name='Content')),
            ],
            options={
                'verbose_name': 'Footer',
            },
        ),
        migrations.CreateModel(
            name='LayoutSettings',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('navbar_color_scheme', models.CharField(blank=True, default='', help_text='Optimizes text and other navbar elements for use with light or dark backgrounds.', max_length=50, verbose_name='Navbar color scheme')),
                ('navbar_class', models.CharField(blank=True, default='', help_text='Custom classes applied to navbar e.g. "bg-light", "bg-dark", "bg-primary".', max_length=255, verbose_name='Navbar CSS class')),
                ('navbar_fixed', models.BooleanField(default=False, help_text='Fixed navbar will remain at the top of the page when scrolling.', verbose_name='Fixed navbar')),
                ('navbar_wrapper_fluid', models.BooleanField(default=True, help_text='The navbar will fill edge to edge.', verbose_name='Full width navbar')),
                ('navbar_content_fluid', models.BooleanField(default=False, help_text='Content within the navbar will fill edge to edge.', verbose_name='Full width navbar contents')),
                ('navbar_collapse_mode', models.CharField(blank=True, default='', help_text='Control on what screen sizes to show and collapse the navbar menu links.', max_length=50, verbose_name='Collapse navbar menu')),
                ('navbar_format', models.CharField(blank=True, default='', max_length=50, verbose_name='Navbar format')),
                ('navbar_search', models.BooleanField(default=True, help_text='Show search box in navbar', verbose_name='Search box')),
                ('navbar_langselector', models.BooleanField(default=True, help_text='Show lang choice dropdown in navbar', verbose_name='Language selector')),
                ('frontend_theme', models.CharField(blank=True, default='', help_text='Change the source of your Bootstrap theme.', max_length=50, verbose_name='Theme variant')),
                ('awesome_cdn', models.BooleanField(default=False, help_text='Load font awesome from CND', verbose_name='Font Awesome')),
                ('base_template', models.CharField(blank=True, default='cjkcms/pages/base.html', help_text='Base template used by CMS pages, defaults to CMS built-in one', max_length=200, verbose_name='Base template')),
                ('favicon', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='favicon', to='wagtailimages.image', verbose_name='Favicon')),
                ('logo', models.ForeignKey(blank=True, help_text='Brand logo used in the navbar and throughout the site', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='Logo')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.site')),
            ],
            options={
                'verbose_name': 'Layout',
            },
        ),
        migrations.CreateModel(
            name='Navbar',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('custom_css_class', models.CharField(blank=True, max_length=255, verbose_name='Custom CSS Class')),
                ('custom_id', models.CharField(blank=True, max_length=255, verbose_name='Custom ID')),
                ('menu_items', cjkcms.fields.CjkcmsStreamField(use_json_field=None, verbose_name='Navigation links')),
            ],
            options={
                'verbose_name': 'Navigation Bar',
            },
        ),
        migrations.CreateModel(
            name='ReusableContent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('content', cjkcms.fields.CjkcmsStreamField(use_json_field=True, verbose_name='content')),
            ],
            options={
                'verbose_name': 'Reusable Content',
                'verbose_name_plural': 'Reusable Content',
            },
        ),
        migrations.CreateModel(
            name='ArticleIndexPage',
            fields=[
                ('cjkcmspage_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='cjkcms.cjkcmspage')),
                ('body', wagtail.fields.StreamField([('hero', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.blocks.BooleanBlock(default=True, label='Full width', required=False)), ('is_parallax', wagtail.blocks.BooleanBlock(help_text='Background images scroll slower than foreground images, creating an illusion of depth.', label='Parallax Effect', required=False)), ('background_image', wagtail.images.blocks.ImageChooserBlock(required=False)), ('tile_image', wagtail.blocks.BooleanBlock(default=False, label='Tile background image', required=False)), ('background_color', wagtail.blocks.CharBlock(help_text='Hexadecimal, rgba, or CSS color notation (e.g. #ff0011)', label='Background color', max_length=255, required=False)), ('foreground_color', wagtail.blocks.CharBlock(help_text='Hexadecimal, rgba, or CSS color notation (e.g. #ff0011)', label='Text color', max_length=255, required=False)), ('content', wagtail.blocks.StreamBlock([('row', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.blocks.StreamBlock([('content', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('column_breakpoint', wagtail.blocks.ChoiceBlock(choices=[('', 'Always expanded'), ('sm', 'sm - Expand on small screens (phone, 576px) and larger'), ('md', 'md - Expand on medium screens (tablet, 768px) and larger'), ('lg', 'lg - Expand on large screens (laptop, 992px) and larger'), ('xl', 'xl - Expand on extra large screens (wide monitor, 1200px)')], help_text='Screen size at which the column will expand horizontally or stack vertically.', required=False, verbose_name='Column Breakpoint'))])), ('column_size', wagtail.blocks.ChoiceBlock(choices=[('', 'Automatically size'), ('12', 'Full row'), ('6', 'Half - 1/2 column'), ('4', 'Thirds - 1/3 column'), ('8', 'Thirds - 2/3 column'), ('3', 'Quarters - 1/4 column'), ('9', 'Quarters - 3/4 column'), ('2', 'Sixths - 1/6 column'), ('10', 'Sixths - 5/6 column'), ('1', 'Twelfths - 1/12 column'), ('5', 'Twelfths - 5/12 column'), ('7', 'Twelfths - 7/12 column'), ('11', 'Twelfths - 11/12 column')], label='Column size', required=False)), ('content', wagtail.blocks.StreamBlock([('text', cjkcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))])), ('image', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', cjkcms.blocks.html_blocks.SearchableHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False)), ('automatic_download', wagtail.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('page_list', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/pagelist_block.html', 'General, simple list'), ('cjkcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('cjkcms/blocks/pagelist_article_media.html', 'Article, media format'), ('cjkcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('cjkcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('cjkcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', cjkcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/pagepreview_card.html', 'Card')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))])), ('accordion', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('accordion', wagtail.snippets.blocks.SnippetChooserBlock('cjkcms.Accordion'))])), ('card', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/card_block.html', 'Card'), ('cjkcms/blocks/card_horizontal.html', 'Horizontal Card'), ('cjkcms/blocks/card_head.html', 'Card with header'), ('cjkcms/blocks/card_foot.html', 'Card with footer'), ('cjkcms/blocks/card_head_foot.html', 'Card with header and footer'), ('cjkcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('cjkcms/blocks/card_img.html', 'Cover image - use image as background'), ('cjkcms/blocks/card_landing1.html', 'Landing page style 1'), ('cjkcms/blocks/card_landing2.html', 'Landing page style 2')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.blocks.StreamBlock([('Links', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))]))], blank=True, label='Links', required=False))])), ('carousel', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('carousel', wagtail.snippets.blocks.SnippetChooserBlock('cjkcms.Carousel'))])), ('image_gallery', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('collection', cjkcms.blocks.base_blocks.CollectionChooserBlock(label='Image Collection', required=True))])), ('modal', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False)), ('header', wagtail.blocks.CharBlock(label='Modal heading', max_length=255, required=False)), ('content', wagtail.blocks.StreamBlock([('text', cjkcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))])), ('image', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', cjkcms.blocks.html_blocks.SearchableHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False)), ('automatic_download', wagtail.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('page_list', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/pagelist_block.html', 'General, simple list'), ('cjkcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('cjkcms/blocks/pagelist_article_media.html', 'Article, media format'), ('cjkcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('cjkcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('cjkcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', cjkcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/pagepreview_card.html', 'Card')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))]))], label='Content')), ('footer', wagtail.blocks.StreamBlock([('text', wagtail.blocks.CharBlock(icon='fa-file-text-o', label='Simple Text', max_length=255)), ('button', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))]))], label='Modal footer', required=False))])), ('pricelist', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('heading', wagtail.blocks.CharBlock(label='Heading', max_length=255, required=False)), ('items', wagtail.blocks.StreamBlock([('item', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('name', wagtail.blocks.CharBlock(label='Name', max_length=255, required=True)), ('description', wagtail.blocks.TextBlock(label='Description', required=False, rows=4)), ('price', wagtail.blocks.CharBlock(help_text='Any text here. Include currency sign if desired.', label='Price', required=True))]))], label='Items'))])), ('reusable_content', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('content', wagtail.snippets.blocks.SnippetChooserBlock('cjkcms.ReusableContent'))]))], label='Content'))]))], label='Content'))])), ('cardgrid', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/cardgrid_group.html', 'Card group - attached cards of equal size'), ('cjkcms/blocks/cardgrid_deck.html', 'Card deck - separate cards of equal size'), ('cjkcms/blocks/cardgrid_columns.html', 'Card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.blocks.StreamBlock([('card', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/card_block.html', 'Card'), ('cjkcms/blocks/card_horizontal.html', 'Horizontal Card'), ('cjkcms/blocks/card_head.html', 'Card with header'), ('cjkcms/blocks/card_foot.html', 'Card with footer'), ('cjkcms/blocks/card_head_foot.html', 'Card with header and footer'), ('cjkcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('cjkcms/blocks/card_img.html', 'Cover image - use image as background'), ('cjkcms/blocks/card_landing1.html', 'Landing page style 1'), ('cjkcms/blocks/card_landing2.html', 'Landing page style 2')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.blocks.StreamBlock([('Links', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))]))], blank=True, label='Links', required=False))]))], label='Content'))])), ('html', cjkcms.blocks.html_blocks.SearchableHTMLBlock(form_classname='monospace', icon='code', label='HTML'))], label='Content'))])), ('row', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.blocks.StreamBlock([('content', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('column_breakpoint', wagtail.blocks.ChoiceBlock(choices=[('', 'Always expanded'), ('sm', 'sm - Expand on small screens (phone, 576px) and larger'), ('md', 'md - Expand on medium screens (tablet, 768px) and larger'), ('lg', 'lg - Expand on large screens (laptop, 992px) and larger'), ('xl', 'xl - Expand on extra large screens (wide monitor, 1200px)')], help_text='Screen size at which the column will expand horizontally or stack vertically.', required=False, verbose_name='Column Breakpoint'))])), ('column_size', wagtail.blocks.ChoiceBlock(choices=[('', 'Automatically size'), ('12', 'Full row'), ('6', 'Half - 1/2 column'), ('4', 'Thirds - 1/3 column'), ('8', 'Thirds - 2/3 column'), ('3', 'Quarters - 1/4 column'), ('9', 'Quarters - 3/4 column'), ('2', 'Sixths - 1/6 column'), ('10', 'Sixths - 5/6 column'), ('1', 'Twelfths - 1/12 column'), ('5', 'Twelfths - 5/12 column'), ('7', 'Twelfths - 7/12 column'), ('11', 'Twelfths - 11/12 column')], label='Column size', required=False)), ('content', wagtail.blocks.StreamBlock([('text', cjkcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))])), ('image', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', cjkcms.blocks.html_blocks.SearchableHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False)), ('automatic_download', wagtail.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('page_list', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/pagelist_block.html', 'General, simple list'), ('cjkcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('cjkcms/blocks/pagelist_article_media.html', 'Article, media format'), ('cjkcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('cjkcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('cjkcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', cjkcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/pagepreview_card.html', 'Card')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))])), ('accordion', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('accordion', wagtail.snippets.blocks.SnippetChooserBlock('cjkcms.Accordion'))])), ('card', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/card_block.html', 'Card'), ('cjkcms/blocks/card_horizontal.html', 'Horizontal Card'), ('cjkcms/blocks/card_head.html', 'Card with header'), ('cjkcms/blocks/card_foot.html', 'Card with footer'), ('cjkcms/blocks/card_head_foot.html', 'Card with header and footer'), ('cjkcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('cjkcms/blocks/card_img.html', 'Cover image - use image as background'), ('cjkcms/blocks/card_landing1.html', 'Landing page style 1'), ('cjkcms/blocks/card_landing2.html', 'Landing page style 2')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.blocks.StreamBlock([('Links', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))]))], blank=True, label='Links', required=False))])), ('carousel', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('carousel', wagtail.snippets.blocks.SnippetChooserBlock('cjkcms.Carousel'))])), ('image_gallery', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('collection', cjkcms.blocks.base_blocks.CollectionChooserBlock(label='Image Collection', required=True))])), ('modal', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False)), ('header', wagtail.blocks.CharBlock(label='Modal heading', max_length=255, required=False)), ('content', wagtail.blocks.StreamBlock([('text', cjkcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))])), ('image', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', cjkcms.blocks.html_blocks.SearchableHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False)), ('automatic_download', wagtail.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('page_list', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/pagelist_block.html', 'General, simple list'), ('cjkcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('cjkcms/blocks/pagelist_article_media.html', 'Article, media format'), ('cjkcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('cjkcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('cjkcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', cjkcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/pagepreview_card.html', 'Card')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))]))], label='Content')), ('footer', wagtail.blocks.StreamBlock([('text', wagtail.blocks.CharBlock(icon='fa-file-text-o', label='Simple Text', max_length=255)), ('button', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))]))], label='Modal footer', required=False))])), ('pricelist', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('heading', wagtail.blocks.CharBlock(label='Heading', max_length=255, required=False)), ('items', wagtail.blocks.StreamBlock([('item', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('name', wagtail.blocks.CharBlock(label='Name', max_length=255, required=True)), ('description', wagtail.blocks.TextBlock(label='Description', required=False, rows=4)), ('price', wagtail.blocks.CharBlock(help_text='Any text here. Include currency sign if desired.', label='Price', required=True))]))], label='Items'))])), ('reusable_content', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('content', wagtail.snippets.blocks.SnippetChooserBlock('cjkcms.ReusableContent'))]))], label='Content'))]))], label='Content'))])), ('cardgrid', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/cardgrid_group.html', 'Card group - attached cards of equal size'), ('cjkcms/blocks/cardgrid_deck.html', 'Card deck - separate cards of equal size'), ('cjkcms/blocks/cardgrid_columns.html', 'Card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.blocks.StreamBlock([('card', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/card_block.html', 'Card'), ('cjkcms/blocks/card_horizontal.html', 'Horizontal Card'), ('cjkcms/blocks/card_head.html', 'Card with header'), ('cjkcms/blocks/card_foot.html', 'Card with footer'), ('cjkcms/blocks/card_head_foot.html', 'Card with header and footer'), ('cjkcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('cjkcms/blocks/card_img.html', 'Cover image - use image as background'), ('cjkcms/blocks/card_landing1.html', 'Landing page style 1'), ('cjkcms/blocks/card_landing2.html', 'Landing page style 2')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.blocks.StreamBlock([('Links', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))]))], blank=True, label='Links', required=False))]))], label='Content'))])), ('html', cjkcms.blocks.html_blocks.SearchableHTMLBlock(form_classname='monospace', icon='code', label='HTML'))], blank=True, null=True, use_json_field=True)),
                ('show_images', models.BooleanField(default=True, verbose_name='Show images')),
                ('show_captions', models.BooleanField(default=True)),
                ('show_meta', models.BooleanField(default=True, verbose_name='Show author and date info')),
                ('show_preview_text', models.BooleanField(default=True, verbose_name='Show preview text')),
            ],
            options={
                'verbose_name': 'Article Landing Page',
            },
            bases=('cjkcms.cjkcmspage',),
        ),
        migrations.CreateModel(
            name='WebPage',
            fields=[
                ('cjkcmspage_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='cjkcms.cjkcmspage')),
                ('body', wagtail.fields.StreamField([('hero', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.blocks.BooleanBlock(default=True, label='Full width', required=False)), ('is_parallax', wagtail.blocks.BooleanBlock(help_text='Background images scroll slower than foreground images, creating an illusion of depth.', label='Parallax Effect', required=False)), ('background_image', wagtail.images.blocks.ImageChooserBlock(required=False)), ('tile_image', wagtail.blocks.BooleanBlock(default=False, label='Tile background image', required=False)), ('background_color', wagtail.blocks.CharBlock(help_text='Hexadecimal, rgba, or CSS color notation (e.g. #ff0011)', label='Background color', max_length=255, required=False)), ('foreground_color', wagtail.blocks.CharBlock(help_text='Hexadecimal, rgba, or CSS color notation (e.g. #ff0011)', label='Text color', max_length=255, required=False)), ('content', wagtail.blocks.StreamBlock([('row', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.blocks.StreamBlock([('content', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('column_breakpoint', wagtail.blocks.ChoiceBlock(choices=[('', 'Always expanded'), ('sm', 'sm - Expand on small screens (phone, 576px) and larger'), ('md', 'md - Expand on medium screens (tablet, 768px) and larger'), ('lg', 'lg - Expand on large screens (laptop, 992px) and larger'), ('xl', 'xl - Expand on extra large screens (wide monitor, 1200px)')], help_text='Screen size at which the column will expand horizontally or stack vertically.', required=False, verbose_name='Column Breakpoint'))])), ('column_size', wagtail.blocks.ChoiceBlock(choices=[('', 'Automatically size'), ('12', 'Full row'), ('6', 'Half - 1/2 column'), ('4', 'Thirds - 1/3 column'), ('8', 'Thirds - 2/3 column'), ('3', 'Quarters - 1/4 column'), ('9', 'Quarters - 3/4 column'), ('2', 'Sixths - 1/6 column'), ('10', 'Sixths - 5/6 column'), ('1', 'Twelfths - 1/12 column'), ('5', 'Twelfths - 5/12 column'), ('7', 'Twelfths - 7/12 column'), ('11', 'Twelfths - 11/12 column')], label='Column size', required=False)), ('content', wagtail.blocks.StreamBlock([('text', cjkcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))])), ('image', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', cjkcms.blocks.html_blocks.SearchableHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False)), ('automatic_download', wagtail.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('page_list', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/pagelist_block.html', 'General, simple list'), ('cjkcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('cjkcms/blocks/pagelist_article_media.html', 'Article, media format'), ('cjkcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('cjkcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('cjkcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', cjkcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/pagepreview_card.html', 'Card')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))])), ('accordion', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('accordion', wagtail.snippets.blocks.SnippetChooserBlock('cjkcms.Accordion'))])), ('card', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/card_block.html', 'Card'), ('cjkcms/blocks/card_horizontal.html', 'Horizontal Card'), ('cjkcms/blocks/card_head.html', 'Card with header'), ('cjkcms/blocks/card_foot.html', 'Card with footer'), ('cjkcms/blocks/card_head_foot.html', 'Card with header and footer'), ('cjkcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('cjkcms/blocks/card_img.html', 'Cover image - use image as background'), ('cjkcms/blocks/card_landing1.html', 'Landing page style 1'), ('cjkcms/blocks/card_landing2.html', 'Landing page style 2')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.blocks.StreamBlock([('Links', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))]))], blank=True, label='Links', required=False))])), ('carousel', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('carousel', wagtail.snippets.blocks.SnippetChooserBlock('cjkcms.Carousel'))])), ('image_gallery', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('collection', cjkcms.blocks.base_blocks.CollectionChooserBlock(label='Image Collection', required=True))])), ('modal', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False)), ('header', wagtail.blocks.CharBlock(label='Modal heading', max_length=255, required=False)), ('content', wagtail.blocks.StreamBlock([('text', cjkcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))])), ('image', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', cjkcms.blocks.html_blocks.SearchableHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False)), ('automatic_download', wagtail.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('page_list', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/pagelist_block.html', 'General, simple list'), ('cjkcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('cjkcms/blocks/pagelist_article_media.html', 'Article, media format'), ('cjkcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('cjkcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('cjkcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', cjkcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/pagepreview_card.html', 'Card')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))]))], label='Content')), ('footer', wagtail.blocks.StreamBlock([('text', wagtail.blocks.CharBlock(icon='fa-file-text-o', label='Simple Text', max_length=255)), ('button', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))]))], label='Modal footer', required=False))])), ('pricelist', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('heading', wagtail.blocks.CharBlock(label='Heading', max_length=255, required=False)), ('items', wagtail.blocks.StreamBlock([('item', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('name', wagtail.blocks.CharBlock(label='Name', max_length=255, required=True)), ('description', wagtail.blocks.TextBlock(label='Description', required=False, rows=4)), ('price', wagtail.blocks.CharBlock(help_text='Any text here. Include currency sign if desired.', label='Price', required=True))]))], label='Items'))])), ('reusable_content', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('content', wagtail.snippets.blocks.SnippetChooserBlock('cjkcms.ReusableContent'))]))], label='Content'))]))], label='Content'))])), ('cardgrid', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/cardgrid_group.html', 'Card group - attached cards of equal size'), ('cjkcms/blocks/cardgrid_deck.html', 'Card deck - separate cards of equal size'), ('cjkcms/blocks/cardgrid_columns.html', 'Card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.blocks.StreamBlock([('card', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/card_block.html', 'Card'), ('cjkcms/blocks/card_horizontal.html', 'Horizontal Card'), ('cjkcms/blocks/card_head.html', 'Card with header'), ('cjkcms/blocks/card_foot.html', 'Card with footer'), ('cjkcms/blocks/card_head_foot.html', 'Card with header and footer'), ('cjkcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('cjkcms/blocks/card_img.html', 'Cover image - use image as background'), ('cjkcms/blocks/card_landing1.html', 'Landing page style 1'), ('cjkcms/blocks/card_landing2.html', 'Landing page style 2')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.blocks.StreamBlock([('Links', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))]))], blank=True, label='Links', required=False))]))], label='Content'))])), ('html', cjkcms.blocks.html_blocks.SearchableHTMLBlock(form_classname='monospace', icon='code', label='HTML'))], label='Content'))])), ('row', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.blocks.StreamBlock([('content', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('column_breakpoint', wagtail.blocks.ChoiceBlock(choices=[('', 'Always expanded'), ('sm', 'sm - Expand on small screens (phone, 576px) and larger'), ('md', 'md - Expand on medium screens (tablet, 768px) and larger'), ('lg', 'lg - Expand on large screens (laptop, 992px) and larger'), ('xl', 'xl - Expand on extra large screens (wide monitor, 1200px)')], help_text='Screen size at which the column will expand horizontally or stack vertically.', required=False, verbose_name='Column Breakpoint'))])), ('column_size', wagtail.blocks.ChoiceBlock(choices=[('', 'Automatically size'), ('12', 'Full row'), ('6', 'Half - 1/2 column'), ('4', 'Thirds - 1/3 column'), ('8', 'Thirds - 2/3 column'), ('3', 'Quarters - 1/4 column'), ('9', 'Quarters - 3/4 column'), ('2', 'Sixths - 1/6 column'), ('10', 'Sixths - 5/6 column'), ('1', 'Twelfths - 1/12 column'), ('5', 'Twelfths - 5/12 column'), ('7', 'Twelfths - 7/12 column'), ('11', 'Twelfths - 11/12 column')], label='Column size', required=False)), ('content', wagtail.blocks.StreamBlock([('text', cjkcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))])), ('image', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', cjkcms.blocks.html_blocks.SearchableHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False)), ('automatic_download', wagtail.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('page_list', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/pagelist_block.html', 'General, simple list'), ('cjkcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('cjkcms/blocks/pagelist_article_media.html', 'Article, media format'), ('cjkcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('cjkcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('cjkcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', cjkcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/pagepreview_card.html', 'Card')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))])), ('accordion', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('accordion', wagtail.snippets.blocks.SnippetChooserBlock('cjkcms.Accordion'))])), ('card', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/card_block.html', 'Card'), ('cjkcms/blocks/card_horizontal.html', 'Horizontal Card'), ('cjkcms/blocks/card_head.html', 'Card with header'), ('cjkcms/blocks/card_foot.html', 'Card with footer'), ('cjkcms/blocks/card_head_foot.html', 'Card with header and footer'), ('cjkcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('cjkcms/blocks/card_img.html', 'Cover image - use image as background'), ('cjkcms/blocks/card_landing1.html', 'Landing page style 1'), ('cjkcms/blocks/card_landing2.html', 'Landing page style 2')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.blocks.StreamBlock([('Links', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))]))], blank=True, label='Links', required=False))])), ('carousel', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('carousel', wagtail.snippets.blocks.SnippetChooserBlock('cjkcms.Carousel'))])), ('image_gallery', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('collection', cjkcms.blocks.base_blocks.CollectionChooserBlock(label='Image Collection', required=True))])), ('modal', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False)), ('header', wagtail.blocks.CharBlock(label='Modal heading', max_length=255, required=False)), ('content', wagtail.blocks.StreamBlock([('text', cjkcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))])), ('image', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', cjkcms.blocks.html_blocks.SearchableHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False)), ('automatic_download', wagtail.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('page_list', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/pagelist_block.html', 'General, simple list'), ('cjkcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('cjkcms/blocks/pagelist_article_media.html', 'Article, media format'), ('cjkcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('cjkcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('cjkcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', cjkcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/pagepreview_card.html', 'Card')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))]))], label='Content')), ('footer', wagtail.blocks.StreamBlock([('text', wagtail.blocks.CharBlock(icon='fa-file-text-o', label='Simple Text', max_length=255)), ('button', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))]))], label='Modal footer', required=False))])), ('pricelist', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('heading', wagtail.blocks.CharBlock(label='Heading', max_length=255, required=False)), ('items', wagtail.blocks.StreamBlock([('item', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('name', wagtail.blocks.CharBlock(label='Name', max_length=255, required=True)), ('description', wagtail.blocks.TextBlock(label='Description', required=False, rows=4)), ('price', wagtail.blocks.CharBlock(help_text='Any text here. Include currency sign if desired.', label='Price', required=True))]))], label='Items'))])), ('reusable_content', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('content', wagtail.snippets.blocks.SnippetChooserBlock('cjkcms.ReusableContent'))]))], label='Content'))]))], label='Content'))])), ('cardgrid', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/cardgrid_group.html', 'Card group - attached cards of equal size'), ('cjkcms/blocks/cardgrid_deck.html', 'Card deck - separate cards of equal size'), ('cjkcms/blocks/cardgrid_columns.html', 'Card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('fluid', wagtail.blocks.BooleanBlock(label='Full width', required=False)), ('content', wagtail.blocks.StreamBlock([('card', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/card_block.html', 'Card'), ('cjkcms/blocks/card_horizontal.html', 'Horizontal Card'), ('cjkcms/blocks/card_head.html', 'Card with header'), ('cjkcms/blocks/card_foot.html', 'Card with footer'), ('cjkcms/blocks/card_head_foot.html', 'Card with header and footer'), ('cjkcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('cjkcms/blocks/card_img.html', 'Cover image - use image as background'), ('cjkcms/blocks/card_landing1.html', 'Landing page style 1'), ('cjkcms/blocks/card_landing2.html', 'Landing page style 2')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.blocks.StreamBlock([('Links', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))]))], blank=True, label='Links', required=False))]))], label='Content'))])), ('html', cjkcms.blocks.html_blocks.SearchableHTMLBlock(form_classname='monospace', icon='code', label='HTML'))], blank=True, null=True, use_json_field=True)),
            ],
            options={
                'verbose_name': 'Web Page',
            },
            bases=('cjkcms.cjkcmspage',),
        ),
        migrations.CreateModel(
            name='SocialMediaSettings',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('facebook', models.URLField(blank=True, help_text='Your Facebook page URL', verbose_name='Facebook')),
                ('twitter', models.URLField(blank=True, help_text='Your Twitter page URL', verbose_name='Twitter')),
                ('instagram', models.CharField(blank=True, help_text='Your Instagram username, without the @', max_length=255, verbose_name='Instagram')),
                ('linkedin', models.URLField(blank=True, help_text='Your LinkedIn page URL', verbose_name='LinkedIn')),
                ('youtube', models.URLField(blank=True, help_text='Your YouTube channel or user account URL', verbose_name='YouTube')),
                ('vimeo', models.URLField(blank=True, help_text='Your Vimeo channel or user account URL', verbose_name='Vimeo')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.site')),
            ],
            options={
                'verbose_name': 'Social Media',
            },
        ),
        migrations.CreateModel(
            name='NavbarOrderable',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('navbar', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='cjkcms.navbar')),
                ('navbar_chooser', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='site_navbar', to='cjkcms.layoutsettings', verbose_name='Site Navbars')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MailchimpApiSettings',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mailchimp_api_key', models.CharField(blank=True, help_text='The API Key used for Mailchimp.', max_length=255, verbose_name='Mailchimp API Key')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.site')),
            ],
            options={
                'verbose_name': 'Mailchimp API',
            },
        ),
        migrations.CreateModel(
            name='GeneralSettings',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('from_email_address', models.CharField(blank=True, help_text='The default email address this site appears to send from. For example: "sender@example.com" or "Sender Name <sender@example.com>" (without quotes)', max_length=255, verbose_name='From email address')),
                ('search_num_results', models.PositiveIntegerField(default=20, verbose_name='Number of results per page')),
                ('external_new_tab', models.BooleanField(default=False, verbose_name='Open all external links in new tab')),
                ('gravatar', models.ForeignKey(blank=True, help_text='Gravatar image when user email not found in gravatar db', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='Gravatar Default')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.site')),
            ],
            options={
                'verbose_name': 'General',
            },
        ),
        migrations.CreateModel(
            name='FooterOrderable',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('footer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='cjkcms.footer')),
                ('footer_chooser', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='site_footer', to='cjkcms.layoutsettings', verbose_name='Site Footers')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClassifierTerm',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('slug', models.SlugField(allow_unicode=True, unique=True, verbose_name='Slug')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('classifier', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='terms', to='cjkcms.classifier', verbose_name='Classifier')),
            ],
            options={
                'verbose_name': 'Classifier Term',
                'verbose_name_plural': 'Classifier Terms',
            },
        ),
        migrations.CreateModel(
            name='CjkcmsTag',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content_object', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='tagged_items', to='cjkcms.cjkcmspage')),
                ('tag', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='%(app_label)s_%(class)s_items', to='taggit.tag')),
            ],
            options={
                'verbose_name': 'CMS Tag',
            },
        ),
        migrations.AddField(
            model_name='cjkcmspage',
            name='classifier_terms',
            field=modelcluster.fields.ParentalManyToManyField(blank=True, help_text='Categorize and group pages together with classifiers. Used to organize and filter pages across the site.', to='cjkcms.classifierterm', verbose_name='Classifiers'),
        ),
        migrations.AddField(
            model_name='cjkcmspage',
            name='cover_image',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='Cover image'),
        ),
        migrations.AddField(
            model_name='cjkcmspage',
            name='index_classifiers',
            field=modelcluster.fields.ParentalManyToManyField(blank=True, help_text='Enable filtering child pages by these classifiers.', to='cjkcms.classifier', verbose_name='Filter child pages by'),
        ),
        migrations.AddField(
            model_name='cjkcmspage',
            name='index_order_by_classifier',
            field=models.ForeignKey(blank=True, help_text='Child pages will first be sorted following the order of this classifier’s terms (from Snippets > Classifiers).', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='cjkcms.classifier', verbose_name='Order child pages by classifier'),
        ),
        migrations.AddField(
            model_name='cjkcmspage',
            name='og_image',
            field=models.ForeignKey(blank=True, help_text='Shown when linking to this page on social media.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='Preview image'),
        ),
        migrations.AddField(
            model_name='cjkcmspage',
            name='struct_org_image',
            field=models.ForeignKey(blank=True, help_text='A photo of the facility. This photo will be cropped to 1:1, 4:3, and 16:9 aspect ratios automatically.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='Photo of Organization'),
        ),
        migrations.AddField(
            model_name='cjkcmspage',
            name='struct_org_logo',
            field=models.ForeignKey(blank=True, help_text='Leave blank to use the logo in Settings > Layout > Logo', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='Organization logo'),
        ),
        migrations.AddField(
            model_name='cjkcmspage',
            name='tags',
            field=modelcluster.contrib.taggit.ClusterTaggableManager(blank=True, help_text='Used to organize pages across the site.', through='cjkcms.CjkcmsTag', to='taggit.Tag', verbose_name='Tags'),
        ),
        migrations.CreateModel(
            name='CarouselSlide',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('background_color', models.CharField(blank=True, help_text='Hexadecimal, rgba, or CSS color notation (e.g. #ff0011)', max_length=255, verbose_name='Background color')),
                ('custom_css_class', models.CharField(blank=True, max_length=255, verbose_name='Custom CSS class')),
                ('custom_id', models.CharField(blank=True, max_length=255, verbose_name='Custom ID')),
                ('content', cjkcms.fields.CjkcmsStreamField(blank=True, use_json_field=True)),
                ('carousel', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='carousel_slides', to='cjkcms.carousel', verbose_name='Carousel')),
                ('image', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='wagtailimages.image', verbose_name='Image')),
            ],
            options={
                'verbose_name': 'Carousel Slide',
            },
        ),
        migrations.CreateModel(
            name='AnalyticsSettings',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ga_tracking_id', models.CharField(blank=True, help_text='Google Analytics tracking ID (begins with "UA-"). Note: will stop working by 1 July 2023!', max_length=255, verbose_name='Universal Analytics Tracking ID')),
                ('g4_tracking_id', models.CharField(blank=True, help_text='G4 Google Analytics tracking ID ("G-..."). If both G4 & UA set, both will be used.', max_length=255, verbose_name='G4 Analytics Tracking ID')),
                ('ga_track_button_clicks', models.BooleanField(default=False, help_text='Track all button clicks using Google Analytics event tracking. Event tracking details can be specified in each button’s advanced settings options.', verbose_name='Track button clicks')),
                ('gtm_id', models.CharField(blank=True, help_text='Begins with "GTM-"', max_length=255, verbose_name='Google Tag Manager ID')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.site')),
            ],
            options={
                'verbose_name': 'Tracking',
            },
        ),
        migrations.CreateModel(
            name='AdobeApiSettings',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('adobe_embed_id', models.CharField(blank=True, help_text='Adobe PDF Embed API Client ID', max_length=64, null=True, verbose_name='Adobe Embed API ID')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.site')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AccordionPanel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('content', cjkcms.fields.CjkcmsStreamField(blank=True, use_json_field=True)),
                ('custom_css_class', models.CharField(blank=True, max_length=255, verbose_name='Custom CSS class')),
                ('custom_id', models.CharField(blank=True, max_length=255, verbose_name='Custom ID')),
                ('accordion', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='accordion_panels', to='cjkcms.accordion', verbose_name='Accordion')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ArticlePage',
            fields=[
                ('cjkcmspage_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='cjkcms.cjkcmspage')),
                ('body', wagtail.fields.StreamField([('text', cjkcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))])), ('image', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', cjkcms.blocks.html_blocks.SearchableHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False)), ('automatic_download', wagtail.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('page_list', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/pagelist_block.html', 'General, simple list'), ('cjkcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('cjkcms/blocks/pagelist_article_media.html', 'Article, media format'), ('cjkcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('cjkcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('cjkcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', cjkcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/pagepreview_card.html', 'Card')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))])), ('accordion', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('accordion', wagtail.snippets.blocks.SnippetChooserBlock('cjkcms.Accordion'))])), ('card', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/card_block.html', 'Card'), ('cjkcms/blocks/card_horizontal.html', 'Horizontal Card'), ('cjkcms/blocks/card_head.html', 'Card with header'), ('cjkcms/blocks/card_foot.html', 'Card with footer'), ('cjkcms/blocks/card_head_foot.html', 'Card with header and footer'), ('cjkcms/blocks/card_blurb.html', 'Blurb - rounded image and no border'), ('cjkcms/blocks/card_img.html', 'Cover image - use image as background'), ('cjkcms/blocks/card_landing1.html', 'Landing page style 1'), ('cjkcms/blocks/card_landing2.html', 'Landing page style 2')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', max_length=255, required=False)), ('title', wagtail.blocks.CharBlock(label='Title', max_length=255, required=False)), ('subtitle', wagtail.blocks.CharBlock(label='Subtitle', max_length=255, required=False)), ('description', wagtail.blocks.RichTextBlock(features=['bold', 'italic', 'ol', 'ul', 'hr', 'link', 'document-link'], label='Body')), ('links', wagtail.blocks.StreamBlock([('Links', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))]))], blank=True, label='Links', required=False))])), ('carousel', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('carousel', wagtail.snippets.blocks.SnippetChooserBlock('cjkcms.Carousel'))])), ('image_gallery', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('collection', cjkcms.blocks.base_blocks.CollectionChooserBlock(label='Image Collection', required=True))])), ('modal', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False)), ('header', wagtail.blocks.CharBlock(label='Modal heading', max_length=255, required=False)), ('content', wagtail.blocks.StreamBlock([('text', cjkcms.blocks.html_blocks.RichTextBlock(icon='fa-file-text-o')), ('button', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))])), ('image', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image'))])), ('image_link', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image')), ('alt_text', wagtail.blocks.CharBlock(help_text='Alternate text to show if the image doesn’t load', max_length=255, required=True))])), ('html', cjkcms.blocks.html_blocks.SearchableHTMLBlock(form_classname='monospace', icon='code', label='HTML')), ('download', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False)), ('automatic_download', wagtail.blocks.BooleanBlock(label='Auto download', required=False)), ('downloadable_file', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False))])), ('embed_video', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('url', wagtail.embeds.blocks.EmbedBlock(help_text='Link to a YouTube/Vimeo video, tweet, facebook post, etc.', label='URL', required=True))])), ('quote', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('text', wagtail.blocks.TextBlock(label='Quote Text', required=True, rows=4)), ('author', wagtail.blocks.CharBlock(label='Author', max_length=255, required=False))])), ('table', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('table', wagtail.contrib.table_block.blocks.TableBlock())])), ('page_list', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/pagelist_block.html', 'General, simple list'), ('cjkcms/blocks/pagelist_list_group.html', 'General, list group navigation panel'), ('cjkcms/blocks/pagelist_article_media.html', 'Article, media format'), ('cjkcms/blocks/pagelist_article_card_group.html', 'Article, card group - attached cards of equal size'), ('cjkcms/blocks/pagelist_article_card_deck.html', 'Article, card deck - separate cards of equal size'), ('cjkcms/blocks/pagelist_article_card_columns.html', 'Article, card masonry - fluid brick pattern')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('indexed_by', wagtail.blocks.PageChooserBlock(help_text='Show a preview of pages that are children of the selected page. Uses ordering specified in the page’s LAYOUT tab.', label='Parent page', required=True)), ('classified_by', cjkcms.blocks.base_blocks.ClassifierTermChooserBlock(help_text='Only show pages that are classified with this term.', label='Classified as', required=False)), ('show_preview', wagtail.blocks.BooleanBlock(default=False, label='Show body preview', required=False)), ('num_posts', wagtail.blocks.IntegerBlock(default=3, label='Number of pages to show'))])), ('page_preview', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default'), ('cjkcms/blocks/pagepreview_card.html', 'Card')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('page', wagtail.blocks.PageChooserBlock(help_text='Show a mini preview of the selected page.', label='Page to preview', required=True))]))], label='Content')), ('footer', wagtail.blocks.StreamBlock([('text', wagtail.blocks.CharBlock(icon='fa-file-text-o', label='Simple Text', max_length=255)), ('button', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False)), ('ga_tracking_event_category', wagtail.blocks.CharBlock(label='Tracking Event Category', max_length=255, required=False)), ('ga_tracking_event_label', wagtail.blocks.CharBlock(label='Tracking Event Label', max_length=255, required=False))])), ('page_link', wagtail.blocks.PageChooserBlock(label='Page link', required=False)), ('doc_link', wagtail.documents.blocks.DocumentChooserBlock(label='Document link', required=False)), ('other_link', wagtail.blocks.CharBlock(label='Other link', max_length=255, required=False)), ('button_title', wagtail.blocks.CharBlock(label='Button Title', max_length=255, required=True)), ('button_style', wagtail.blocks.ChoiceBlock(choices=[('btn-primary', 'Primary'), ('btn-secondary', 'Secondary'), ('btn-success', 'Success'), ('btn-danger', 'Danger'), ('btn-warning', 'Warning'), ('btn-info', 'Info'), ('btn-link', 'Link'), ('btn-light', 'Light'), ('btn-dark', 'Dark'), ('btn-outline-primary', 'Outline Primary'), ('btn-outline-secondary', 'Outline Secondary'), ('btn-outline-success', 'Outline Success'), ('btn-outline-danger', 'Outline Danger'), ('btn-outline-warning', 'Outline Warning'), ('btn-outline-info', 'Outline Info'), ('btn-outline-light', 'Outline Light'), ('btn-outline-dark', 'Outline Dark')], label='Button Style', required=False)), ('button_size', wagtail.blocks.ChoiceBlock(choices=[('btn-sm', 'Small'), ('', 'Default'), ('btn-lg', 'Large')], label='Button Size', required=False)), ('visible_for', wagtail.blocks.ChoiceBlock(choices=[('all', 'Default (Everyone)'), ('non-auth-only', 'Not logged in only'), ('auth-only', 'Logged in only'), ('hidden', 'Hidden for all')], label='Item visibility', required=False))]))], label='Modal footer', required=False))])), ('pricelist', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('heading', wagtail.blocks.CharBlock(label='Heading', max_length=255, required=False)), ('items', wagtail.blocks.StreamBlock([('item', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('image', wagtail.images.blocks.ImageChooserBlock(label='Image', required=False)), ('name', wagtail.blocks.CharBlock(label='Name', max_length=255, required=True)), ('description', wagtail.blocks.TextBlock(label='Description', required=False, rows=4)), ('price', wagtail.blocks.CharBlock(help_text='Any text here. Include currency sign if desired.', label='Price', required=True))]))], label='Items'))])), ('reusable_content', wagtail.blocks.StructBlock([('settings', wagtail.blocks.StructBlock([('custom_template', wagtail.blocks.ChoiceBlock(choices=[('', 'Default')], label='Template', required=False)), ('custom_css_class', wagtail.blocks.CharBlock(label='Custom CSS Class', max_length=255, required=False)), ('custom_id', wagtail.blocks.CharBlock(label='Custom ID', max_length=255, required=False))])), ('content', wagtail.snippets.blocks.SnippetChooserBlock('cjkcms.ReusableContent'))]))], blank=True, null=True, use_json_field=True)),
                ('caption', models.CharField(blank=True, max_length=255, verbose_name='Caption')),
                ('author_display', models.CharField(blank=True, help_text='Override how the author’s name displays on this article.', max_length=255, verbose_name='Display author as')),
                ('date_display', models.DateField(blank=True, null=True, verbose_name='Display publish date')),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL, verbose_name='Author')),
            ],
            options={
                'verbose_name': 'Article',
                'ordering': ['-first_published_at'],
            },
            bases=('cjkcms.cjkcmspage',),
        ),
    ]
