# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pymirror', 'pymirror.experimental', 'pymirror.tests']

package_data = \
{'': ['*'], 'pymirror': ['data/*']}

install_requires = \
['dracula>=0.1.3',
 'loguru>=0.5.3',
 'psutil>=5.8.0',
 'requests>=2.28.0',
 'rich>=10.13.0',
 'selenium>=4.1.0',
 'webdriver-manager>=3.5.2']

entry_points = \
{'console_scripts': ['pymirror = pymirror.run:main']}

setup_kwargs = {
    'name': 'pymirror',
    'version': '0.4.1',
    'description': 'Upload files to Multiple Mirror',
    'long_description': "# PyMirror\n\n[![Build](https://github.com/Alyetama/pymirror/actions/workflows/poetry-build.yml/badge.svg)](https://github.com/Alyetama/pymirror/actions/workflows/poetry-build.yml) [![PyPI](https://img.shields.io/pypi/v/pymirror)](https://pypi.org/project/pymirror/) ![PyPI - Downloads](https://img.shields.io/pypi/dm/pymirror) [![PEP8](https://img.shields.io/badge/code%20style-pep8-green.svg)](https://www.python.org/dev/peps/pep-0008/)\n\n## Requirements\n\n- [Python>=3.7](https://www.python.org/downloads/)\n- [pip](https://pip.pypa.io/en/stable/getting-started/)\n- [Firefox Browser](https://www.mozilla.org/en-US/firefox/new/) (optional)\n- [Gecko Driver](https://github.com/mozilla/geckodriver/releases) (optional)\n\n## Installation\n\n```bash\ngit clone https://github.com/Alyetama/pymirror.git\ncd pymirror\nsh setup.sh\npip install pymirror\n```\n\n## CLI Arguments\n\n```bash\npymirror --help\n```\n\n```\nusage: pymirror [-h] -i INPUT [-s {lines,list,markdown,reddit}] [-m] [-n NUMBER]\n                [-d] [-c] [-D] [-l] [-e] [-v]\n\noptional arguments:\n  -h, --help                            Show this help message and \\exit\n  -i, --input INPUT                     Path to the input file/folder\n  -s, --style {lines,list,markdown,reddit}\n                                        Output style (default: lines)\n  -m, --more-links                      Use mirrored.to to generate more likes\n                                        (default: False)\n  -n, --number NUMBER                   Select a specific number of servers to\n                                        use (default: max)\n  -d, --delete                          Delete the file after the process is\n                                        complete (default: False)\n  -c, --check-status                    Check the status of the remote servers\n                                        (default: False)\n  -D, --debug                           Debug\n  -l, --log                             Show logs and save it to a file\n                                        (default: False)\n  -e, --experimental                    Generate even more links (experimental)\n                                        (default: False)\n  -v, --version                         Show program\\'s version number and \\exit\n```\n\n## Basic Usage\n\n```bash\npymirror --input foo.txt\n```\n\n## Examaples\n\n1. Upload a file to multiple free hosting services and return the output in a markdown style\n\n```bash\npymirror --input foo.txt --style markdown\n```\n\n```\nPress `CTRL+C` at any time to quit.\n───────────────────────────────── Uploading... ─────────────────────────────────\n[ OK ] https://file.io/PYovv2JI0I4d\n[ OK ] https://gofile.io/d/7QGe8z\n[ OK ] https://a.uguu.se/QrGNenpZ.txt\n[ OK ] https://transfer.sh/mURd/foo.txt\n[ OK ] https://oshi.at/AmzjcK/foo.txt\n[ OK ] https://0x0.st/iGzX.txt\n[ OK ] https://ttm.sh/uhj.txt\n[ OK ] https://temp.sh/mXoSA/foo.txt\n[ OK ] https://1.filedit.ch/1/VKoJvyuUgtAXfyKEcC.txt\n[ OK ] https://pomf.lain.la/f/ibie9ed.txt\n─────────────────────────────────── Results ────────────────────────────────────\n- [fileio](https://file.io/PYovv2JI0I4d)\n- [gofile](https://gofile.io/d/7QGe8z)\n- [uguu](https://a.uguu.se/QrGNenpZ.txt)\n- [transfersh](https://transfer.sh/mURd/foo.txt)\n- [oshi](https://oshi.at/AmzjcK/foo.txt)\n- [0x0](https://0x0.st/iGzX.txt)\n- [ttm](https://ttm.sh/uhj.txt)\n- [filepush](https://temp.sh/mXoSA/foo.txt)\n- [tempsh](https://1.filedit.ch/1/VKoJvyuUgtAXfyKEcC.txt)\n- [fileditch](https://pomf.lain.la/f/ibie9ed.txt)\n───────────────────────────────────── END ──────────────────────────────────────\n```\n\n- View on [asciinema](https://asciinema.org/a/Rg1w7TPrjw9RBi7QTowr9158D?t=3)\n\n2. Use the `--more-links` (`-m`) flag<sup>1</sup> to upload to more hosting services (~ 25 more) utilizing Selenium<sup>\n   2</sup>\n\n```bash\npymirror --input foo.txt --style markdown --more-links\n```\n\n```\nPress `CTRL+C` at any time to quit.\n───────────────────────────────── Uploading... ─────────────────────────────────\n[ OK ] https://file.io/eDZG6VfnDN43\n[ OK ] https://gofile.io/d/QFNdfE\n[ OK ] https://a.uguu.se/VEuSCRXG.txt\n[ OK ] https://transfer.sh/14dUZMm/foo.txt\n[ OK ] https://oshi.at/AmzkvT/foo.txt\n[ OK ] https://0x0.st/iGzX.txt\n[ OK ] https://ttm.sh/uhj.txt\n[ OK ] https://temp.sh/bAxUT/foo.txt\n[ OK ] https://1.filedit.ch/1/VKoJvyuUgtAXfyKEcC.txt\n[ OK ] https://pomf.lain.la/f/ibie9ed.txt\n[ OK ] https://usersdrive.com/ma2v4fr181v5\n[ OK ] https://anonfiles.com/90Sb27Aau8/foo_txt\n[ OK ] https://bayfiles.com/BfS025Acuc/foo_txt\n[ OK ] https://1fichier.com/?tao8ogg2lyz3n3zh0psn\n[ OK ] https://clicknupload.co/ses53quzv5rb\n[ OK ] https://tusfiles.com/sc4vfge39aor\n[ OK ] https://download.gg/file-12471936_ffbed313aed67837\n[ OK ] https://www.solidfiles.com/v/YLjeg8wM8ZgMV\n[ OK ] https://turbobit.net/65h5jggvj1ol.html\n[ OK ] https://www42.zippyshare.com/v/9tKGS8qj/file.html\n[ OK ] https://files.im/y1667uawdq6t\n[ OK ] https://drop.download/6rwa2bjv8x0g\n[ OK ] https://www.upload.ee/files/13367614/foo.txt.html\n[ OK ] https://www.file-upload.com/308wmzsrs4r4\n[ OK ] https://dailyuploads.net/p5vjdxt93hdv\n[ OK ] https://uptobox.com/4pugjp1vza19\n[ OK ] https://dlupload.com/Download/file/N2VmNDEyNDkt\n[ OK ] https://mixdrop.co/f/o73e7316h49wj4\n[ OK ] https://megaup.net/Ydcb\n...and more!\n─────────────────────────────────── Results ────────────────────────────────────\n- [file.io](https://file.io/eDZG6VfnDN43)\n- [gofile.io](https://gofile.io/d/QFNdfE)\n- [uguu.se](https://a.uguu.se/VEuSCRXG.txt)\n- [transfer.sh](https://transfer.sh/14dUZMm/foo.txt)\n- [oshi.at](https://oshi.at/AmzkvT/foo.txt)\n- [0x0.st](https://0x0.st/iGzX.txt)\n- [ttm.sh](https://ttm.sh/uhj.txt)\n- [temp.sh](https://temp.sh/bAxUT/foo.txt)\n- [filedit.ch](https://1.filedit.ch/1/VKoJvyuUgtAXfyKEcC.txt)\n- [lain.la](https://pomf.lain.la/f/ibie9ed.txt)\n- [usersdrive.com](https://usersdrive.com/ma2v4fr181v5)\n- [anonfiles.com](https://anonfiles.com/90Sb27Aau8/foo_txt)\n- [bayfiles.com](https://bayfiles.com/BfS025Acuc/foo_txt)\n- [1fichier.com](https://1fichier.com/?tao8ogg2lyz3n3zh0psn)\n- [clicknupload.co](https://clicknupload.co/ses53quzv5rb)\n- [tusfiles.com](https://tusfiles.com/sc4vfge39aor)\n- [download.gg](https://download.gg/file-12471936_ffbed313aed67837)\n- [solidfiles.com](https://www.solidfiles.com/v/YLjeg8wM8ZgMV)\n- [turbobit.net](https://turbobit.net/65h5jggvj1ol.html)\n- [zippyshare.com](https://www42.zippyshare.com/v/9tKGS8qj/file.html)\n- [files.im](https://files.im/y1667uawdq6t)\n- [drop.download](https://drop.download/6rwa2bjv8x0g)\n- [upload.ee](https://www.upload.ee/files/13367614/foo.txt.html)\n- [file-upload.com](https://www.file-upload.com/308wmzsrs4r4)\n- [dailyuploads.net](https://dailyuploads.net/p5vjdxt93hdv)\n- [uptobox.com](https://uptobox.com/4pugjp1vza19)\n- [dlupload.com](https://dlupload.com/Download/file/N2VmNDEyNDkt)\n- [mixdrop.co](https://mixdrop.co/f/o73e7316h49wj4)\n- [megaup.net](https://megaup.net/Ydcb)\n...and more!\n───────────────────────────────────── END ──────────────────────────────────────\n```\n\n<sup>1</sup>Requires Firefox<br>\n<sup>2</sup>A temporary Gecko driver will be installed automatically if it does not already exist\n\n## To do\n\n- [x]  ~~Filter servers by upload limit~~\n",
    'author': 'Mohammad Alyetama',
    'author_email': 'malyetama@pm.me',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
