# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-12-10 14:32


from django.db import migrations


def command(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    Product = apps.get_model('products', 'Product')
    Setting = apps.get_model('settings', 'Setting')
    key = 'PRODUCT_WALLET_ID'
    value_id = Setting.objects.get(key=key).value
    wallet = Product.objects.get(id=value_id)
    wallet.is_show_only_for_super_user = True
    wallet.save()


class Migration(migrations.Migration):

    dependencies = [
        ('settings', '0005_auto_20181130_1938'),
    ]

    operations = [
        migrations.RunPython(command, reverse_code=migrations.RunPython.noop),
    ]
