# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-07-17 07:23
from __future__ import unicode_literals

from django.db import migrations, models

from bpp.models.abstract import wez_zakres_stron, parse_informacje


def przerzuc_dane(apps, schema_editor):
    for model in ['Wydawnictwo_Ciagle', 'Wydawnictwo_Zwarte',
                  'Patent', 'Praca_Doktorska', 'Praca_Habilitacyjna']:
        klass = apps.get_model("bpp", model)
        for elem in klass.objects.all():

            if hasattr(elem, 'strony'):
                if elem.szczegoly:
                    s = wez_zakres_stron(elem.szczegoly)
                    if not elem.strony:
                        if s != elem.strony:
                            elem.strony = s
                            changed = True

            if elem.informacje is not None:
                tom = parse_informacje(elem.informacje, "tom")
                nr_zeszytu = parse_informacje(elem.informacje, "numer")

                if hasattr(elem, 'tom'):
                    if not elem.tom and tom:
                        if tom != elem.tom:
                            elem.tom = tom
                            chagned = True

                if hasattr(elem, 'nr_zeszytu'):
                    if not elem.nr_zeszytu and nr_zeszytu:
                        if nr_zeszytu != elem.nr_zeszytu:
                            elem.nr_zeszytu = nr_zeszytu
                            changed = True

            if changed:
                elem.save()


class Migration(migrations.Migration):

    dependencies = [
        ('bpp', '0083_afiliuje_zatrudniony'),
    ]

    operations = [
        migrations.AddField(
            model_name='patent',
            name='strony',
            field=models.CharField(blank=True, help_text='Jeżeli uzupełnione, to pole będzie eksportowane do \n        danych PBN. Jeżeli puste, informacja ta będzie ekstrahowana z \n        pola \'Szczegóły\' w chwili importu. Aby uniknąć sytuacji, gdy wskutek\n        błędnego wprowadzenia tekstu do pola "Szczegóły" informacja ta nie \n        będzie mogła być wyekstrahowana z tego pola, kliknij przycisk \n        "Uzupełnij", aby spowodować uzupełnienie tego pola na podstawie\n        pola "Szcegóły". \n        ', max_length=50, null=True),
        ),
        migrations.AddField(
            model_name='patent',
            name='tom',
            field=models.CharField(blank=True, help_text='Jeżeli uzupełnione, to pole będzie eksportowane do \n        danych PBN. Jeżeli puste, informacja ta będzie ekstrahowana z \n        pola \'Informacje\'. Kliknięcie przycisku "Uzupełnij" powoduje\n        również automatyczne wypełnienie tego pola, o ile do formularza\n        zostały wprowadzone odpowiednie informacje. ', max_length=50, null=True),
        ),
        migrations.AddField(
            model_name='praca_doktorska',
            name='strony',
            field=models.CharField(blank=True, help_text='Jeżeli uzupełnione, to pole będzie eksportowane do \n        danych PBN. Jeżeli puste, informacja ta będzie ekstrahowana z \n        pola \'Szczegóły\' w chwili importu. Aby uniknąć sytuacji, gdy wskutek\n        błędnego wprowadzenia tekstu do pola "Szczegóły" informacja ta nie \n        będzie mogła być wyekstrahowana z tego pola, kliknij przycisk \n        "Uzupełnij", aby spowodować uzupełnienie tego pola na podstawie\n        pola "Szcegóły". \n        ', max_length=50, null=True),
        ),
        migrations.AddField(
            model_name='praca_doktorska',
            name='tom',
            field=models.CharField(blank=True, help_text='Jeżeli uzupełnione, to pole będzie eksportowane do \n        danych PBN. Jeżeli puste, informacja ta będzie ekstrahowana z \n        pola \'Informacje\'. Kliknięcie przycisku "Uzupełnij" powoduje\n        również automatyczne wypełnienie tego pola, o ile do formularza\n        zostały wprowadzone odpowiednie informacje. ', max_length=50, null=True),
        ),
        migrations.AddField(
            model_name='praca_habilitacyjna',
            name='strony',
            field=models.CharField(blank=True, help_text='Jeżeli uzupełnione, to pole będzie eksportowane do \n        danych PBN. Jeżeli puste, informacja ta będzie ekstrahowana z \n        pola \'Szczegóły\' w chwili importu. Aby uniknąć sytuacji, gdy wskutek\n        błędnego wprowadzenia tekstu do pola "Szczegóły" informacja ta nie \n        będzie mogła być wyekstrahowana z tego pola, kliknij przycisk \n        "Uzupełnij", aby spowodować uzupełnienie tego pola na podstawie\n        pola "Szcegóły". \n        ', max_length=50, null=True),
        ),
        migrations.AddField(
            model_name='praca_habilitacyjna',
            name='tom',
            field=models.CharField(blank=True, help_text='Jeżeli uzupełnione, to pole będzie eksportowane do \n        danych PBN. Jeżeli puste, informacja ta będzie ekstrahowana z \n        pola \'Informacje\'. Kliknięcie przycisku "Uzupełnij" powoduje\n        również automatyczne wypełnienie tego pola, o ile do formularza\n        zostały wprowadzone odpowiednie informacje. ', max_length=50, null=True),
        ),
        migrations.AddField(
            model_name='wydawnictwo_ciagle',
            name='nr_zeszytu',
            field=models.CharField(blank=True, help_text='Jeżeli uzupełnione, to pole będzie eksportowane do \n        danych PBN. Jeżeli puste, informacja ta będzie ekstrahowana z \n        pola \'Informacje\'. Kliknięcie przycisku "Uzupełnij" powoduje\n        również automatyczne wypełnienie tego pola, o ile do formularza\n        zostały wprowadzone odpowiednie informacje. ', max_length=50, null=True),
        ),
        migrations.AddField(
            model_name='wydawnictwo_ciagle',
            name='strony',
            field=models.CharField(blank=True, help_text='Jeżeli uzupełnione, to pole będzie eksportowane do \n        danych PBN. Jeżeli puste, informacja ta będzie ekstrahowana z \n        pola \'Szczegóły\' w chwili importu. Aby uniknąć sytuacji, gdy wskutek\n        błędnego wprowadzenia tekstu do pola "Szczegóły" informacja ta nie \n        będzie mogła być wyekstrahowana z tego pola, kliknij przycisk \n        "Uzupełnij", aby spowodować uzupełnienie tego pola na podstawie\n        pola "Szcegóły". \n        ', max_length=50, null=True),
        ),
        migrations.AddField(
            model_name='wydawnictwo_ciagle',
            name='tom',
            field=models.CharField(blank=True, help_text='Jeżeli uzupełnione, to pole będzie eksportowane do \n        danych PBN. Jeżeli puste, informacja ta będzie ekstrahowana z \n        pola \'Informacje\'. Kliknięcie przycisku "Uzupełnij" powoduje\n        również automatyczne wypełnienie tego pola, o ile do formularza\n        zostały wprowadzone odpowiednie informacje. ', max_length=50, null=True),
        ),
        migrations.AddField(
            model_name='wydawnictwo_zwarte',
            name='strony',
            field=models.CharField(blank=True, help_text='Jeżeli uzupełnione, to pole będzie eksportowane do \n        danych PBN. Jeżeli puste, informacja ta będzie ekstrahowana z \n        pola \'Szczegóły\' w chwili importu. Aby uniknąć sytuacji, gdy wskutek\n        błędnego wprowadzenia tekstu do pola "Szczegóły" informacja ta nie \n        będzie mogła być wyekstrahowana z tego pola, kliknij przycisk \n        "Uzupełnij", aby spowodować uzupełnienie tego pola na podstawie\n        pola "Szcegóły". \n        ', max_length=50, null=True),
        ),
        migrations.AddField(
            model_name='wydawnictwo_zwarte',
            name='tom',
            field=models.CharField(blank=True, help_text='Jeżeli uzupełnione, to pole będzie eksportowane do \n        danych PBN. Jeżeli puste, informacja ta będzie ekstrahowana z \n        pola \'Informacje\'. Kliknięcie przycisku "Uzupełnij" powoduje\n        również automatyczne wypełnienie tego pola, o ile do formularza\n        zostały wprowadzone odpowiednie informacje. ', max_length=50, null=True),
        ),

        migrations.RunPython(
            przerzuc_dane,
            migrations.RunPython.noop
        )
    ]
