# -*- coding: utf-8 -*-
# Generated by Django 1.11.8 on 2018-02-18 04:51
from __future__ import unicode_literals

from collections import defaultdict
from django.db import migrations, models


def zmigruj_typy_odpowiedzialnosci(apps, schema_editor):
    # Typ odpowiedzialnosci dla PBN domyślnie ustawiony jest na
    # "autor", więc ustawiamy tutaj tylko takie rekordy, któe tego
    # autora nie mają...
    from bpp.models import const
    mapping = defaultdict(
        lambda: const.TO_INNY,
        {
            "aut": const.TO_AUTOR,
            "autkoresp": const.TO_AUTOR,
            "red": const.TO_REDAKTOR,
            "rednaukwydpol": const.TO_REDAKTOR,
            "komentarz": const.TO_KOMENTATOR,
            "kom": const.TO_KOMENTATOR,
            "recenzja": const.TO_RECENZENT,
            "rec": const.TO_RECENZENT,
            "opracował": const.TO_OPRACOWAL,
            "oprac": const.TO_OPRACOWAL,
            "tłzjęzang": const.TO_TLUMACZ,
            "tł": const.TO_TLUMACZ,
            "tłang": const.TO_TLUMACZ,
            "": const.TO_INNY
        })

    Typ_Odpowiedzialnosci = apps.get_model("bpp", "Typ_Odpowiedzialnosci")
    for elem in Typ_Odpowiedzialnosci.objects.all():
        v = elem.skrot.lower() \
            .replace(" ", "") \
            .replace(".", "") \
            .replace(":", "") \
            .strip()
        elem.typ_ogolny = mapping.get(v)
        elem.save()

class Migration(migrations.Migration):

    dependencies = [
        ('bpp', '0115_auto_20171111_0038'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='typ_odpowiedzialnosci',
            options={'ordering': ['nazwa'], 'verbose_name': 'typ odpowiedzialności', 'verbose_name_plural': 'typy odpowiedzialności'},
        ),
        migrations.AddField(
            model_name='typ_odpowiedzialnosci',
            name='typ_ogolny',
            field=models.SmallIntegerField(choices=[(0, 'autor'), (1, 'redaktor'), (2, 'inny'), (3, 'tłumacz'), (4, 'komentator'), (5, 'recenzent'), (6, 'opracował')], default=0, help_text='Pole to jest używane celem rozróżniania typu odpowiedzialności\n        na cele eksportu do PBN (autor i redaktor) oraz może być też wykorzystywane\n        np. w raportach autorów i jednostek. \n        ', verbose_name='Typ odpowiedzialności dla PBN'),
        ),
        migrations.RunPython(
            zmigruj_typy_odpowiedzialnosci,
            migrations.RunPython.noop
        )
    ]
