# -*- coding: utf-8 -*-
# Generated by Django 1.11.10 on 2018-03-05 13:36
from __future__ import unicode_literals

from django.db import migrations, models

from bpp.migration_util import load_custom_sql


class Migration(migrations.Migration):

    dependencies = [
        ('bpp', '0119_pola_patentow'),
    ]

    operations = [
        # Zostaną utworzone ponownie w następnej migracji, a ich
        # obecność przeszkadzała będzie modyfikacji pola kc_impact_factor
        # dla poniższych tabel:

        migrations.RunSQL("DROP VIEW bpp_patent_view CASCADE"),
        migrations.RunSQL("DROP VIEW bpp_wydawnictwo_ciagle_view CASCADE"),
        migrations.RunSQL("DROP VIEW bpp_wydawnictwo_zwarte_view  CASCADE"),
        migrations.RunSQL("DROP VIEW bpp_praca_doktorska_view CASCADE"),
        migrations.RunSQL("DROP VIEW bpp_praca_habilitacyjna_view CASCADE"),

        migrations.RunSQL("DROP VIEW bpp_nowe_sumy_patent_view CASCADE"),
        migrations.RunSQL("DROP VIEW bpp_nowe_sumy_wydawnictwo_ciagle_view CASCADE"),
        migrations.RunSQL("DROP VIEW bpp_nowe_sumy_wydawnictwo_zwarte_view CASCADE"),
        migrations.RunSQL("DROP VIEW bpp_nowe_sumy_praca_doktorska_view CASCADE"),
        migrations.RunSQL("DROP VIEW bpp_nowe_sumy_praca_habilitacyjna_view CASCADE"),

        migrations.AlterField(
            model_name='patent',
            name='kc_impact_factor',
            field=models.DecimalField(blank=True, db_index=True, decimal_places=3, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa tego raportu.', max_digits=6, null=True, verbose_name='KC: Impact factor'),
        ),
        migrations.AlterField(
            model_name='praca_doktorska',
            name='kc_impact_factor',
            field=models.DecimalField(blank=True, db_index=True, decimal_places=3, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa tego raportu.', max_digits=6, null=True, verbose_name='KC: Impact factor'),
        ),
        migrations.AlterField(
            model_name='praca_habilitacyjna',
            name='kc_impact_factor',
            field=models.DecimalField(blank=True, db_index=True, decimal_places=3, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa tego raportu.', max_digits=6, null=True, verbose_name='KC: Impact factor'),
        ),
        migrations.AlterField(
            model_name='punktacja_zrodla',
            name='kc_impact_factor',
            field=models.DecimalField(blank=True, db_index=True, decimal_places=3, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa tego raportu.', max_digits=6, null=True, verbose_name='KC: Impact factor'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_ciagle',
            name='kc_impact_factor',
            field=models.DecimalField(blank=True, db_index=True, decimal_places=3, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa tego raportu.', max_digits=6, null=True, verbose_name='KC: Impact factor'),
        ),
        migrations.AlterField(
            model_name='wydawnictwo_zwarte',
            name='kc_impact_factor',
            field=models.DecimalField(blank=True, db_index=True, decimal_places=3, default=None, help_text='Jeżeli wpiszesz\n        wartość w to pole, to zostanie ona użyta w raporcie dla Komisji\n        Centralnej w punkcie IXa tego raportu.', max_digits=6, null=True, verbose_name='KC: Impact factor'),
        ),

        # Wczytaj ponownie ostatnie poprawne widoki
        migrations.RunPython(
            lambda *args, **kw: load_custom_sql("0103_widoki_nowe_sumy")
        ),

        migrations.RunPython(
            lambda *args, **kw: load_custom_sql("108_bpp_nowe_sumy_view_bug")
        )
    ]
