# Generated by Django 3.0.11 on 2021-03-08 07:39

from decimal import Decimal

import django.core.validators
from django.db import migrations, models

import bpp.models.uczelnia


class Migration(migrations.Migration):

    dependencies = [
        ("raport_slotow", "0007_auto_20210130_1407"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="raportslotowuczelnia",
            options={},
        ),
        migrations.AddField(
            model_name="raportslotowuczelnia",
            name="akcja",
            field=models.CharField(
                choices=[
                    ("slot", "do wielkości slotu"),
                    ("wszystko", "wszystkie prace"),
                ],
                default="slot",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="raportslotowuczelnia",
            name="do_roku",
            field=models.IntegerField(
                default=bpp.models.uczelnia.UczelniaManager.do_roku_default
            ),
        ),
        migrations.AlterField(
            model_name="raportslotowuczelnia",
            name="pokazuj_zerowych",
            field=models.BooleanField(
                default=False,
                help_text="Autor z zerowym slotem to autor, który ma na zadany okres czasu zadeklarowane dyscypliny,\n        ale nie posiada żadnych punktowanych prac w tych dyscyplinach. Jeżeli jednoczesnie podasz parametr\n         'minimalny PK' dla tego raportu, to prace z PK poniżej tego progu zostaną potraktowane jako \"zerowe\"\n         czyli bez punktacji. ",
                verbose_name="Dołączaj autorów z zerowymi slotami",
            ),
        ),
        migrations.AlterField(
            model_name="raportslotowuczelnia",
            name="slot",
            field=models.DecimalField(
                decimal_places=4,
                default=Decimal("1"),
                max_digits=7,
                validators=[django.core.validators.MaxValueValidator(20)],
            ),
        ),
    ]
