"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBInstance = exports.DBInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "DBInstanceProperty", { enumerable: true, get: function () { return rds_generated_1.RosDBInstance; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::DBInstance`
 */
class DBInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::DBInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBInstance = new rds_generated_1.RosDBInstance(this, id, {
            periodType: props.periodType === undefined || props.periodType === null ? 'Month' : props.periodType,
            resourceGroupId: props.resourceGroupId,
            archiveBackupRetentionPeriod: props.archiveBackupRetentionPeriod,
            dbTimeZone: props.dbTimeZone,
            port: props.port,
            archiveBackupKeepCount: props.archiveBackupKeepCount,
            logBackupRetentionPeriod: props.logBackupRetentionPeriod,
            dbInstanceStorage: props.dbInstanceStorage,
            dbMappings: props.dbMappings,
            connectionStringPrefix: props.connectionStringPrefix,
            multiAz: props.multiAz === undefined || props.multiAz === null ? false : props.multiAz,
            engine: props.engine,
            tags: props.tags,
            dbInstanceDescription: props.dbInstanceDescription,
            targetDedicatedHostIdForMaster: props.targetDedicatedHostIdForMaster,
            engineVersion: props.engineVersion,
            dbInstanceClass: props.dbInstanceClass,
            archiveBackupKeepPolicy: props.archiveBackupKeepPolicy,
            vSwitchId: props.vSwitchId,
            backupPolicyMode: props.backupPolicyMode,
            period: props.period === undefined || props.period === null ? 1 : props.period,
            localLogRetentionHours: props.localLogRetentionHours,
            payType: props.payType === undefined || props.payType === null ? 'Postpaid' : props.payType,
            highSpaceUsageProtection: props.highSpaceUsageProtection,
            roleArn: props.roleArn,
            masterUserPassword: props.masterUserPassword,
            vpcId: props.vpcId,
            sslSetting: props.sslSetting === undefined || props.sslSetting === null ? 'Disabled' : props.sslSetting,
            masterUsername: props.masterUsername,
            connectionMode: props.connectionMode,
            localLogRetentionSpace: props.localLogRetentionSpace,
            category: props.category,
            privateIpAddress: props.privateIpAddress,
            targetDedicatedHostIdForSlave: props.targetDedicatedHostIdForSlave,
            dbInstanceNetType: props.dbInstanceNetType === undefined || props.dbInstanceNetType === null ? 'Intranet' : props.dbInstanceNetType,
            releasedKeepPolicy: props.releasedKeepPolicy,
            dedicatedHostGroupId: props.dedicatedHostGroupId,
            autoRenew: props.autoRenew,
            encryptionKey: props.encryptionKey,
            preferredBackupPeriod: props.preferredBackupPeriod,
            logBackupLocalRetentionNumber: props.logBackupLocalRetentionNumber,
            slaveZoneIds: props.slaveZoneIds,
            securityIpList: props.securityIpList,
            dbIsIgnoreCase: props.dbIsIgnoreCase,
            maintainTime: props.maintainTime,
            dbParamGroupId: props.dbParamGroupId,
            zoneId: props.zoneId,
            targetDedicatedHostIdForLog: props.targetDedicatedHostIdForLog,
            allocatePublicConnection: props.allocatePublicConnection,
            preferredBackupTime: props.preferredBackupTime,
            securityGroupId: props.securityGroupId,
            dbInstanceStorageType: props.dbInstanceStorageType,
            backUpCategory: props.backUpCategory,
            compressType: props.compressType,
            logBackupFrequency: props.logBackupFrequency,
            connectionStringType: props.connectionStringType === undefined || props.connectionStringType === null ? 'Inner' : props.connectionStringType,
            masterUserType: props.masterUserType === undefined || props.masterUserType === null ? 'Normal' : props.masterUserType,
            enableBackupLog: props.enableBackupLog,
            sqlCollectorStatus: props.sqlCollectorStatus,
            backupRetentionPeriod: props.backupRetentionPeriod === undefined || props.backupRetentionPeriod === null ? 7 : props.backupRetentionPeriod,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBInstance;
        this.attrDbInstanceId = rosDBInstance.attrDbInstanceId;
        this.attrInnerConnectionString = rosDBInstance.attrInnerConnectionString;
        this.attrInnerIpAddress = rosDBInstance.attrInnerIpAddress;
        this.attrInnerPort = rosDBInstance.attrInnerPort;
        this.attrPublicConnectionString = rosDBInstance.attrPublicConnectionString;
        this.attrPublicIpAddress = rosDBInstance.attrPublicIpAddress;
        this.attrPublicPort = rosDBInstance.attrPublicPort;
    }
}
exports.DBInstance = DBInstance;
//# sourceMappingURL=data:application/json;base64,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