"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBInstanceClone = exports.DBInstanceCloneProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "DBInstanceCloneProperty", { enumerable: true, get: function () { return rds_generated_1.RosDBInstanceClone; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::DBInstanceClone`
 */
class DBInstanceClone extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::DBInstanceClone`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBInstanceClone = new rds_generated_1.RosDBInstanceClone(this, id, {
            periodType: props.periodType === undefined || props.periodType === null ? 'Month' : props.periodType,
            category: props.category,
            privateIpAddress: props.privateIpAddress,
            dedicatedHostGroupId: props.dedicatedHostGroupId,
            port: props.port,
            backupId: props.backupId,
            instanceNetworkType: props.instanceNetworkType,
            restoreTime: props.restoreTime,
            preferredBackupPeriod: props.preferredBackupPeriod,
            dbNames: props.dbNames,
            slaveZoneIds: props.slaveZoneIds,
            dbInstanceId: props.dbInstanceId,
            securityIpList: props.securityIpList,
            dbInstanceStorage: props.dbInstanceStorage,
            backupType: props.backupType,
            dbMappings: props.dbMappings,
            connectionStringPrefix: props.connectionStringPrefix,
            maintainTime: props.maintainTime,
            tags: props.tags,
            dbInstanceDescription: props.dbInstanceDescription,
            zoneId: props.zoneId,
            dbInstanceClass: props.dbInstanceClass,
            allocatePublicConnection: props.allocatePublicConnection,
            preferredBackupTime: props.preferredBackupTime,
            vSwitchId: props.vSwitchId,
            securityGroupId: props.securityGroupId,
            period: props.period === undefined || props.period === null ? 1 : props.period,
            payType: props.payType === undefined || props.payType === null ? 'Postpaid' : props.payType,
            dbInstanceStorageType: props.dbInstanceStorageType,
            connectionStringType: props.connectionStringType === undefined || props.connectionStringType === null ? 'Inner' : props.connectionStringType,
            restoreTable: props.restoreTable,
            masterUserPassword: props.masterUserPassword,
            masterUserType: props.masterUserType === undefined || props.masterUserType === null ? 'Normal' : props.masterUserType,
            vpcId: props.vpcId,
            sslSetting: props.sslSetting === undefined || props.sslSetting === null ? 'Disabled' : props.sslSetting,
            masterUsername: props.masterUsername,
            sqlCollectorStatus: props.sqlCollectorStatus,
            backupRetentionPeriod: props.backupRetentionPeriod === undefined || props.backupRetentionPeriod === null ? 7 : props.backupRetentionPeriod,
            tableMeta: props.tableMeta,
            timeoutInMinutes: props.timeoutInMinutes === undefined || props.timeoutInMinutes === null ? 120 : props.timeoutInMinutes,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBInstanceClone;
        this.attrDbInstanceId = rosDBInstanceClone.attrDbInstanceId;
        this.attrInnerConnectionString = rosDBInstanceClone.attrInnerConnectionString;
        this.attrInnerIpAddress = rosDBInstanceClone.attrInnerIpAddress;
        this.attrInnerPort = rosDBInstanceClone.attrInnerPort;
        this.attrPublicConnectionString = rosDBInstanceClone.attrPublicConnectionString;
        this.attrPublicIpAddress = rosDBInstanceClone.attrPublicIpAddress;
        this.attrPublicPort = rosDBInstanceClone.attrPublicPort;
    }
}
exports.DBInstanceClone = DBInstanceClone;
//# sourceMappingURL=data:application/json;base64,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