"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrepayDBInstance = exports.PrepayDBInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "PrepayDBInstanceProperty", { enumerable: true, get: function () { return rds_generated_1.RosPrepayDBInstance; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::PrepayDBInstance`
 */
class PrepayDBInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::PrepayDBInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosPrepayDBInstance = new rds_generated_1.RosPrepayDBInstance(this, id, {
            periodType: props.periodType === undefined || props.periodType === null ? 'Month' : props.periodType,
            resourceGroupId: props.resourceGroupId,
            archiveBackupRetentionPeriod: props.archiveBackupRetentionPeriod,
            dbTimeZone: props.dbTimeZone,
            port: props.port,
            archiveBackupKeepCount: props.archiveBackupKeepCount,
            logBackupRetentionPeriod: props.logBackupRetentionPeriod,
            dbInstanceStorage: props.dbInstanceStorage,
            dbMappings: props.dbMappings,
            connectionStringPrefix: props.connectionStringPrefix,
            multiAz: props.multiAz === undefined || props.multiAz === null ? false : props.multiAz,
            engine: props.engine,
            tags: props.tags,
            dbInstanceDescription: props.dbInstanceDescription,
            targetDedicatedHostIdForMaster: props.targetDedicatedHostIdForMaster,
            engineVersion: props.engineVersion,
            dbInstanceClass: props.dbInstanceClass,
            archiveBackupKeepPolicy: props.archiveBackupKeepPolicy,
            vSwitchId: props.vSwitchId,
            backupPolicyMode: props.backupPolicyMode,
            period: props.period === undefined || props.period === null ? 1 : props.period,
            localLogRetentionHours: props.localLogRetentionHours,
            highSpaceUsageProtection: props.highSpaceUsageProtection,
            roleArn: props.roleArn,
            masterUserPassword: props.masterUserPassword,
            vpcId: props.vpcId,
            sslSetting: props.sslSetting === undefined || props.sslSetting === null ? 'Disabled' : props.sslSetting,
            masterUsername: props.masterUsername,
            connectionMode: props.connectionMode,
            localLogRetentionSpace: props.localLogRetentionSpace,
            category: props.category,
            privateIpAddress: props.privateIpAddress,
            targetDedicatedHostIdForSlave: props.targetDedicatedHostIdForSlave,
            dbInstanceNetType: props.dbInstanceNetType === undefined || props.dbInstanceNetType === null ? 'Intranet' : props.dbInstanceNetType,
            releasedKeepPolicy: props.releasedKeepPolicy,
            dedicatedHostGroupId: props.dedicatedHostGroupId,
            autoRenew: props.autoRenew === undefined || props.autoRenew === null ? false : props.autoRenew,
            encryptionKey: props.encryptionKey,
            preferredBackupPeriod: props.preferredBackupPeriod,
            logBackupLocalRetentionNumber: props.logBackupLocalRetentionNumber,
            slaveZoneIds: props.slaveZoneIds,
            dbIsIgnoreCase: props.dbIsIgnoreCase,
            commodityCode: props.commodityCode === undefined || props.commodityCode === null ? 'rds' : props.commodityCode,
            maintainTime: props.maintainTime,
            dbParamGroupId: props.dbParamGroupId,
            zoneId: props.zoneId,
            targetDedicatedHostIdForLog: props.targetDedicatedHostIdForLog,
            allocatePublicConnection: props.allocatePublicConnection,
            preferredBackupTime: props.preferredBackupTime,
            securityGroupId: props.securityGroupId,
            quantity: props.quantity === undefined || props.quantity === null ? 1 : props.quantity,
            autoPay: props.autoPay === undefined || props.autoPay === null ? false : props.autoPay,
            dbInstanceStorageType: props.dbInstanceStorageType,
            backUpCategory: props.backUpCategory,
            compressType: props.compressType,
            logBackupFrequency: props.logBackupFrequency,
            connectionStringType: props.connectionStringType === undefined || props.connectionStringType === null ? 'Inner' : props.connectionStringType,
            couponCode: props.couponCode,
            masterUserType: props.masterUserType === undefined || props.masterUserType === null ? 'Normal' : props.masterUserType,
            enableBackupLog: props.enableBackupLog,
            sqlCollectorStatus: props.sqlCollectorStatus,
            backupRetentionPeriod: props.backupRetentionPeriod === undefined || props.backupRetentionPeriod === null ? 7 : props.backupRetentionPeriod,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosPrepayDBInstance;
        this.attrDbInstanceId = rosPrepayDBInstance.attrDbInstanceId;
        this.attrInnerConnectionString = rosPrepayDBInstance.attrInnerConnectionString;
        this.attrInnerIpAddress = rosPrepayDBInstance.attrInnerIpAddress;
        this.attrInnerPort = rosPrepayDBInstance.attrInnerPort;
        this.attrOrderId = rosPrepayDBInstance.attrOrderId;
        this.attrPublicConnectionString = rosPrepayDBInstance.attrPublicConnectionString;
        this.attrPublicIpAddress = rosPrepayDBInstance.attrPublicIpAddress;
        this.attrPublicPort = rosPrepayDBInstance.attrPublicPort;
    }
}
exports.PrepayDBInstance = PrepayDBInstance;
//# sourceMappingURL=data:application/json;base64,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