import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ExtensionConfig extends cdktf.TerraformMetaArguments {
    /**
    * When true, will also create any extensions that this extension depends on that are not already installed
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/extension#create_cascade Extension#create_cascade}
    */
    readonly createCascade?: boolean | cdktf.IResolvable;
    /**
    * Sets the database to add the extension to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/extension#database Extension#database}
    */
    readonly database?: string;
    /**
    * When true, will also drop all the objects that depend on the extension, and in turn all objects that depend on those objects
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/extension#drop_cascade Extension#drop_cascade}
    */
    readonly dropCascade?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/extension#id Extension#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/extension#name Extension#name}
    */
    readonly name: string;
    /**
    * Sets the schema of an extension
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/extension#schema Extension#schema}
    */
    readonly schema?: string;
    /**
    * Sets the version number of the extension
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/extension#version Extension#version}
    */
    readonly version?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/extension postgresql_extension}
*/
export declare class Extension extends cdktf.TerraformResource {
    static readonly tfResourceType = "postgresql_extension";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/extension postgresql_extension} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExtensionConfig
    */
    constructor(scope: Construct, id: string, config: ExtensionConfig);
    private _createCascade?;
    get createCascade(): boolean | cdktf.IResolvable;
    set createCascade(value: boolean | cdktf.IResolvable);
    resetCreateCascade(): void;
    get createCascadeInput(): boolean | cdktf.IResolvable | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _dropCascade?;
    get dropCascade(): boolean | cdktf.IResolvable;
    set dropCascade(value: boolean | cdktf.IResolvable);
    resetDropCascade(): void;
    get dropCascadeInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=extension.d.ts.map