"""Repeat the following paper for `HJ`:
    Hooke, R. and Jeeves, T.A., 1961.
    “Direct search” solution of numerical and statistical problems.
    Journal of the ACM, 8(2), pp.212-229.
    https://dl.acm.org/doi/10.1145/321062.321069

    Luckily our Python code could repeat the data generated by the other Python code *well*.
    Therefore, we argue that its repeatability could be **well-documented**.



    The Python reference script is given below (note that first install `pymoo` via `pip install pymoo`):
    -----------------------------------------------------------------------------------------------------
    from pymoo.algorithms.soo.nonconvex.pattern import PatternSearch
    from pymoo.problems.single import Ackley
    from pymoo.optimize import minimize

    problem = Ackley(n_var=100)
    algorithm = PatternSearch(init_delta=0.1)
    res = minimize(problem=problem, algorithm=algorithm, termination=('n_eval', 1e6),  verbose=True, seed=0)
    print(res)
"""
import time

import numpy as np

from pypop7.benchmarks.base_functions import ackley
from pypop7.optimizers.ds.hj import HJ as Solver


if __name__ == '__main__':
    start_run = time.time()
    ndim_problem = 100
    for f in [ackley]:
        print('*' * 7 + ' ' + f.__name__ + ' ' + '*' * 7)
        problem = {'fitness_function': f,
                   'ndim_problem': ndim_problem,
                   'lower_boundary': -32.768*np.ones((ndim_problem,)),
                   'upper_boundary': 32.768*np.ones((ndim_problem,))}
        options = {'max_function_evaluations': 1e6,
                   'seed_rng': 0,
                   'sigma': 0.1,
                   'is_restart': False}
        solver = Solver(problem, options)
        results = solver.optimize()
        print(results)  # 19.544448155486872 vs 1.924563E+01 (from `pymoo`)
        print('*** Runtime: {:7.5e}'.format(time.time() - start_run))
