"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Connect = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [connect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Connect extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [connect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'connect';
        this.accessLevelList = {
            Write: [
                'AssociateApprovedOrigin',
                'AssociateBot',
                'AssociateCustomerProfilesDomain',
                'AssociateDefaultVocabulary',
                'AssociateInstanceStorageConfig',
                'AssociateLambdaFunction',
                'AssociateLexBot',
                'AssociatePhoneNumberContactFlow',
                'AssociateQueueQuickConnects',
                'AssociateRoutingProfileQueues',
                'AssociateSecurityKey',
                'BatchAssociateAnalyticsDataSet',
                'BatchDisassociateAnalyticsDataSet',
                'ClaimPhoneNumber',
                'CreateAgentStatus',
                'CreateContactFlow',
                'CreateContactFlowModule',
                'CreateHoursOfOperation',
                'CreateInstance',
                'CreateIntegrationAssociation',
                'CreateQueue',
                'CreateQuickConnect',
                'CreateRoutingProfile',
                'CreateSecurityProfile',
                'CreateTaskTemplate',
                'CreateUseCase',
                'CreateUser',
                'CreateUserHierarchyGroup',
                'CreateVocabulary',
                'DeleteContactFlow',
                'DeleteContactFlowModule',
                'DeleteHoursOfOperation',
                'DeleteInstance',
                'DeleteIntegrationAssociation',
                'DeleteQuickConnect',
                'DeleteSecurityProfile',
                'DeleteTaskTemplate',
                'DeleteUseCase',
                'DeleteUser',
                'DeleteUserHierarchyGroup',
                'DeleteVocabulary',
                'DisassociateApprovedOrigin',
                'DisassociateBot',
                'DisassociateCustomerProfilesDomain',
                'DisassociateInstanceStorageConfig',
                'DisassociateLambdaFunction',
                'DisassociateLexBot',
                'DisassociatePhoneNumberContactFlow',
                'DisassociateQueueQuickConnects',
                'DisassociateRoutingProfileQueues',
                'DisassociateSecurityKey',
                'GetFederationTokens',
                'PutUserStatus',
                'ReleasePhoneNumber',
                'ResumeContactRecording',
                'StartChatContact',
                'StartContactRecording',
                'StartContactStreaming',
                'StartOutboundVoiceContact',
                'StartTaskContact',
                'StopContact',
                'StopContactRecording',
                'StopContactStreaming',
                'SuspendContactRecording',
                'TransferContact',
                'UpdateAgentStatus',
                'UpdateContact',
                'UpdateContactAttributes',
                'UpdateContactFlowContent',
                'UpdateContactFlowMetadata',
                'UpdateContactFlowModuleContent',
                'UpdateContactFlowModuleMetadata',
                'UpdateContactFlowName',
                'UpdateContactSchedule',
                'UpdateHoursOfOperation',
                'UpdateInstanceAttribute',
                'UpdateInstanceStorageConfig',
                'UpdatePhoneNumber',
                'UpdateQueueHoursOfOperation',
                'UpdateQueueMaxContacts',
                'UpdateQueueName',
                'UpdateQueueOutboundCallerConfig',
                'UpdateQueueStatus',
                'UpdateQuickConnectConfig',
                'UpdateQuickConnectName',
                'UpdateRoutingProfileConcurrency',
                'UpdateRoutingProfileDefaultOutboundQueue',
                'UpdateRoutingProfileName',
                'UpdateRoutingProfileQueues',
                'UpdateSecurityProfile',
                'UpdateTaskTemplate',
                'UpdateUserHierarchy',
                'UpdateUserHierarchyGroupName',
                'UpdateUserHierarchyStructure',
                'UpdateUserIdentityInfo',
                'UpdateUserPhoneConfig',
                'UpdateUserRoutingProfile',
                'UpdateUserSecurityProfiles',
                'UpdatedescribeContent'
            ],
            Read: [
                'DescribeAgentStatus',
                'DescribeContact',
                'DescribeContactFlow',
                'DescribeContactFlowModule',
                'DescribeHoursOfOperation',
                'DescribeInstance',
                'DescribeInstanceAttribute',
                'DescribeInstanceStorageConfig',
                'DescribeQueue',
                'DescribeQuickConnect',
                'DescribeRoutingProfile',
                'DescribeSecurityProfile',
                'DescribeUser',
                'DescribeUserHierarchyGroup',
                'DescribeUserHierarchyStructure',
                'DescribeVocabulary',
                'GetContactAttributes',
                'GetCurrentMetricData',
                'GetCurrentUserData',
                'GetFederationToken',
                'GetMetricData',
                'GetTaskTemplate',
                'ListRealtimeContactAnalysisSegments',
                'ListTagsForResource',
                'SearchQueues',
                'SearchRoutingProfiles',
                'SearchSecurityProfiles',
                'SearchUsers'
            ],
            List: [
                'DescribePhoneNumber',
                'ListAgentStatuses',
                'ListApprovedOrigins',
                'ListBots',
                'ListContactFlowModules',
                'ListContactFlows',
                'ListContactReferences',
                'ListDefaultVocabularies',
                'ListHoursOfOperations',
                'ListInstanceAttributes',
                'ListInstanceStorageConfigs',
                'ListInstances',
                'ListIntegrationAssociations',
                'ListLambdaFunctions',
                'ListLexBots',
                'ListPhoneNumbers',
                'ListPhoneNumbersV2',
                'ListPrompts',
                'ListQueueQuickConnects',
                'ListQueues',
                'ListQuickConnects',
                'ListRoutingProfileQueues',
                'ListRoutingProfiles',
                'ListSecurityKeys',
                'ListSecurityProfilePermissions',
                'ListSecurityProfiles',
                'ListTaskTemplates',
                'ListUseCases',
                'ListUserHierarchyGroups',
                'ListUsers',
                'SearchAvailablePhoneNumbers',
                'SearchVocabularies'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to associate approved origin for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateApprovedOrigin() {
        return this.to('AssociateApprovedOrigin');
    }
    /**
     * Grants permission to associate a Lex bot for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - lex:CreateResourcePolicy
     * - lex:DescribeBotAlias
     * - lex:GetBot
     * - lex:UpdateResourcePolicy
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateBot() {
        return this.to('AssociateBot');
    }
    /**
     * Grants permission to associate a Customer Profiles domain for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - profile:GetDomain
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateCustomerProfilesDomain() {
        return this.to('AssociateCustomerProfilesDomain');
    }
    /**
     * Grants permission to default vocabulary for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     */
    toAssociateDefaultVocabulary() {
        return this.to('AssociateDefaultVocabulary');
    }
    /**
     * Grants permission to associate instance storage for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifStorageResourceType()
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     * - firehose:DescribeDeliveryStream
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - kinesis:DescribeStream
     * - kms:CreateGrant
     * - kms:DescribeKey
     * - s3:GetBucketAcl
     * - s3:GetBucketLocation
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateInstanceStorageConfig() {
        return this.to('AssociateInstanceStorageConfig');
    }
    /**
     * Grants permission to associate a Lambda function for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - lambda:AddPermission
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateLambdaFunction() {
        return this.to('AssociateLambdaFunction');
    }
    /**
     * Grants permission to associate a Lex bot for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - lex:GetBot
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateLexBot() {
        return this.to('AssociateLexBot');
    }
    /**
     * Grants permission to associate contact flow resources to phone number resources in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_AssociatePhoneNumberContactFlow.html
     */
    toAssociatePhoneNumberContactFlow() {
        return this.to('AssociatePhoneNumberContactFlow');
    }
    /**
     * Grants permission to associate quick connects with a queue in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_AssociateQueueQuickConnects.html
     */
    toAssociateQueueQuickConnects() {
        return this.to('AssociateQueueQuickConnects');
    }
    /**
     * Grants permission to associate queues with a routing profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_AssociateRoutingProfileQueues.html
     */
    toAssociateRoutingProfileQueues() {
        return this.to('AssociateRoutingProfileQueues');
    }
    /**
     * Grants permission to associate a security key for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateSecurityKey() {
        return this.to('AssociateSecurityKey');
    }
    /**
     * Grants permission to grant access and to associate the datasets with the specified AWS account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/optimization-apis.html
     */
    toBatchAssociateAnalyticsDataSet() {
        return this.to('BatchAssociateAnalyticsDataSet');
    }
    /**
     * Grants permission to revoke access and to disassociate the datasets with the specified AWS account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/optimization-apis.html
     */
    toBatchDisassociateAnalyticsDataSet() {
        return this.to('BatchDisassociateAnalyticsDataSet');
    }
    /**
     * Grants permission to claim phone number resources in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html
     */
    toClaimPhoneNumber() {
        return this.to('ClaimPhoneNumber');
    }
    /**
     * Grants permission to create agent status in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateAgentStatus.html
     */
    toCreateAgentStatus() {
        return this.to('CreateAgentStatus');
    }
    /**
     * Grants permission to create a contact flow in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateContactFlow.html
     */
    toCreateContactFlow() {
        return this.to('CreateContactFlow');
    }
    /**
     * Grants permission to create a contact flow module in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateContactFlowModule.html
     */
    toCreateContactFlowModule() {
        return this.to('CreateContactFlowModule');
    }
    /**
     * Grants permission to create hours of operation in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateHoursOfOperation.html
     */
    toCreateHoursOfOperation() {
        return this.to('CreateHoursOfOperation');
    }
    /**
     * Grants permission to create a new Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ds:AuthorizeApplication
     * - ds:CheckAlias
     * - ds:CreateAlias
     * - ds:CreateDirectory
     * - ds:CreateIdentityPoolDirectory
     * - ds:DeleteDirectory
     * - ds:DescribeDirectories
     * - ds:UnauthorizeApplication
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toCreateInstance() {
        return this.to('CreateInstance');
    }
    /**
     * Grants permission to create an integration association with an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - app-integrations:CreateEventIntegrationAssociation
     * - connect:DescribeInstance
     * - ds:DescribeDirectories
     * - events:PutRule
     * - events:PutTargets
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - mobiletargeting:GetApp
     * - voiceid:DescribeDomain
     * - wisdom:GetAssistant
     * - wisdom:GetKnowledgeBase
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateIntegrationAssociation.html
     */
    toCreateIntegrationAssociation() {
        return this.to('CreateIntegrationAssociation');
    }
    /**
     * Grants permission to create a queue in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateQueue.html
     */
    toCreateQueue() {
        return this.to('CreateQueue');
    }
    /**
     * Grants permission to create a quick connect in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateQuickConnect.html
     */
    toCreateQuickConnect() {
        return this.to('CreateQuickConnect');
    }
    /**
     * Grants permission to create a routing profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateRoutingProfile.html
     */
    toCreateRoutingProfile() {
        return this.to('CreateRoutingProfile');
    }
    /**
     * Grants permission to create a security profile for the specified Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateSecurityProfile.html
     */
    toCreateSecurityProfile() {
        return this.to('CreateSecurityProfile');
    }
    /**
     * Grants permission to create a task template in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTaskTemplate.html
     */
    toCreateTaskTemplate() {
        return this.to('CreateTaskTemplate');
    }
    /**
     * Grants permission to create a use case for an integration association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - connect:DescribeInstance
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateUseCase.html
     */
    toCreateUseCase() {
        return this.to('CreateUseCase');
    }
    /**
     * Grants permission to create a user for the specified Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateUser.html
     */
    toCreateUser() {
        return this.to('CreateUser');
    }
    /**
     * Grants permission to create a user hierarchy group in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateUserHierarchyGroup.html
     */
    toCreateUserHierarchyGroup() {
        return this.to('CreateUserHierarchyGroup');
    }
    /**
     * Grants permission to create a vocabulary in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateVocabulary.html
     */
    toCreateVocabulary() {
        return this.to('CreateVocabulary');
    }
    /**
     * Grants permission to delete a contact flow in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteContactFlow.html
     */
    toDeleteContactFlow() {
        return this.to('DeleteContactFlow');
    }
    /**
     * Grants permission to delete a contact flow module in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteContactFlowModule.html
     */
    toDeleteContactFlowModule() {
        return this.to('DeleteContactFlowModule');
    }
    /**
     * Grants permission to delete hours of operation in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteHoursOfOperation.html
     */
    toDeleteHoursOfOperation() {
        return this.to('DeleteHoursOfOperation');
    }
    /**
     * Grants permission to delete an Amazon Connect instance. When you remove an instance, the link to an existing AWS directory is also removed
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ds:DeleteDirectory
     * - ds:DescribeDirectories
     * - ds:UnauthorizeApplication
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDeleteInstance() {
        return this.to('DeleteInstance');
    }
    /**
     * Grants permission to delete an integration association from an Amazon Connect instance. The association must not have any use cases associated with it
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - app-integrations:DeleteEventIntegrationAssociation
     * - connect:DescribeInstance
     * - ds:DescribeDirectories
     * - events:DeleteRule
     * - events:ListTargetsByRule
     * - events:RemoveTargets
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteIntegrationAssociation.html
     */
    toDeleteIntegrationAssociation() {
        return this.to('DeleteIntegrationAssociation');
    }
    /**
     * Grants permission to delete a quick connect in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteQuickConnect.html
     */
    toDeleteQuickConnect() {
        return this.to('DeleteQuickConnect');
    }
    /**
     * Grants permission to delete a security profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteSecurityProfile.html
     */
    toDeleteSecurityProfile() {
        return this.to('DeleteSecurityProfile');
    }
    /**
     * Grants permission to delete a task template in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTaskTemplate.html
     */
    toDeleteTaskTemplate() {
        return this.to('DeleteTaskTemplate');
    }
    /**
     * Grants permission to delete a use case from an integration association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - connect:DescribeInstance
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteUseCase.html
     */
    toDeleteUseCase() {
        return this.to('DeleteUseCase');
    }
    /**
     * Grants permission to delete a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteUser.html
     */
    toDeleteUser() {
        return this.to('DeleteUser');
    }
    /**
     * Grants permission to delete a user hierarchy group in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteUserHierarchyGroup.html
     */
    toDeleteUserHierarchyGroup() {
        return this.to('DeleteUserHierarchyGroup');
    }
    /**
     * Grants permission to delete a vocabulary in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteVocabulary.html
     */
    toDeleteVocabulary() {
        return this.to('DeleteVocabulary');
    }
    /**
     * Grants permission to describe agent status in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeAgentStatus.html
     */
    toDescribeAgentStatus() {
        return this.to('DescribeAgentStatus');
    }
    /**
     * Grants permission to describe a contact in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeContact.html
     */
    toDescribeContact() {
        return this.to('DescribeContact');
    }
    /**
     * Grants permission to describe a contact flow in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeContactFlow.html
     */
    toDescribeContactFlow() {
        return this.to('DescribeContactFlow');
    }
    /**
     * Grants permission to describe a contact flow module in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeContactFlowModule.html
     */
    toDescribeContactFlowModule() {
        return this.to('DescribeContactFlowModule');
    }
    /**
     * Grants permission to describe hours of operation in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeHoursOfOperation.html
     */
    toDescribeHoursOfOperation() {
        return this.to('DescribeHoursOfOperation');
    }
    /**
     * Grants permission to view details of an Amazon Connect instance and is also required to create an instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDescribeInstance() {
        return this.to('DescribeInstance');
    }
    /**
     * Grants permission to view the attribute details of an existing Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAttributeType()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDescribeInstanceAttribute() {
        return this.to('DescribeInstanceAttribute');
    }
    /**
     * Grants permission to view the instance storage configuration for an existing Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifStorageResourceType()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDescribeInstanceStorageConfig() {
        return this.to('DescribeInstanceStorageConfig');
    }
    /**
     * Grants permission to describe phone number resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html
     */
    toDescribePhoneNumber() {
        return this.to('DescribePhoneNumber');
    }
    /**
     * Grants permission to describe a queue in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeQueue.html
     */
    toDescribeQueue() {
        return this.to('DescribeQueue');
    }
    /**
     * Grants permission to describe a quick connect in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeQuickConnect.html
     */
    toDescribeQuickConnect() {
        return this.to('DescribeQuickConnect');
    }
    /**
     * Grants permission to describe a routing profile in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeRoutingProfile.html
     */
    toDescribeRoutingProfile() {
        return this.to('DescribeRoutingProfile');
    }
    /**
     * Grants permission to describe a security profile in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeSecurityProfile.html
     */
    toDescribeSecurityProfile() {
        return this.to('DescribeSecurityProfile');
    }
    /**
     * Grants permission to describe a user in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeUser.html
     */
    toDescribeUser() {
        return this.to('DescribeUser');
    }
    /**
     * Grants permission to describe a hierarchy group for an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeUserHierarchyGroup.html
     */
    toDescribeUserHierarchyGroup() {
        return this.to('DescribeUserHierarchyGroup');
    }
    /**
     * Grants permission to describe the hierarchy structure for an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeUserHierarchyStructure.html
     */
    toDescribeUserHierarchyStructure() {
        return this.to('DescribeUserHierarchyStructure');
    }
    /**
     * Grants permission to describe a vocabulary in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeVocabulary.html
     */
    toDescribeVocabulary() {
        return this.to('DescribeVocabulary');
    }
    /**
     * Grants permission to disassociate approved origin for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateApprovedOrigin() {
        return this.to('DisassociateApprovedOrigin');
    }
    /**
     * Grants permission to disassociate a Lex bot for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - lex:DeleteResourcePolicy
     * - lex:UpdateResourcePolicy
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateBot() {
        return this.to('DisassociateBot');
    }
    /**
     * Grants permission to disassociate a Customer Profiles domain for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:AttachRolePolicy
     * - iam:DeleteRolePolicy
     * - iam:DetachRolePolicy
     * - iam:GetPolicy
     * - iam:GetPolicyVersion
     * - iam:GetRolePolicy
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateCustomerProfilesDomain() {
        return this.to('DisassociateCustomerProfilesDomain');
    }
    /**
     * Grants permission to disassociate instance storage for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifStorageResourceType()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateInstanceStorageConfig() {
        return this.to('DisassociateInstanceStorageConfig');
    }
    /**
     * Grants permission to disassociate a Lambda function for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - lambda:RemovePermission
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateLambdaFunction() {
        return this.to('DisassociateLambdaFunction');
    }
    /**
     * Grants permission to disassociate a Lex bot for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateLexBot() {
        return this.to('DisassociateLexBot');
    }
    /**
     * Grants permission to disassociate contact flow resources from phone number resources in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DisassociatePhoneNumberContactFlow.html
     */
    toDisassociatePhoneNumberContactFlow() {
        return this.to('DisassociatePhoneNumberContactFlow');
    }
    /**
     * Grants permission to disassociate quick connects from a queue in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DisassociateQueueQuickConnects.html
     */
    toDisassociateQueueQuickConnects() {
        return this.to('DisassociateQueueQuickConnects');
    }
    /**
     * Grants permission to disassociate queues from a routing profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DisassociateRoutingProfileQueues.html
     */
    toDisassociateRoutingProfileQueues() {
        return this.to('DisassociateRoutingProfileQueues');
    }
    /**
     * Grants permission to disassociate the security key for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateSecurityKey() {
        return this.to('DisassociateSecurityKey');
    }
    /**
     * Grants permission to retrieve the contact attributes for the specified contact
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_GetContactAttributes.html
     */
    toGetContactAttributes() {
        return this.to('GetContactAttributes');
    }
    /**
     * Grants permission to retrieve current metric data for the queues in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_GetCurrentMetricData.html
     */
    toGetCurrentMetricData() {
        return this.to('GetCurrentMetricData');
    }
    /**
     * Grants permission to retrieve current user data in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_GetCurrentUserData.html
     */
    toGetCurrentUserData() {
        return this.to('GetCurrentUserData');
    }
    /**
     * Grants permission to federate into an Amazon Connect instance when using SAML-based authentication for identity management
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_GetFederationToken.html
     */
    toGetFederationToken() {
        return this.to('GetFederationToken');
    }
    /**
     * Grants permission to federate into an Amazon Connect instance (Log in for emergency access functionality in the Amazon Connect console)
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - connect:DescribeInstance
     * - connect:ListInstances
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/emergency-admin-login.html
     */
    toGetFederationTokens() {
        return this.to('GetFederationTokens');
    }
    /**
     * Grants permission to retrieve historical metric data for queues in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricData.html
     */
    toGetMetricData() {
        return this.to('GetMetricData');
    }
    /**
     * Grants permission to get details about specified task template in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_GetTaskTemplate.html
     */
    toGetTaskTemplate() {
        return this.to('GetTaskTemplate');
    }
    /**
     * Grants permission to list agent statuses in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListAgentStatuses.html
     */
    toListAgentStatuses() {
        return this.to('ListAgentStatuses');
    }
    /**
     * Grants permission to view approved origins of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListApprovedOrigins() {
        return this.to('ListApprovedOrigins');
    }
    /**
     * Grants permission to view the Lex bots of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListBots() {
        return this.to('ListBots');
    }
    /**
     * Grants permission to list contact flow module resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListContactFlowModules.html
     */
    toListContactFlowModules() {
        return this.to('ListContactFlowModules');
    }
    /**
     * Grants permission to list contact flow resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListContactFlows.html
     */
    toListContactFlows() {
        return this.to('ListContactFlows');
    }
    /**
     * Grants permission to list references associated with a contact in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListContactReferences.html
     */
    toListContactReferences() {
        return this.to('ListContactReferences');
    }
    /**
     * Grants permission to list default vocabularies associated with a Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListDefaultVocabularies.html
     */
    toListDefaultVocabularies() {
        return this.to('ListDefaultVocabularies');
    }
    /**
     * Grants permission to list hours of operation resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListHoursOfOperations.html
     */
    toListHoursOfOperations() {
        return this.to('ListHoursOfOperations');
    }
    /**
     * Grants permission to view the attributes of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListInstanceAttributes() {
        return this.to('ListInstanceAttributes');
    }
    /**
     * Grants permission to view storage configurations of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListInstanceStorageConfigs() {
        return this.to('ListInstanceStorageConfigs');
    }
    /**
     * Grants permission to view the Amazon Connect instances associated with an AWS account
     *
     * Access Level: List
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListInstances() {
        return this.to('ListInstances');
    }
    /**
     * Grants permission to list summary information about the integration associations for the specified Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - connect:DescribeInstance
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListIntegrationAssociations.html
     */
    toListIntegrationAssociations() {
        return this.to('ListIntegrationAssociations');
    }
    /**
     * Grants permission to view the Lambda functions of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListLambdaFunctions() {
        return this.to('ListLambdaFunctions');
    }
    /**
     * Grants permission to view the Lex bots of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListLexBots() {
        return this.to('ListLexBots');
    }
    /**
     * Grants permission to list phone number resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbers.html
     */
    toListPhoneNumbers() {
        return this.to('ListPhoneNumbers');
    }
    /**
     * Grants permission to list phone number resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html
     */
    toListPhoneNumbersV2() {
        return this.to('ListPhoneNumbersV2');
    }
    /**
     * Grants permission to list prompt resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPrompts.html
     */
    toListPrompts() {
        return this.to('ListPrompts');
    }
    /**
     * Grants permission to list quick connect resources in a queue in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListQueueQuickConnects.html
     */
    toListQueueQuickConnects() {
        return this.to('ListQueueQuickConnects');
    }
    /**
     * Grants permission to list queue resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListQueues.html
     */
    toListQueues() {
        return this.to('ListQueues');
    }
    /**
     * Grants permission to list quick connect resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListQuickConnects.html
     */
    toListQuickConnects() {
        return this.to('ListQuickConnects');
    }
    /**
     * Grants permission to list the analysis segments for a real-time analysis session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/contact-lens/latest/APIReference/API_ListRealtimeContactAnalysisSegments.html
     */
    toListRealtimeContactAnalysisSegments() {
        return this.to('ListRealtimeContactAnalysisSegments');
    }
    /**
     * Grants permission to list queue resources in a routing profile in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListRoutingProfileQueues.html
     */
    toListRoutingProfileQueues() {
        return this.to('ListRoutingProfileQueues');
    }
    /**
     * Grants permission to list routing profile resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListRoutingProfiles.html
     */
    toListRoutingProfiles() {
        return this.to('ListRoutingProfiles');
    }
    /**
     * Grants permission to view the security keys of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListSecurityKeys() {
        return this.to('ListSecurityKeys');
    }
    /**
     * Grants permission to list permissions associated with security profile in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListSecurityProfilePermissions.html
     */
    toListSecurityProfilePermissions() {
        return this.to('ListSecurityProfilePermissions');
    }
    /**
     * Grants permission to list security profile resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListSecurityProfiles.html
     */
    toListSecurityProfiles() {
        return this.to('ListSecurityProfiles');
    }
    /**
     * Grants permission to list tags for an Amazon Connect resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list task template resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListTaskTemplates.html
     */
    toListTaskTemplates() {
        return this.to('ListTaskTemplates');
    }
    /**
     * Grants permission to list the use cases of an integration association
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - connect:DescribeInstance
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListUseCases.html
     */
    toListUseCases() {
        return this.to('ListUseCases');
    }
    /**
     * Grants permission to list the hierarchy group resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListUserHierarchyGroups.html
     */
    toListUserHierarchyGroups() {
        return this.to('ListUserHierarchyGroups');
    }
    /**
     * Grants permission to list user resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListUsers.html
     */
    toListUsers() {
        return this.to('ListUsers');
    }
    /**
     * Grants permission to switch User Status in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_PutUserStatus.html
     */
    toPutUserStatus() {
        return this.to('PutUserStatus');
    }
    /**
     * Grants permission to release phone number resources in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ReleasePhoneNumber.html
     */
    toReleasePhoneNumber() {
        return this.to('ReleasePhoneNumber');
    }
    /**
     * Grants permission to resume recording for the specified contact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ResumeContactRecording.html
     */
    toResumeContactRecording() {
        return this.to('ResumeContactRecording');
    }
    /**
     * Grants permission to search phone number resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchAvailablePhoneNumbers.html
     */
    toSearchAvailablePhoneNumbers() {
        return this.to('SearchAvailablePhoneNumbers');
    }
    /**
     * Grants permission to search queue resources in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     * - .ifSearchTag()
     *
     * Dependent actions:
     * - connect:DescribeQueue
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchQueues.html
     */
    toSearchQueues() {
        return this.to('SearchQueues');
    }
    /**
     * Grants permission to search routing profile resources in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     * - .ifSearchTag()
     *
     * Dependent actions:
     * - connect:DescribeRoutingProfile
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchRoutingProfiles.html
     */
    toSearchRoutingProfiles() {
        return this.to('SearchRoutingProfiles');
    }
    /**
     * Grants permission to search security profile resources in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     * - .ifSearchTag()
     *
     * Dependent actions:
     * - connect:DescribeSecurityProfile
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchSecurityProfiles.html
     */
    toSearchSecurityProfiles() {
        return this.to('SearchSecurityProfiles');
    }
    /**
     * Grants permission to search user resources in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     * - .ifSearchTag()
     *
     * Dependent actions:
     * - connect:DescribeUser
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchUsers.html
     */
    toSearchUsers() {
        return this.to('SearchUsers');
    }
    /**
     * Grants permission to search vocabularies in a Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchVocabularies.html
     */
    toSearchVocabularies() {
        return this.to('SearchVocabularies');
    }
    /**
     * Grants permission to initiate a chat using the Amazon Connect API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StartChatContact.html
     */
    toStartChatContact() {
        return this.to('StartChatContact');
    }
    /**
     * Grants permission to start recording for the specified contact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactRecording.html
     */
    toStartContactRecording() {
        return this.to('StartContactRecording');
    }
    /**
     * Grants permission to start chat streaming using the Amazon Connect API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactStreaming.html
     */
    toStartContactStreaming() {
        return this.to('StartContactStreaming');
    }
    /**
     * Grants permission to initiate outbound calls using the Amazon Connect API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StartOutboundVoiceContact.html
     */
    toStartOutboundVoiceContact() {
        return this.to('StartOutboundVoiceContact');
    }
    /**
     * Grants permission to initiate a task using the Amazon Connect API
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StartTaskContact.html
     */
    toStartTaskContact() {
        return this.to('StartTaskContact');
    }
    /**
     * Grants permission to stop contacts that were initiated using the Amazon Connect API. If you use this operation on an active contact the contact ends, even if the agent is active on a call with a customer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StopContact.html
     */
    toStopContact() {
        return this.to('StopContact');
    }
    /**
     * Grants permission to stop recording for the specified contact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StopContactRecording.html
     */
    toStopContactRecording() {
        return this.to('StopContactRecording');
    }
    /**
     * Grants permission to stop chat streaming using the Amazon Connect API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StopContactStreaming.html
     */
    toStopContactStreaming() {
        return this.to('StopContactStreaming');
    }
    /**
     * Grants permission to suspend recording for the specified contact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_SuspendContactRecording.html
     */
    toSuspendContactRecording() {
        return this.to('SuspendContactRecording');
    }
    /**
     * Grants permission to tag an Amazon Connect resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to transfer the contact to another queue or agent
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_TransferContact.html
     */
    toTransferContact() {
        return this.to('TransferContact');
    }
    /**
     * Grants permission to untag an Amazon Connect resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update agent status in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateAgentStatus.html
     */
    toUpdateAgentStatus() {
        return this.to('UpdateAgentStatus');
    }
    /**
     * Grants permission to update a contact in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContact.html
     */
    toUpdateContact() {
        return this.to('UpdateContact');
    }
    /**
     * Grants permission to create or update the contact attributes associated with the specified contact
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContactAttributes.html
     */
    toUpdateContactAttributes() {
        return this.to('UpdateContactAttributes');
    }
    /**
     * Grants permission to update contact flow content in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContactFlowContent.html
     */
    toUpdateContactFlowContent() {
        return this.to('UpdateContactFlowContent');
    }
    /**
     * Grants permission to update the metadata of a contact flow in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContactFlowMetadata.html
     */
    toUpdateContactFlowMetadata() {
        return this.to('UpdateContactFlowMetadata');
    }
    /**
     * Grants permission to update contact flow module content in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContactFlowModuleContent.html
     */
    toUpdateContactFlowModuleContent() {
        return this.to('UpdateContactFlowModuleContent');
    }
    /**
     * Grants permission to update the metadata of a contact flow module in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContactFlowModuleMetadata.html
     */
    toUpdateContactFlowModuleMetadata() {
        return this.to('UpdateContactFlowModuleMetadata');
    }
    /**
     * Grants permission to update the name and description of a contact flow in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContactFlowName.html
     */
    toUpdateContactFlowName() {
        return this.to('UpdateContactFlowName');
    }
    /**
     * Grants permission to update the schedule of a contact that is already scheduled in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContactSchedule.html
     */
    toUpdateContactSchedule() {
        return this.to('UpdateContactSchedule');
    }
    /**
     * Grants permission to update hours of operation in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateHoursOfOperation.html
     */
    toUpdateHoursOfOperation() {
        return this.to('UpdateHoursOfOperation');
    }
    /**
     * Grants permission to update the attribute for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAttributeType()
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - logs:CreateLogGroup
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toUpdateInstanceAttribute() {
        return this.to('UpdateInstanceAttribute');
    }
    /**
     * Grants permission to update the storage configuration for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifStorageResourceType()
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     * - firehose:DescribeDeliveryStream
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - kinesis:DescribeStream
     * - kms:CreateGrant
     * - kms:DescribeKey
     * - s3:GetBucketAcl
     * - s3:GetBucketLocation
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toUpdateInstanceStorageConfig() {
        return this.to('UpdateInstanceStorageConfig');
    }
    /**
     * Grants permission to update phone number resources in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html
     */
    toUpdatePhoneNumber() {
        return this.to('UpdatePhoneNumber');
    }
    /**
     * Grants permission to update queue hours of operation in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQueueHoursOfOperation.html
     */
    toUpdateQueueHoursOfOperation() {
        return this.to('UpdateQueueHoursOfOperation');
    }
    /**
     * Grants permission to update queue capacity in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQueueMaxContacts.html
     */
    toUpdateQueueMaxContacts() {
        return this.to('UpdateQueueMaxContacts');
    }
    /**
     * Grants permission to update a queue name and description in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQueueName.html
     */
    toUpdateQueueName() {
        return this.to('UpdateQueueName');
    }
    /**
     * Grants permission to update queue outbound caller config in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQueueOutboundCallerConfig.html
     */
    toUpdateQueueOutboundCallerConfig() {
        return this.to('UpdateQueueOutboundCallerConfig');
    }
    /**
     * Grants permission to update queue status in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQueueStatus.html
     */
    toUpdateQueueStatus() {
        return this.to('UpdateQueueStatus');
    }
    /**
     * Grants permission to update the configuration of a quick connect in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQuickConnectConfig.html
     */
    toUpdateQuickConnectConfig() {
        return this.to('UpdateQuickConnectConfig');
    }
    /**
     * Grants permission to update a quick connect name and description in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQuickConnectName.html
     */
    toUpdateQuickConnectName() {
        return this.to('UpdateQuickConnectName');
    }
    /**
     * Grants permission to update the concurrency in a routing profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateRoutingProfileConcurrency.html
     */
    toUpdateRoutingProfileConcurrency() {
        return this.to('UpdateRoutingProfileConcurrency');
    }
    /**
     * Grants permission to update the outbound queue in a routing profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateRoutingProfileDefaultOutboundQueue.html
     */
    toUpdateRoutingProfileDefaultOutboundQueue() {
        return this.to('UpdateRoutingProfileDefaultOutboundQueue');
    }
    /**
     * Grants permission to update a routing profile name and description in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateRoutingProfileName.html
     */
    toUpdateRoutingProfileName() {
        return this.to('UpdateRoutingProfileName');
    }
    /**
     * Grants permission to update the queues in routing profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateRoutingProfileQueues.html
     */
    toUpdateRoutingProfileQueues() {
        return this.to('UpdateRoutingProfileQueues');
    }
    /**
     * Grants permission to update a security profile group for a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateSecurityProfile.html
     */
    toUpdateSecurityProfile() {
        return this.to('UpdateSecurityProfile');
    }
    /**
     * Grants permission to update task template belonging to a Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateTaskTemplate.html
     */
    toUpdateTaskTemplate() {
        return this.to('UpdateTaskTemplate');
    }
    /**
     * Grants permission to update a hierarchy group for a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserHierarchy.html
     */
    toUpdateUserHierarchy() {
        return this.to('UpdateUserHierarchy');
    }
    /**
     * Grants permission to update a user hierarchy group name in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserHierarchyGroupName.html
     */
    toUpdateUserHierarchyGroupName() {
        return this.to('UpdateUserHierarchyGroupName');
    }
    /**
     * Grants permission to update user hierarchy structure in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserHierarchyStructure.html
     */
    toUpdateUserHierarchyStructure() {
        return this.to('UpdateUserHierarchyStructure');
    }
    /**
     * Grants permission to update identity information for a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserIdentityInfo.html
     */
    toUpdateUserIdentityInfo() {
        return this.to('UpdateUserIdentityInfo');
    }
    /**
     * Grants permission to update phone configuration settings for a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserPhoneConfig.html
     */
    toUpdateUserPhoneConfig() {
        return this.to('UpdateUserPhoneConfig');
    }
    /**
     * Grants permission to update a routing profile for a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserRoutingProfile.html
     */
    toUpdateUserRoutingProfile() {
        return this.to('UpdateUserRoutingProfile');
    }
    /**
     * Grants permission to update security profiles for a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserSecurityProfiles.html
     */
    toUpdateUserSecurityProfiles() {
        return this.to('UpdateUserSecurityProfiles');
    }
    /**
     * Grants permission to update contact flow module content in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatedescribeContent.html
     */
    toUpdatedescribeContent() {
        return this.to('UpdatedescribeContent');
    }
    /**
     * Adds a resource of type instance to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-instances.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onInstance(instanceId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}`);
    }
    /**
     * Adds a resource of type contact to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/connect-contact-attributes.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param contactId - Identifier for the contactId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onContact(instanceId, contactId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/contact/${contactId}`);
    }
    /**
     * Adds a resource of type user to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/connect-agents.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param userId - Identifier for the userId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onUser(instanceId, userId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/agent/${userId}`);
    }
    /**
     * Adds a resource of type routing-profile to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/routing-profiles.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param routingProfileId - Identifier for the routingProfileId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRoutingProfile(instanceId, routingProfileId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/routing-profile/${routingProfileId}`);
    }
    /**
     * Adds a resource of type security-profile to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param securityProfileId - Identifier for the securityProfileId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSecurityProfile(instanceId, securityProfileId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/security-profile/${securityProfileId}`);
    }
    /**
     * Adds a resource of type hierarchy-group to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param hierarchyGroupId - Identifier for the hierarchyGroupId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onHierarchyGroup(instanceId, hierarchyGroupId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/agent-group/${hierarchyGroupId}`);
    }
    /**
     * Adds a resource of type queue to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/create-queue.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param queueId - Identifier for the queueId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onQueue(instanceId, queueId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/queue/${queueId}`);
    }
    /**
     * Adds a resource of type wildcard-queue to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/create-queue.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onWildcardQueue(instanceId, resourceName, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/queue/${resourceName}`);
    }
    /**
     * Adds a resource of type quick-connect to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/quick-connects.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param quickConnectId - Identifier for the quickConnectId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onQuickConnect(instanceId, quickConnectId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/transfer-destination/${quickConnectId}`);
    }
    /**
     * Adds a resource of type wildcard-quick-connect to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/quick-connects.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onWildcardQuickConnect(instanceId, resourceName, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/transfer-destination/${resourceName}`);
    }
    /**
     * Adds a resource of type contact-flow to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/connect-contact-flows.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param contactFlowId - Identifier for the contactFlowId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onContactFlow(instanceId, contactFlowId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/contact-flow/${contactFlowId}`);
    }
    /**
     * Adds a resource of type task-template to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/task-templates.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param taskTemplateId - Identifier for the taskTemplateId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTaskTemplate(instanceId, taskTemplateId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/task-template/${taskTemplateId}`);
    }
    /**
     * Adds a resource of type contact-flow-module to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/contact-flow-modules.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param contactFlowModuleId - Identifier for the contactFlowModuleId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onContactFlowModule(instanceId, contactFlowModuleId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/flow-module/${contactFlowModuleId}`);
    }
    /**
     * Adds a resource of type wildcard-contact-flow to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/connect-contact-flows.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onWildcardContactFlow(instanceId, resourceName, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/contact-flow/${resourceName}`);
    }
    /**
     * Adds a resource of type hours-of-operation to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/set-hours-operation.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param hoursOfOperationId - Identifier for the hoursOfOperationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onHoursOfOperation(instanceId, hoursOfOperationId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/operating-hours/${hoursOfOperationId}`);
    }
    /**
     * Adds a resource of type agent-status to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/metrics-agent-status.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param agentStatusId - Identifier for the agentStatusId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAgentStatus(instanceId, agentStatusId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/agent-state/${agentStatusId}`);
    }
    /**
     * Adds a resource of type wildcard-agent-status to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/metrics-agent-status.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onWildcardAgentStatus(instanceId, resourceName, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/agent-state/${resourceName}`);
    }
    /**
     * Adds a resource of type legacy-phone-number to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param phoneNumberId - Identifier for the phoneNumberId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onLegacyPhoneNumber(instanceId, phoneNumberId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/phone-number/${phoneNumberId}`);
    }
    /**
     * Adds a resource of type wildcard-legacy-phone-number to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onWildcardLegacyPhoneNumber(instanceId, resourceName, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/phone-number/${resourceName}`);
    }
    /**
     * Adds a resource of type phone-number to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html
     *
     * @param phoneNumberId - Identifier for the phoneNumberId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPhoneNumber(phoneNumberId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:phone-number/${phoneNumberId}`);
    }
    /**
     * Adds a resource of type wildcard-phone-number to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html
     *
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWildcardPhoneNumber(resourceName, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:phone-number/${resourceName}`);
    }
    /**
     * Adds a resource of type integration-association to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/API_IntegrationAssociationSummary.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param integrationAssociationId - Identifier for the integrationAssociationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onIntegrationAssociation(instanceId, integrationAssociationId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/integration-association/${integrationAssociationId}`);
    }
    /**
     * Adds a resource of type use-case to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/API_UseCase.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param useCaseId - Identifier for the useCaseId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onUseCase(instanceId, useCaseId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/use-case/${useCaseId}`);
    }
    /**
     * Adds a resource of type vocabulary to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/API_Vocabulary.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param vocabularyId - Identifier for the vocabularyId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVocabulary(instanceId, vocabularyId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/vocabulary/${vocabularyId}`);
    }
    /**
     * Filters access by the attribute type of the Amazon Connect instance
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toDescribeInstanceAttribute()
     * - .toUpdateInstanceAttribute()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAttributeType(value, operator) {
        return this.if(`AttributeType`, value, operator || 'StringLike');
    }
    /**
     * Filters access by restricting federation into specified Amazon Connect instances
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toAssociateApprovedOrigin()
     * - .toAssociateBot()
     * - .toAssociateDefaultVocabulary()
     * - .toAssociateInstanceStorageConfig()
     * - .toAssociateLambdaFunction()
     * - .toAssociateLexBot()
     * - .toAssociatePhoneNumberContactFlow()
     * - .toAssociateQueueQuickConnects()
     * - .toAssociateRoutingProfileQueues()
     * - .toAssociateSecurityKey()
     * - .toBatchAssociateAnalyticsDataSet()
     * - .toBatchDisassociateAnalyticsDataSet()
     * - .toCreateAgentStatus()
     * - .toCreateContactFlow()
     * - .toCreateContactFlowModule()
     * - .toCreateHoursOfOperation()
     * - .toCreateIntegrationAssociation()
     * - .toCreateQueue()
     * - .toCreateQuickConnect()
     * - .toCreateRoutingProfile()
     * - .toCreateSecurityProfile()
     * - .toCreateUseCase()
     * - .toCreateUser()
     * - .toCreateUserHierarchyGroup()
     * - .toCreateVocabulary()
     * - .toDeleteContactFlow()
     * - .toDeleteContactFlowModule()
     * - .toDeleteHoursOfOperation()
     * - .toDeleteInstance()
     * - .toDeleteIntegrationAssociation()
     * - .toDeleteQuickConnect()
     * - .toDeleteSecurityProfile()
     * - .toDeleteTaskTemplate()
     * - .toDeleteUseCase()
     * - .toDeleteUser()
     * - .toDeleteUserHierarchyGroup()
     * - .toDeleteVocabulary()
     * - .toDescribeAgentStatus()
     * - .toDescribeContact()
     * - .toDescribeContactFlow()
     * - .toDescribeContactFlowModule()
     * - .toDescribeHoursOfOperation()
     * - .toDescribeInstance()
     * - .toDescribeInstanceAttribute()
     * - .toDescribeInstanceStorageConfig()
     * - .toDescribeQueue()
     * - .toDescribeQuickConnect()
     * - .toDescribeRoutingProfile()
     * - .toDescribeSecurityProfile()
     * - .toDescribeUser()
     * - .toDescribeUserHierarchyGroup()
     * - .toDescribeUserHierarchyStructure()
     * - .toDescribeVocabulary()
     * - .toDisassociateApprovedOrigin()
     * - .toDisassociateBot()
     * - .toDisassociateInstanceStorageConfig()
     * - .toDisassociateLambdaFunction()
     * - .toDisassociateLexBot()
     * - .toDisassociatePhoneNumberContactFlow()
     * - .toDisassociateQueueQuickConnects()
     * - .toDisassociateRoutingProfileQueues()
     * - .toDisassociateSecurityKey()
     * - .toGetContactAttributes()
     * - .toGetCurrentMetricData()
     * - .toGetCurrentUserData()
     * - .toGetFederationToken()
     * - .toGetMetricData()
     * - .toGetTaskTemplate()
     * - .toListApprovedOrigins()
     * - .toListBots()
     * - .toListContactReferences()
     * - .toListDefaultVocabularies()
     * - .toListHoursOfOperations()
     * - .toListInstanceAttributes()
     * - .toListInstanceStorageConfigs()
     * - .toListIntegrationAssociations()
     * - .toListLambdaFunctions()
     * - .toListLexBots()
     * - .toListPrompts()
     * - .toListQueueQuickConnects()
     * - .toListRoutingProfileQueues()
     * - .toListRoutingProfiles()
     * - .toListSecurityKeys()
     * - .toListSecurityProfilePermissions()
     * - .toListSecurityProfiles()
     * - .toListUseCases()
     * - .toListUserHierarchyGroups()
     * - .toListUsers()
     * - .toPutUserStatus()
     * - .toSearchQueues()
     * - .toSearchRoutingProfiles()
     * - .toSearchSecurityProfiles()
     * - .toSearchUsers()
     * - .toSearchVocabularies()
     * - .toStartTaskContact()
     * - .toStopContact()
     * - .toTransferContact()
     * - .toUpdateAgentStatus()
     * - .toUpdateContact()
     * - .toUpdateContactAttributes()
     * - .toUpdateContactFlowContent()
     * - .toUpdateContactFlowMetadata()
     * - .toUpdateContactFlowModuleContent()
     * - .toUpdateContactFlowModuleMetadata()
     * - .toUpdateContactFlowName()
     * - .toUpdateContactSchedule()
     * - .toUpdateHoursOfOperation()
     * - .toUpdateInstanceAttribute()
     * - .toUpdateInstanceStorageConfig()
     * - .toUpdateQueueHoursOfOperation()
     * - .toUpdateQueueMaxContacts()
     * - .toUpdateQueueName()
     * - .toUpdateQueueOutboundCallerConfig()
     * - .toUpdateQueueStatus()
     * - .toUpdateQuickConnectConfig()
     * - .toUpdateQuickConnectName()
     * - .toUpdateRoutingProfileConcurrency()
     * - .toUpdateRoutingProfileDefaultOutboundQueue()
     * - .toUpdateRoutingProfileName()
     * - .toUpdateRoutingProfileQueues()
     * - .toUpdateSecurityProfile()
     * - .toUpdateTaskTemplate()
     * - .toUpdateUserHierarchy()
     * - .toUpdateUserHierarchyGroupName()
     * - .toUpdateUserHierarchyStructure()
     * - .toUpdateUserIdentityInfo()
     * - .toUpdateUserPhoneConfig()
     * - .toUpdateUserRoutingProfile()
     * - .toUpdateUserSecurityProfiles()
     * - .toUpdatedescribeContent()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifInstanceId(value, operator) {
        return this.if(`InstanceId`, value, operator || 'StringLike');
    }
    /**
     * Filters access by TagFilter condition passed in the search request
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toSearchQueues()
     * - .toSearchRoutingProfiles()
     * - .toSearchSecurityProfiles()
     * - .toSearchUsers()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSearchTag(tagKey, value, operator) {
        return this.if(`SearchTag/${tagKey}`, value, operator || 'StringLike');
    }
    /**
     * Filters access by restricting the storage resource type of the Amazon Connect instance storage configuration
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toAssociateInstanceStorageConfig()
     * - .toDescribeInstanceStorageConfig()
     * - .toDisassociateInstanceStorageConfig()
     * - .toUpdateInstanceStorageConfig()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifStorageResourceType(value, operator) {
        return this.if(`StorageResourceType`, value, operator || 'StringLike');
    }
}
exports.Connect = Connect;
_a = JSII_RTTI_SYMBOL_1;
Connect[_a] = { fqn: "iam-floyd.Connect", version: "0.427.0" };
//# sourceMappingURL=data:application/json;base64,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