"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElementalSupportCases = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [elemental-support-cases](https://docs.aws.amazon.com/service-authorization/latest/reference/list_elementalsupportcases.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class ElementalSupportCases extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [elemental-support-cases](https://docs.aws.amazon.com/service-authorization/latest/reference/list_elementalsupportcases.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'elemental-support-cases';
        this.accessLevelList = {
            Write: [
                'CheckCasePermission',
                'CreateCase',
                'UpdateCase'
            ],
            Read: [
                'GetCase',
                'GetCases'
            ]
        };
    }
    /**
     * Verify whether the caller has the permissions to perform support case operations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elemental-appliances-software
     */
    toCheckCasePermission() {
        return this.to('CheckCasePermission');
    }
    /**
     * Grant the permission to create a support case
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elemental-appliances-software
     */
    toCreateCase() {
        return this.to('CreateCase');
    }
    /**
     * Grant the permission to describe a support case in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software
     */
    toGetCase() {
        return this.to('GetCase');
    }
    /**
     * Grant the permission to list the support cases in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software
     */
    toGetCases() {
        return this.to('GetCases');
    }
    /**
     * Grant the permission to update a support case
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elemental-appliances-software
     */
    toUpdateCase() {
        return this.to('UpdateCase');
    }
}
exports.ElementalSupportCases = ElementalSupportCases;
_a = JSII_RTTI_SYMBOL_1;
ElementalSupportCases[_a] = { fqn: "iam-floyd.ElementalSupportCases", version: "0.427.0" };
//# sourceMappingURL=data:application/json;base64,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