"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicroService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const autoScalingGroup_1 = require("./autoScalingGroup");
const deployment_1 = require("./deployment");
const network_1 = require("./network");
/**
 * @stability stable
 */
class MicroService extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r;
        super(scope, id);
        this.instanceType = (_b = props === null || props === void 0 ? void 0 : props.instanceType) !== null && _b !== void 0 ? _b : 't3a.micro';
        this.appName = props.appName;
        this.asgMaxSize = (_c = props === null || props === void 0 ? void 0 : props.asgMaxSize) !== null && _c !== void 0 ? _c : '2';
        this.asgMinSize = (_d = props === null || props === void 0 ? void 0 : props.asgMinSize) !== null && _d !== void 0 ? _d : '1';
        this.env = (_e = props === null || props === void 0 ? void 0 : props.env) !== null && _e !== void 0 ? _e : 'development';
        this.instanceLabels = props === null || props === void 0 ? void 0 : props.instanceLabels;
        this.healthCheckPath = (_f = props === null || props === void 0 ? void 0 : props.healthCheckPath) !== null && _f !== void 0 ? _f : '/v1/healthCheck';
        this.port = (_g = props.port) !== null && _g !== void 0 ? _g : undefined;
        this.protocol = (_h = props.protocol) !== null && _h !== void 0 ? _h : 'HTTP';
        this.diskSize = (_j = props.diskSize) !== null && _j !== void 0 ? _j : 8;
        this.vpc = props.vpc;
        this.role = props.role;
        this.tcpRules = (_k = props.tcpRules) !== null && _k !== void 0 ? _k : [];
        this.subnets = props.subnets;
        this.sslEnabled = props.sslEnabled;
        this.host = props.host;
        this.lbArn = props.lbArn;
        this.sshKey = props.sshKey;
        this.diskType = props.diskType;
        this.createCodedeployApplication = (_l = props.createCodedeployApplication) !== null && _l !== void 0 ? _l : false;
        this.deploymentPolicies = (_m = props.deploymentPolicies) !== null && _m !== void 0 ? _m : [];
        this.applicationType = (_o = props.applicationType) !== null && _o !== void 0 ? _o : 'new';
        const resourceNamePrefix = this.env + '-' + this.appName;
        const asg = new autoScalingGroup_1.AutoScaler(this, resourceNamePrefix + '-as', {
            asgName: resourceNamePrefix + '-ASG',
            maxSize: this.asgMaxSize,
            minSize: this.asgMinSize,
            tgProps: this.port ? {
                type: 'new',
                healthPath: this.healthCheckPath,
                protocol: this.protocol,
                port: this.port,
                name: ((resourceNamePrefix + '-TG').length >= 32) ? this.env + '-' + this.appName + '-TG' : resourceNamePrefix + '-TG',
                timeout: 10,
                thresholdCount: 2,
            } : undefined,
            templateProps: {
                instanceType: this.instanceType,
                detailedMonitoring: false,
                templateName: resourceNamePrefix + '-LT',
                amiImageId: (_p = props.ami) !== null && _p !== void 0 ? _p : 'Ubuntu Server 20.04 LTS (HVM), SSD Volume Type',
                type: 'new',
                blockDevice: {
                    size: this.diskSize,
                    name: '/dev/sda1',
                    type: this.getDiskType((_q = this.diskType) !== null && _q !== void 0 ? _q : 'GP3'),
                },
                vpc: {
                    type: 'existing',
                    vpcName: this.vpc,
                },
                securityGroup: {
                    type: 'new',
                    allowAllOutbound: true,
                    securityGroupName: resourceNamePrefix + '-SG',
                    ingressRules: this.tcpRules,
                },
                role: this.role,
                sshKey: this.sshKey,
            },
            tags: props.instanceLabels,
            subnets: this.subnets,
        });
        if (this.createCodedeployApplication) {
            const depRole = this.getDeploymentGroupRole();
            const dep = new deployment_1.Deployment(this, resourceNamePrefix + '-cd', {
                asgNames: [resourceNamePrefix + '-ASG'],
                deploymentConfigName: 'CodeDeployDefault.OneAtATime',
                roleArn: depRole.roleArn,
                applicationProps: {
                    applicationName: this.appName + '-' + this.env,
                    type: this.applicationType,
                    resourceType: 'Server',
                },
                deploymentGroupName: this.env,
                tgName: resourceNamePrefix + '-TG',
            });
            dep.node.addDependency(depRole);
        }
        if (this.host && this.lbArn && asg.targetGroupArn != '') {
            const lbEntry = new network_1.BalancerEntry(this, resourceNamePrefix + '-lb', {
                appName: this.appName,
                hostHeader: this.host,
                targetGroupArn: asg.targetGroupArn,
                lbArn: this.lbArn,
                sslEnabled: (_r = this.sslEnabled) !== null && _r !== void 0 ? _r : false,
            });
            lbEntry.node.addDependency(asg);
        }
    }
    getDeploymentGroupRole() {
        var _b;
        var role = new aws_iam_1.Role(this, this.appName + '-deployment-group-role', {
            assumedBy: new aws_iam_1.ServicePrincipal('codedeploy.amazonaws.com'),
            roleName: this.appName + '-deployment-group-role',
        });
        role.addToPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            resources: ['*'],
            actions: [
                'autoscaling:CompleteLifecycleAction',
                'autoscaling:DeleteLifecycleHook',
                'autoscaling:DescribeAutoScalingGroups',
                'autoscaling:DescribeLifecycleHooks',
                'autoscaling:PutLifecycleHook',
                'autoscaling:RecordLifecycleActionHeartbeat',
                'autoscaling:CreateAutoScalingGroup',
                'autoscaling:UpdateAutoScalingGroup',
                'autoscaling:EnableMetricsCollection',
                'autoscaling:DescribePolicies',
                'autoscaling:DescribeScheduledActions',
                'autoscaling:DescribeNotificationConfigurations',
                'autoscaling:SuspendProcesses',
                'autoscaling:ResumeProcesses',
                'autoscaling:AttachLoadBalancers',
                'autoscaling:AttachLoadBalancerTargetGroups',
                'autoscaling:PutScalingPolicy',
                'autoscaling:PutScheduledUpdateGroupAction',
                'autoscaling:PutNotificationConfiguration',
                'autoscaling:PutWarmPool',
                'autoscaling:DescribeScalingActivities',
                'autoscaling:DeleteAutoScalingGroup',
                'ec2:DescribeInstances',
                'ec2:DescribeInstanceStatus',
                'ec2:TerminateInstances',
                'tag:GetResources',
                'sns:Publish',
                'cloudwatch:DescribeAlarms',
                'cloudwatch:PutMetricAlarm',
                'elasticloadbalancing:DescribeLoadBalancers',
                'elasticloadbalancing:DescribeInstanceHealth',
                'elasticloadbalancing:RegisterInstancesWithLoadBalancer',
                'elasticloadbalancing:DeregisterInstancesFromLoadBalancer',
                'elasticloadbalancing:DescribeTargetGroups',
                'elasticloadbalancing:DescribeTargetHealth',
                'elasticloadbalancing:RegisterTargets',
                'elasticloadbalancing:DeregisterTargets',
                'ec2:CreateTags',
                'ec2:RunInstances',
                'iam:PassRole',
                ...(_b = this.deploymentPolicies) !== null && _b !== void 0 ? _b : [],
            ],
        }));
        return role;
    }
    getDiskType(type) {
        return type;
    }
}
exports.MicroService = MicroService;
_a = JSII_RTTI_SYMBOL_1;
MicroService[_a] = { fqn: "@smallcase/aws-cdk-microservice.MicroService", version: "0.0.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWljcm9zZXJ2aWNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2NvbnN0cnVjdHMvbWljcm9zZXJ2aWNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBRUEsOENBQW1GO0FBQ25GLHdDQUEwQztBQUMxQyx5REFBMkU7QUFDM0UsNkNBQTBDO0FBQzFDLHVDQUEwQzs7OztBQTRCMUMsTUFBYSxZQUFhLFNBQVEsZ0JBQVM7Ozs7SUF5QnpDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBd0I7O1FBQ2hFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxDQUFDLFlBQVksU0FBRyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsWUFBWSxtQ0FBSSxXQUFXLENBQUM7UUFDdkQsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQzdCLElBQUksQ0FBQyxVQUFVLFNBQUcsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLFVBQVUsbUNBQUksR0FBRyxDQUFDO1FBQzNDLElBQUksQ0FBQyxVQUFVLFNBQUcsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLFVBQVUsbUNBQUksR0FBRyxDQUFDO1FBQzNDLElBQUksQ0FBQyxHQUFHLFNBQUcsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLEdBQUcsbUNBQUksYUFBYSxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLGNBQWMsQ0FBQztRQUM1QyxJQUFJLENBQUMsZUFBZSxTQUFHLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxlQUFlLG1DQUFJLGlCQUFpQixDQUFDO1FBQ25FLElBQUksQ0FBQyxJQUFJLFNBQUcsS0FBSyxDQUFDLElBQUksbUNBQUksU0FBUyxDQUFDO1FBQ3BDLElBQUksQ0FBQyxRQUFRLFNBQUcsS0FBSyxDQUFDLFFBQVEsbUNBQUksTUFBTSxDQUFDO1FBQ3pDLElBQUksQ0FBQyxRQUFRLFNBQUcsS0FBSyxDQUFDLFFBQVEsbUNBQUksQ0FBQyxDQUFDO1FBQ3BDLElBQUksQ0FBQyxHQUFHLEdBQUcsS0FBSyxDQUFDLEdBQUcsQ0FBQztRQUNyQixJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7UUFDdkIsSUFBSSxDQUFDLFFBQVEsU0FBRyxLQUFLLENBQUMsUUFBUSxtQ0FBSSxFQUFFLENBQUM7UUFDckMsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQzdCLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztRQUNuQyxJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7UUFDdkIsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDO1FBQ3pCLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztRQUMzQixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7UUFDL0IsSUFBSSxDQUFDLDJCQUEyQixTQUFHLEtBQUssQ0FBQywyQkFBMkIsbUNBQUksS0FBSyxDQUFDO1FBQzlFLElBQUksQ0FBQyxrQkFBa0IsU0FBRyxLQUFLLENBQUMsa0JBQWtCLG1DQUFJLEVBQUUsQ0FBQztRQUN6RCxJQUFJLENBQUMsZUFBZSxTQUFHLEtBQUssQ0FBQyxlQUFlLG1DQUFJLEtBQUssQ0FBQztRQUV0RCxNQUFNLGtCQUFrQixHQUFHLElBQUksQ0FBQyxHQUFHLEdBQUcsR0FBRyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUM7UUFDekQsTUFBTSxHQUFHLEdBQUcsSUFBSSw2QkFBVSxDQUFDLElBQUksRUFBRSxrQkFBa0IsR0FBRyxLQUFLLEVBQUU7WUFDM0QsT0FBTyxFQUFFLGtCQUFrQixHQUFHLE1BQU07WUFDcEMsT0FBTyxFQUFFLElBQUksQ0FBQyxVQUFVO1lBQ3hCLE9BQU8sRUFBRSxJQUFJLENBQUMsVUFBVTtZQUN4QixPQUFPLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7Z0JBQ25CLElBQUksRUFBRSxLQUFLO2dCQUNYLFVBQVUsRUFBRSxJQUFJLENBQUMsZUFBZTtnQkFDaEMsUUFBUSxFQUFFLElBQUksQ0FBQyxRQUFRO2dCQUN2QixJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUk7Z0JBQ2YsSUFBSSxFQUFFLENBQUMsQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsQ0FBQyxNQUFNLElBQUksRUFBRSxDQUFDLENBQUEsQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLEdBQUcsR0FBRyxHQUFHLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFBLENBQUMsQ0FBQSxrQkFBa0IsR0FBRyxLQUFLO2dCQUNuSCxPQUFPLEVBQUUsRUFBRTtnQkFDWCxjQUFjLEVBQUUsQ0FBQzthQUNsQixDQUFBLENBQUMsQ0FBQyxTQUFTO1lBQ1osYUFBYSxFQUFFO2dCQUNiLFlBQVksRUFBRSxJQUFJLENBQUMsWUFBWTtnQkFDL0Isa0JBQWtCLEVBQUUsS0FBSztnQkFDekIsWUFBWSxFQUFFLGtCQUFrQixHQUFHLEtBQUs7Z0JBQ3hDLFVBQVUsUUFBRSxLQUFLLENBQUMsR0FBRyxtQ0FBSSxnREFBZ0Q7Z0JBQ3pFLElBQUksRUFBRSxLQUFLO2dCQUNYLFdBQVcsRUFBRTtvQkFDWCxJQUFJLEVBQUUsSUFBSSxDQUFDLFFBQVE7b0JBQ25CLElBQUksRUFBRSxXQUFXO29CQUNqQixJQUFJLEVBQUUsSUFBSSxDQUFDLFdBQVcsT0FBQyxJQUFJLENBQUMsUUFBUSxtQ0FBSSxLQUFLLENBQUM7aUJBQy9DO2dCQUNELEdBQUcsRUFBRTtvQkFDSCxJQUFJLEVBQUUsVUFBVTtvQkFDaEIsT0FBTyxFQUFFLElBQUksQ0FBQyxHQUFHO2lCQUNsQjtnQkFDRCxhQUFhLEVBQUU7b0JBQ2IsSUFBSSxFQUFFLEtBQUs7b0JBQ1gsZ0JBQWdCLEVBQUUsSUFBSTtvQkFDdEIsaUJBQWlCLEVBQUUsa0JBQWtCLEdBQUcsS0FBSztvQkFDN0MsWUFBWSxFQUFFLElBQUksQ0FBQyxRQUFRO2lCQUM1QjtnQkFDRCxJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUk7Z0JBQ2YsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNO2FBQ3BCO1lBQ0QsSUFBSSxFQUFFLEtBQUssQ0FBQyxjQUFjO1lBQzFCLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztTQUN0QixDQUFDLENBQUM7UUFFSCxJQUFJLElBQUksQ0FBQywyQkFBMkIsRUFBRTtZQUNwQyxNQUFNLE9BQU8sR0FBRyxJQUFJLENBQUMsc0JBQXNCLEVBQUUsQ0FBQztZQUM5QyxNQUFNLEdBQUcsR0FBRyxJQUFJLHVCQUFVLENBQUMsSUFBSSxFQUFFLGtCQUFrQixHQUFHLEtBQUssRUFBRTtnQkFDM0QsUUFBUSxFQUFFLENBQUMsa0JBQWtCLEdBQUcsTUFBTSxDQUFDO2dCQUN2QyxvQkFBb0IsRUFBRSw4QkFBOEI7Z0JBQ3BELE9BQU8sRUFBRSxPQUFPLENBQUMsT0FBTztnQkFDeEIsZ0JBQWdCLEVBQUU7b0JBQ2hCLGVBQWUsRUFBRSxJQUFJLENBQUMsT0FBTyxHQUFHLEdBQUcsR0FBRyxJQUFJLENBQUMsR0FBRztvQkFDOUMsSUFBSSxFQUFFLElBQUksQ0FBQyxlQUFlO29CQUMxQixZQUFZLEVBQUUsUUFBUTtpQkFDdkI7Z0JBQ0QsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLEdBQUc7Z0JBQzdCLE1BQU0sRUFBRSxrQkFBa0IsR0FBRyxLQUFLO2FBQ25DLENBQUMsQ0FBQztZQUNILEdBQUcsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1NBQ2pDO1FBRUQsSUFBSSxJQUFJLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxLQUFLLElBQUksR0FBRyxDQUFDLGNBQWMsSUFBSSxFQUFFLEVBQUU7WUFDdkQsTUFBTSxPQUFPLEdBQUcsSUFBSSx1QkFBYSxDQUFDLElBQUksRUFBRSxrQkFBa0IsR0FBRyxLQUFLLEVBQUU7Z0JBQ2xFLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztnQkFDckIsVUFBVSxFQUFFLElBQUksQ0FBQyxJQUFJO2dCQUNyQixjQUFjLEVBQUUsR0FBRyxDQUFDLGNBQWM7Z0JBQ2xDLEtBQUssRUFBRSxJQUFJLENBQUMsS0FBSztnQkFDakIsVUFBVSxRQUFFLElBQUksQ0FBQyxVQUFVLG1DQUFJLEtBQUs7YUFDckMsQ0FBQyxDQUFDO1lBQ0gsT0FBTyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLENBQUM7U0FDakM7SUFDSCxDQUFDO0lBRU8sc0JBQXNCOztRQUM1QixJQUFJLElBQUksR0FBRyxJQUFJLGNBQUksQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLE9BQU8sR0FBRyx3QkFBd0IsRUFBRTtZQUNqRSxTQUFTLEVBQUUsSUFBSSwwQkFBZ0IsQ0FBQywwQkFBMEIsQ0FBQztZQUMzRCxRQUFRLEVBQUUsSUFBSSxDQUFDLE9BQU8sR0FBRyx3QkFBd0I7U0FDbEQsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLFdBQVcsQ0FDZCxJQUFJLHlCQUFlLENBQUM7WUFDbEIsTUFBTSxFQUFFLGdCQUFNLENBQUMsS0FBSztZQUNwQixTQUFTLEVBQUUsQ0FBQyxHQUFHLENBQUM7WUFDaEIsT0FBTyxFQUFFO2dCQUNQLHFDQUFxQztnQkFDckMsaUNBQWlDO2dCQUNqQyx1Q0FBdUM7Z0JBQ3ZDLG9DQUFvQztnQkFDcEMsOEJBQThCO2dCQUM5Qiw0Q0FBNEM7Z0JBQzVDLG9DQUFvQztnQkFDcEMsb0NBQW9DO2dCQUNwQyxxQ0FBcUM7Z0JBQ3JDLDhCQUE4QjtnQkFDOUIsc0NBQXNDO2dCQUN0QyxnREFBZ0Q7Z0JBQ2hELDhCQUE4QjtnQkFDOUIsNkJBQTZCO2dCQUM3QixpQ0FBaUM7Z0JBQ2pDLDRDQUE0QztnQkFDNUMsOEJBQThCO2dCQUM5QiwyQ0FBMkM7Z0JBQzNDLDBDQUEwQztnQkFDMUMseUJBQXlCO2dCQUN6Qix1Q0FBdUM7Z0JBQ3ZDLG9DQUFvQztnQkFDcEMsdUJBQXVCO2dCQUN2Qiw0QkFBNEI7Z0JBQzVCLHdCQUF3QjtnQkFDeEIsa0JBQWtCO2dCQUNsQixhQUFhO2dCQUNiLDJCQUEyQjtnQkFDM0IsMkJBQTJCO2dCQUMzQiw0Q0FBNEM7Z0JBQzVDLDZDQUE2QztnQkFDN0Msd0RBQXdEO2dCQUN4RCwwREFBMEQ7Z0JBQzFELDJDQUEyQztnQkFDM0MsMkNBQTJDO2dCQUMzQyxzQ0FBc0M7Z0JBQ3RDLHdDQUF3QztnQkFDeEMsZ0JBQWdCO2dCQUNoQixrQkFBa0I7Z0JBQ2xCLGNBQWM7Z0JBQ2QsU0FBSSxJQUFJLENBQUMsa0JBQWtCLG1DQUFJLEVBQUU7YUFDbEM7U0FDRixDQUFDLENBQ0gsQ0FBQztRQUNGLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVPLFdBQVcsQ0FBQyxJQUFZO1FBQzlCLE9BQU8sSUFBMkIsQ0FBQztJQUNyQyxDQUFDOztBQXJMSCxvQ0FzTEMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDZm5BdXRvU2NhbGluZ0dyb3VwIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWF1dG9zY2FsaW5nJztcbmltcG9ydCB7IEVic0RldmljZVZvbHVtZVR5cGUgfSBmcm9tICdAYXdzLWNkay9hd3MtZWMyJztcbmltcG9ydCB7IEVmZmVjdCwgUG9saWN5U3RhdGVtZW50LCBSb2xlLCBTZXJ2aWNlUHJpbmNpcGFsIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IEF1dG9TY2FsZXIsIEluZ3Jlc3NSdWxlLCBJbnRlcm5hbFJvbGUgfSBmcm9tICcuL2F1dG9TY2FsaW5nR3JvdXAnO1xuaW1wb3J0IHsgRGVwbG95bWVudCB9IGZyb20gJy4vZGVwbG95bWVudCc7XG5pbXBvcnQgeyBCYWxhbmNlckVudHJ5IH0gZnJvbSAnLi9uZXR3b3JrJztcblxuXG5leHBvcnQgaW50ZXJmYWNlIE1pY3JvU2VydmljZVByb3BzIHtcbiAgcmVhZG9ubHkgZW52OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGluc3RhbmNlVHlwZT86IHN0cmluZztcbiAgcmVhZG9ubHkgYXBwTmFtZTogc3RyaW5nO1xuICByZWFkb25seSBhc2dNYXhTaXplPzogc3RyaW5nO1xuICByZWFkb25seSBhc2dNaW5TaXplPzogc3RyaW5nO1xuICByZWFkb25seSBpbnN0YW5jZUxhYmVscz86IENmbkF1dG9TY2FsaW5nR3JvdXAuVGFnUHJvcGVydHlQcm9wZXJ0eVtdO1xuICByZWFkb25seSBoZWFsdGhDaGVja1BhdGg/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHBvcnQ/OiBudW1iZXI7XG4gIHJlYWRvbmx5IHZwYzogc3RyaW5nO1xuICByZWFkb25seSBzdWJuZXRzOiBzdHJpbmdbXTtcbiAgcmVhZG9ubHkgcHJvdG9jb2w/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGRpc2tTaXplPzogbnVtYmVyO1xuICByZWFkb25seSByb2xlOiBJbnRlcm5hbFJvbGU7XG4gIHJlYWRvbmx5IHRjcFJ1bGVzPzogSW5ncmVzc1J1bGVbXTtcbiAgcmVhZG9ubHkgc3NsRW5hYmxlZD86IGJvb2xlYW47XG4gIHJlYWRvbmx5IGhvc3Q/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGxiQXJuPzogc3RyaW5nO1xuICByZWFkb25seSBhbWk/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHNzaEtleTogc3RyaW5nO1xuICByZWFkb25seSBkaXNrVHlwZT86IHN0cmluZztcbiAgcmVhZG9ubHkgY3JlYXRlQ29kZWRlcGxveUFwcGxpY2F0aW9uPzogYm9vbGVhbjtcbiAgcmVhZG9ubHkgZGVwbG95bWVudFBvbGljaWVzPzogc3RyaW5nW107XG4gIHJlYWRvbmx5IGFwcGxpY2F0aW9uVHlwZT86IHN0cmluZztcbn1cbmV4cG9ydCBjbGFzcyBNaWNyb1NlcnZpY2UgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuXG4gIHB1YmxpYyByZWFkb25seSBpbnN0YW5jZVR5cGU/OiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBhcHBOYW1lOiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBhc2dNYXhTaXplPzogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgYXNnTWluU2l6ZT86IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IGVudj86IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IGluc3RhbmNlTGFiZWxzPzogQ2ZuQXV0b1NjYWxpbmdHcm91cC5UYWdQcm9wZXJ0eVByb3BlcnR5W107XG4gIHB1YmxpYyByZWFkb25seSBoZWFsdGhDaGVja1BhdGg/OiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBwb3J0PzogbnVtYmVyO1xuICBwdWJsaWMgcmVhZG9ubHkgcHJvdG9jb2w/OiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBkaXNrU2l6ZT86IG51bWJlcjtcbiAgcHVibGljIHJlYWRvbmx5IHZwYzogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgcm9sZTogSW50ZXJuYWxSb2xlO1xuICBwdWJsaWMgcmVhZG9ubHkgdGNwUnVsZXM/OiBJbmdyZXNzUnVsZVtdO1xuICBwdWJsaWMgcmVhZG9ubHkgc3VibmV0czogc3RyaW5nW107XG4gIHB1YmxpYyByZWFkb25seSBzc2xFbmFibGVkPzogYm9vbGVhbjtcbiAgcHVibGljIHJlYWRvbmx5IGhvc3Q/OiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBsYkFybj86IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IHNzaEtleTogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgZGlza1R5cGU/OiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBjcmVhdGVDb2RlZGVwbG95QXBwbGljYXRpb24/OiBib29sZWFuO1xuICBwdWJsaWMgcmVhZG9ubHkgZGVwbG95bWVudFBvbGljaWVzPzogc3RyaW5nW107XG4gIHB1YmxpYyByZWFkb25seSBhcHBsaWNhdGlvblR5cGU/OiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IE1pY3JvU2VydmljZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIHRoaXMuaW5zdGFuY2VUeXBlID0gcHJvcHM/Lmluc3RhbmNlVHlwZSA/PyAndDNhLm1pY3JvJztcbiAgICB0aGlzLmFwcE5hbWUgPSBwcm9wcy5hcHBOYW1lO1xuICAgIHRoaXMuYXNnTWF4U2l6ZSA9IHByb3BzPy5hc2dNYXhTaXplID8/ICcyJztcbiAgICB0aGlzLmFzZ01pblNpemUgPSBwcm9wcz8uYXNnTWluU2l6ZSA/PyAnMSc7XG4gICAgdGhpcy5lbnYgPSBwcm9wcz8uZW52ID8/ICdkZXZlbG9wbWVudCc7XG4gICAgdGhpcy5pbnN0YW5jZUxhYmVscyA9IHByb3BzPy5pbnN0YW5jZUxhYmVscztcbiAgICB0aGlzLmhlYWx0aENoZWNrUGF0aCA9IHByb3BzPy5oZWFsdGhDaGVja1BhdGggPz8gJy92MS9oZWFsdGhDaGVjayc7XG4gICAgdGhpcy5wb3J0ID0gcHJvcHMucG9ydCA/PyB1bmRlZmluZWQ7XG4gICAgdGhpcy5wcm90b2NvbCA9IHByb3BzLnByb3RvY29sID8/ICdIVFRQJztcbiAgICB0aGlzLmRpc2tTaXplID0gcHJvcHMuZGlza1NpemUgPz8gODtcbiAgICB0aGlzLnZwYyA9IHByb3BzLnZwYztcbiAgICB0aGlzLnJvbGUgPSBwcm9wcy5yb2xlO1xuICAgIHRoaXMudGNwUnVsZXMgPSBwcm9wcy50Y3BSdWxlcyA/PyBbXTtcbiAgICB0aGlzLnN1Ym5ldHMgPSBwcm9wcy5zdWJuZXRzO1xuICAgIHRoaXMuc3NsRW5hYmxlZCA9IHByb3BzLnNzbEVuYWJsZWQ7XG4gICAgdGhpcy5ob3N0ID0gcHJvcHMuaG9zdDtcbiAgICB0aGlzLmxiQXJuID0gcHJvcHMubGJBcm47XG4gICAgdGhpcy5zc2hLZXkgPSBwcm9wcy5zc2hLZXk7XG4gICAgdGhpcy5kaXNrVHlwZSA9IHByb3BzLmRpc2tUeXBlO1xuICAgIHRoaXMuY3JlYXRlQ29kZWRlcGxveUFwcGxpY2F0aW9uID0gcHJvcHMuY3JlYXRlQ29kZWRlcGxveUFwcGxpY2F0aW9uID8/IGZhbHNlO1xuICAgIHRoaXMuZGVwbG95bWVudFBvbGljaWVzID0gcHJvcHMuZGVwbG95bWVudFBvbGljaWVzID8/IFtdO1xuICAgIHRoaXMuYXBwbGljYXRpb25UeXBlID0gcHJvcHMuYXBwbGljYXRpb25UeXBlID8/ICduZXcnO1xuXG4gICAgY29uc3QgcmVzb3VyY2VOYW1lUHJlZml4ID0gdGhpcy5lbnYgKyAnLScgKyB0aGlzLmFwcE5hbWU7XG4gICAgY29uc3QgYXNnID0gbmV3IEF1dG9TY2FsZXIodGhpcywgcmVzb3VyY2VOYW1lUHJlZml4ICsgJy1hcycsIHtcbiAgICAgIGFzZ05hbWU6IHJlc291cmNlTmFtZVByZWZpeCArICctQVNHJyxcbiAgICAgIG1heFNpemU6IHRoaXMuYXNnTWF4U2l6ZSxcbiAgICAgIG1pblNpemU6IHRoaXMuYXNnTWluU2l6ZSxcbiAgICAgIHRnUHJvcHM6IHRoaXMucG9ydCA/IHtcbiAgICAgICAgdHlwZTogJ25ldycsXG4gICAgICAgIGhlYWx0aFBhdGg6IHRoaXMuaGVhbHRoQ2hlY2tQYXRoLFxuICAgICAgICBwcm90b2NvbDogdGhpcy5wcm90b2NvbCxcbiAgICAgICAgcG9ydDogdGhpcy5wb3J0LFxuICAgICAgICBuYW1lOiAoKHJlc291cmNlTmFtZVByZWZpeCArICctVEcnKS5sZW5ndGggPj0gMzIpPyB0aGlzLmVudiArICctJyArIHRoaXMuYXBwTmFtZSArICctVEcnOnJlc291cmNlTmFtZVByZWZpeCArICctVEcnLFxuICAgICAgICB0aW1lb3V0OiAxMCxcbiAgICAgICAgdGhyZXNob2xkQ291bnQ6IDIsXG4gICAgICB9OiB1bmRlZmluZWQsXG4gICAgICB0ZW1wbGF0ZVByb3BzOiB7XG4gICAgICAgIGluc3RhbmNlVHlwZTogdGhpcy5pbnN0YW5jZVR5cGUsXG4gICAgICAgIGRldGFpbGVkTW9uaXRvcmluZzogZmFsc2UsXG4gICAgICAgIHRlbXBsYXRlTmFtZTogcmVzb3VyY2VOYW1lUHJlZml4ICsgJy1MVCcsXG4gICAgICAgIGFtaUltYWdlSWQ6IHByb3BzLmFtaSA/PyAnVWJ1bnR1IFNlcnZlciAyMC4wNCBMVFMgKEhWTSksIFNTRCBWb2x1bWUgVHlwZScsXG4gICAgICAgIHR5cGU6ICduZXcnLFxuICAgICAgICBibG9ja0RldmljZToge1xuICAgICAgICAgIHNpemU6IHRoaXMuZGlza1NpemUsXG4gICAgICAgICAgbmFtZTogJy9kZXYvc2RhMScsXG4gICAgICAgICAgdHlwZTogdGhpcy5nZXREaXNrVHlwZSh0aGlzLmRpc2tUeXBlID8/ICdHUDMnKSxcbiAgICAgICAgfSxcbiAgICAgICAgdnBjOiB7XG4gICAgICAgICAgdHlwZTogJ2V4aXN0aW5nJyxcbiAgICAgICAgICB2cGNOYW1lOiB0aGlzLnZwYyxcbiAgICAgICAgfSxcbiAgICAgICAgc2VjdXJpdHlHcm91cDoge1xuICAgICAgICAgIHR5cGU6ICduZXcnLFxuICAgICAgICAgIGFsbG93QWxsT3V0Ym91bmQ6IHRydWUsXG4gICAgICAgICAgc2VjdXJpdHlHcm91cE5hbWU6IHJlc291cmNlTmFtZVByZWZpeCArICctU0cnLFxuICAgICAgICAgIGluZ3Jlc3NSdWxlczogdGhpcy50Y3BSdWxlcyxcbiAgICAgICAgfSxcbiAgICAgICAgcm9sZTogdGhpcy5yb2xlLFxuICAgICAgICBzc2hLZXk6IHRoaXMuc3NoS2V5LFxuICAgICAgfSxcbiAgICAgIHRhZ3M6IHByb3BzLmluc3RhbmNlTGFiZWxzLFxuICAgICAgc3VibmV0czogdGhpcy5zdWJuZXRzLFxuICAgIH0pO1xuXG4gICAgaWYgKHRoaXMuY3JlYXRlQ29kZWRlcGxveUFwcGxpY2F0aW9uKSB7XG4gICAgICBjb25zdCBkZXBSb2xlID0gdGhpcy5nZXREZXBsb3ltZW50R3JvdXBSb2xlKCk7XG4gICAgICBjb25zdCBkZXAgPSBuZXcgRGVwbG95bWVudCh0aGlzLCByZXNvdXJjZU5hbWVQcmVmaXggKyAnLWNkJywge1xuICAgICAgICBhc2dOYW1lczogW3Jlc291cmNlTmFtZVByZWZpeCArICctQVNHJ10sXG4gICAgICAgIGRlcGxveW1lbnRDb25maWdOYW1lOiAnQ29kZURlcGxveURlZmF1bHQuT25lQXRBVGltZScsXG4gICAgICAgIHJvbGVBcm46IGRlcFJvbGUucm9sZUFybixcbiAgICAgICAgYXBwbGljYXRpb25Qcm9wczoge1xuICAgICAgICAgIGFwcGxpY2F0aW9uTmFtZTogdGhpcy5hcHBOYW1lICsgJy0nICsgdGhpcy5lbnYsXG4gICAgICAgICAgdHlwZTogdGhpcy5hcHBsaWNhdGlvblR5cGUsXG4gICAgICAgICAgcmVzb3VyY2VUeXBlOiAnU2VydmVyJyxcbiAgICAgICAgfSxcbiAgICAgICAgZGVwbG95bWVudEdyb3VwTmFtZTogdGhpcy5lbnYsXG4gICAgICAgIHRnTmFtZTogcmVzb3VyY2VOYW1lUHJlZml4ICsgJy1URycsXG4gICAgICB9KTtcbiAgICAgIGRlcC5ub2RlLmFkZERlcGVuZGVuY3koZGVwUm9sZSk7XG4gICAgfVxuXG4gICAgaWYgKHRoaXMuaG9zdCAmJiB0aGlzLmxiQXJuICYmIGFzZy50YXJnZXRHcm91cEFybiAhPSAnJykge1xuICAgICAgY29uc3QgbGJFbnRyeSA9IG5ldyBCYWxhbmNlckVudHJ5KHRoaXMsIHJlc291cmNlTmFtZVByZWZpeCArICctbGInLCB7XG4gICAgICAgIGFwcE5hbWU6IHRoaXMuYXBwTmFtZSxcbiAgICAgICAgaG9zdEhlYWRlcjogdGhpcy5ob3N0LFxuICAgICAgICB0YXJnZXRHcm91cEFybjogYXNnLnRhcmdldEdyb3VwQXJuLFxuICAgICAgICBsYkFybjogdGhpcy5sYkFybixcbiAgICAgICAgc3NsRW5hYmxlZDogdGhpcy5zc2xFbmFibGVkID8/IGZhbHNlLFxuICAgICAgfSk7XG4gICAgICBsYkVudHJ5Lm5vZGUuYWRkRGVwZW5kZW5jeShhc2cpO1xuICAgIH1cbiAgfVxuXG4gIHByaXZhdGUgZ2V0RGVwbG95bWVudEdyb3VwUm9sZSgpIHtcbiAgICB2YXIgcm9sZSA9IG5ldyBSb2xlKHRoaXMsIHRoaXMuYXBwTmFtZSArICctZGVwbG95bWVudC1ncm91cC1yb2xlJywge1xuICAgICAgYXNzdW1lZEJ5OiBuZXcgU2VydmljZVByaW5jaXBhbCgnY29kZWRlcGxveS5hbWF6b25hd3MuY29tJyksXG4gICAgICByb2xlTmFtZTogdGhpcy5hcHBOYW1lICsgJy1kZXBsb3ltZW50LWdyb3VwLXJvbGUnLFxuICAgIH0pO1xuICAgIHJvbGUuYWRkVG9Qb2xpY3koXG4gICAgICBuZXcgUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgZWZmZWN0OiBFZmZlY3QuQUxMT1csXG4gICAgICAgIHJlc291cmNlczogWycqJ10sXG4gICAgICAgIGFjdGlvbnM6IFtcbiAgICAgICAgICAnYXV0b3NjYWxpbmc6Q29tcGxldGVMaWZlY3ljbGVBY3Rpb24nLFxuICAgICAgICAgICdhdXRvc2NhbGluZzpEZWxldGVMaWZlY3ljbGVIb29rJyxcbiAgICAgICAgICAnYXV0b3NjYWxpbmc6RGVzY3JpYmVBdXRvU2NhbGluZ0dyb3VwcycsXG4gICAgICAgICAgJ2F1dG9zY2FsaW5nOkRlc2NyaWJlTGlmZWN5Y2xlSG9va3MnLFxuICAgICAgICAgICdhdXRvc2NhbGluZzpQdXRMaWZlY3ljbGVIb29rJyxcbiAgICAgICAgICAnYXV0b3NjYWxpbmc6UmVjb3JkTGlmZWN5Y2xlQWN0aW9uSGVhcnRiZWF0JyxcbiAgICAgICAgICAnYXV0b3NjYWxpbmc6Q3JlYXRlQXV0b1NjYWxpbmdHcm91cCcsXG4gICAgICAgICAgJ2F1dG9zY2FsaW5nOlVwZGF0ZUF1dG9TY2FsaW5nR3JvdXAnLFxuICAgICAgICAgICdhdXRvc2NhbGluZzpFbmFibGVNZXRyaWNzQ29sbGVjdGlvbicsXG4gICAgICAgICAgJ2F1dG9zY2FsaW5nOkRlc2NyaWJlUG9saWNpZXMnLFxuICAgICAgICAgICdhdXRvc2NhbGluZzpEZXNjcmliZVNjaGVkdWxlZEFjdGlvbnMnLFxuICAgICAgICAgICdhdXRvc2NhbGluZzpEZXNjcmliZU5vdGlmaWNhdGlvbkNvbmZpZ3VyYXRpb25zJyxcbiAgICAgICAgICAnYXV0b3NjYWxpbmc6U3VzcGVuZFByb2Nlc3NlcycsXG4gICAgICAgICAgJ2F1dG9zY2FsaW5nOlJlc3VtZVByb2Nlc3NlcycsXG4gICAgICAgICAgJ2F1dG9zY2FsaW5nOkF0dGFjaExvYWRCYWxhbmNlcnMnLFxuICAgICAgICAgICdhdXRvc2NhbGluZzpBdHRhY2hMb2FkQmFsYW5jZXJUYXJnZXRHcm91cHMnLFxuICAgICAgICAgICdhdXRvc2NhbGluZzpQdXRTY2FsaW5nUG9saWN5JyxcbiAgICAgICAgICAnYXV0b3NjYWxpbmc6UHV0U2NoZWR1bGVkVXBkYXRlR3JvdXBBY3Rpb24nLFxuICAgICAgICAgICdhdXRvc2NhbGluZzpQdXROb3RpZmljYXRpb25Db25maWd1cmF0aW9uJyxcbiAgICAgICAgICAnYXV0b3NjYWxpbmc6UHV0V2FybVBvb2wnLFxuICAgICAgICAgICdhdXRvc2NhbGluZzpEZXNjcmliZVNjYWxpbmdBY3Rpdml0aWVzJyxcbiAgICAgICAgICAnYXV0b3NjYWxpbmc6RGVsZXRlQXV0b1NjYWxpbmdHcm91cCcsXG4gICAgICAgICAgJ2VjMjpEZXNjcmliZUluc3RhbmNlcycsXG4gICAgICAgICAgJ2VjMjpEZXNjcmliZUluc3RhbmNlU3RhdHVzJyxcbiAgICAgICAgICAnZWMyOlRlcm1pbmF0ZUluc3RhbmNlcycsXG4gICAgICAgICAgJ3RhZzpHZXRSZXNvdXJjZXMnLFxuICAgICAgICAgICdzbnM6UHVibGlzaCcsXG4gICAgICAgICAgJ2Nsb3Vkd2F0Y2g6RGVzY3JpYmVBbGFybXMnLFxuICAgICAgICAgICdjbG91ZHdhdGNoOlB1dE1ldHJpY0FsYXJtJyxcbiAgICAgICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVzY3JpYmVMb2FkQmFsYW5jZXJzJyxcbiAgICAgICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVzY3JpYmVJbnN0YW5jZUhlYWx0aCcsXG4gICAgICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOlJlZ2lzdGVySW5zdGFuY2VzV2l0aExvYWRCYWxhbmNlcicsXG4gICAgICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlcmVnaXN0ZXJJbnN0YW5jZXNGcm9tTG9hZEJhbGFuY2VyJyxcbiAgICAgICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVzY3JpYmVUYXJnZXRHcm91cHMnLFxuICAgICAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZVRhcmdldEhlYWx0aCcsXG4gICAgICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOlJlZ2lzdGVyVGFyZ2V0cycsXG4gICAgICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlcmVnaXN0ZXJUYXJnZXRzJyxcbiAgICAgICAgICAnZWMyOkNyZWF0ZVRhZ3MnLFxuICAgICAgICAgICdlYzI6UnVuSW5zdGFuY2VzJyxcbiAgICAgICAgICAnaWFtOlBhc3NSb2xlJyxcbiAgICAgICAgICAuLi4gdGhpcy5kZXBsb3ltZW50UG9saWNpZXMgPz8gW10sXG4gICAgICAgIF0sXG4gICAgICB9KSxcbiAgICApO1xuICAgIHJldHVybiByb2xlO1xuICB9XG5cbiAgcHJpdmF0ZSBnZXREaXNrVHlwZSh0eXBlOiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdHlwZSBhcyBFYnNEZXZpY2VWb2x1bWVUeXBlO1xuICB9XG59XG4iXX0=