import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [controltower](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscontroltower.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Controltower extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [controltower](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscontroltower.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create an account managed by AWS Control Tower
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toCreateManagedAccount(): this;
    /**
     * Grants permission to delete AWS Control Tower landing zone
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/decommission-landing-zone.html
     */
    toDeleteLandingZone(): this;
    /**
     * Grants permission to deregister an account created through the account factory from AWS Control Tower
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toDeregisterManagedAccount(): this;
    /**
     * Grants permission to deregister an organizational unit from AWS Control Tower management
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toDeregisterOrganizationalUnit(): this;
    /**
     * Grants permission to describe the current account factory configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toDescribeAccountFactoryConfig(): this;
    /**
     * Grants permission to describe resources managed by core accounts in AWS Control Tower
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/how-control-tower-works.html#what-shared
     */
    toDescribeCoreService(): this;
    /**
     * Grants permission to describe a guardrail
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toDescribeGuardrail(): this;
    /**
     * Grants permission to describe a guardrail for a organizational unit
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toDescribeGuardrailForTarget(): this;
    /**
     * Grants permission to describe the current Landing Zone configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/step-two.html
     */
    toDescribeLandingZoneConfiguration(): this;
    /**
     * Grants permission to describe an account created through account factory
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toDescribeManagedAccount(): this;
    /**
     * Grants permission to describe an AWS Organizations organizational unit managed by AWS Control Tower
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toDescribeManagedOrganizationalUnit(): this;
    /**
     * Grants permission to describe a Register Organizational Unit Operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/about-extending-governance.html
     */
    toDescribeRegisterOrganizationalUnitOperation(): this;
    /**
     * Grants permission to describe the current AWS Control Tower SSO configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/sso.html
     */
    toDescribeSingleSignOn(): this;
    /**
     * Grants permission to remove a control from an organizational unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_DisableControl.html
     */
    toDisableControl(): this;
    /**
     * Grants permission to disable a guardrail from an organizational unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/enable-controls-on-ou.html
     */
    toDisableGuardrail(): this;
    /**
     * Grants permission to activate a control for an organizational unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_EnableControl.html
     */
    toEnableControl(): this;
    /**
     * Grants permission to enable a guardrail to an organizational unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/enable-controls-on-ou.html
     */
    toEnableGuardrail(): this;
    /**
     * Grants permission to describe an account email and validate that it exists
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/accounts.html
     */
    toGetAccountInfo(): this;
    /**
     * Grants permission to list available updates for the current AWS Control Tower deployment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/configuration-updates.html
     */
    toGetAvailableUpdates(): this;
    /**
     * Grants permission to get the current status of a particular EnabledControl or DisableControl operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_GetControlOperation.html
     */
    toGetControlOperation(): this;
    /**
     * Grants permission to get the current compliance status of a guardrail
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toGetGuardrailComplianceStatus(): this;
    /**
     * Grants permission to get the home region of the AWS Control Tower setup
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/how-control-tower-works.html#region-how
     */
    toGetHomeRegion(): this;
    /**
     * Grants permission to get the current landing zone drift status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/drift.html
     */
    toGetLandingZoneDriftStatus(): this;
    /**
     * Grants permission to get the current status of the landing zone setup
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/getting-started-with-control-tower.html#step-two
     */
    toGetLandingZoneStatus(): this;
    /**
     * Grants permission to list the current directory groups available through SSO
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/sso.html
     */
    toListDirectoryGroups(): this;
    /**
     * Grants permission to list occurrences of drift in AWS Control Tower
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/drift.html
     */
    toListDriftDetails(): this;
    /**
     * Grants permission to list all enabled controls in a specified organizational unit
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_ListEnabledControls.html
     */
    toListEnabledControls(): this;
    /**
     * Grants permission to list currently enabled guardrails
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toListEnabledGuardrails(): this;
    /**
     * Grants permission to list Precheck details for an Organizational Unit
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/about-extending-governance.html
     */
    toListExtendGovernancePrecheckDetails(): this;
    /**
     * Grants permission to list the compliance of external AWS Config rules
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/review-compliance.html
     */
    toListExternalConfigRuleCompliance(): this;
    /**
     * Grants permission to list existing guardrail violations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toListGuardrailViolations(): this;
    /**
     * Grants permission to list all available guardrails
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toListGuardrails(): this;
    /**
     * Grants permission to list guardrails and their current state for a organizational unit
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toListGuardrailsForTarget(): this;
    /**
     * Grants permission to list accounts managed through AWS Control Tower
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toListManagedAccounts(): this;
    /**
     * Grants permission to list managed accounts with a specified guardrail applied
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toListManagedAccountsForGuardrail(): this;
    /**
     * Grants permission to list managed accounts under an organizational unit
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toListManagedAccountsForParent(): this;
    /**
     * Grants permission to list organizational units managed by AWS Control Tower
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toListManagedOrganizationalUnits(): this;
    /**
     * Grants permission to list managed organizational units that have a specified guardrail applied
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toListManagedOrganizationalUnitsForGuardrail(): this;
    /**
     * Grants permission to set up an organizational unit to be managed by AWS Control Tower
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toManageOrganizationalUnit(): this;
    /**
     * Grants permission to perform validations in an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/getting-started-prereqs.html
     */
    toPerformPreLaunchChecks(): this;
    /**
     * Grants permission to set up or update AWS Control Tower landing zone
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/getting-started-with-control-tower.html#step-two
     */
    toSetupLandingZone(): this;
    /**
     * Grants permission to update the account factory configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toUpdateAccountFactoryConfig(): this;
    protected accessLevelList: AccessLevelList;
}
