"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Drs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [drs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselasticdisasterrecovery.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Drs extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [drs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselasticdisasterrecovery.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'drs';
        this.accessLevelList = {
            Write: [
                'AssociateFailbackClientToRecoveryInstanceForDrs',
                'BatchCreateVolumeSnapshotGroupForDrs',
                'BatchDeleteSnapshotRequestForDrs',
                'CreateConvertedSnapshotForDrs',
                'CreateExtendedSourceServer',
                'CreateRecoveryInstanceForDrs',
                'CreateReplicationConfigurationTemplate',
                'CreateSourceServerForDrs',
                'DeleteJob',
                'DeleteRecoveryInstance',
                'DeleteReplicationConfigurationTemplate',
                'DeleteSourceServer',
                'DisconnectRecoveryInstance',
                'DisconnectSourceServer',
                'InitializeService',
                'IssueAgentCertificateForDrs',
                'NotifyAgentAuthenticationForDrs',
                'NotifyAgentConnectedForDrs',
                'NotifyAgentDisconnectedForDrs',
                'NotifyAgentReplicationProgressForDrs',
                'NotifyConsistencyAttainedForDrs',
                'NotifyReplicationServerAuthenticationForDrs',
                'NotifyVolumeEventForDrs',
                'RetryDataReplication',
                'ReverseReplication',
                'SendAgentLogsForDrs',
                'SendAgentMetricsForDrs',
                'SendChannelCommandResultForDrs',
                'SendClientLogsForDrs',
                'SendClientMetricsForDrs',
                'SendVolumeStatsForDrs',
                'StartFailbackLaunch',
                'StartRecovery',
                'StartReplication',
                'StopFailback',
                'StopReplication',
                'TerminateRecoveryInstances',
                'UpdateAgentBacklogForDrs',
                'UpdateAgentConversionInfoForDrs',
                'UpdateAgentReplicationInfoForDrs',
                'UpdateAgentReplicationProcessStateForDrs',
                'UpdateAgentSourcePropertiesForDrs',
                'UpdateFailbackClientDeviceMappingForDrs',
                'UpdateFailbackClientLastSeenForDrs',
                'UpdateFailbackReplicationConfiguration',
                'UpdateLaunchConfiguration',
                'UpdateReplicationCertificateForDrs',
                'UpdateReplicationConfiguration',
                'UpdateReplicationConfigurationTemplate'
            ],
            Read: [
                'DescribeJobLogItems',
                'DescribeJobs',
                'DescribeRecoveryInstances',
                'DescribeRecoverySnapshots',
                'DescribeReplicationConfigurationTemplates',
                'DescribeReplicationServerAssociationsForDrs',
                'DescribeSnapshotRequestsForDrs',
                'DescribeSourceServers',
                'GetAgentCommandForDrs',
                'GetAgentConfirmedResumeInfoForDrs',
                'GetAgentInstallationAssetsForDrs',
                'GetAgentReplicationInfoForDrs',
                'GetAgentRuntimeConfigurationForDrs',
                'GetAgentSnapshotCreditsForDrs',
                'GetChannelCommandsForDrs',
                'GetFailbackCommandForDrs',
                'GetFailbackLaunchRequestedForDrs',
                'GetFailbackReplicationConfiguration',
                'GetLaunchConfiguration',
                'GetReplicationConfiguration',
                'GetSuggestedFailbackClientDeviceMappingForDrs',
                'ListExtensibleSourceServers',
                'ListStagingAccounts',
                'ListTagsForResource'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to get associate failback client to recovery instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toAssociateFailbackClientToRecoveryInstanceForDrs() {
        return this.to('AssociateFailbackClientToRecoveryInstanceForDrs');
    }
    /**
     * Grants permission to batch create volume snapshot group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toBatchCreateVolumeSnapshotGroupForDrs() {
        return this.to('BatchCreateVolumeSnapshotGroupForDrs');
    }
    /**
     * Grants permission to batch delete snapshot request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toBatchDeleteSnapshotRequestForDrs() {
        return this.to('BatchDeleteSnapshotRequestForDrs');
    }
    /**
     * Grants permission to create converted snapshot
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toCreateConvertedSnapshotForDrs() {
        return this.to('CreateConvertedSnapshotForDrs');
    }
    /**
     * Grants permission to extend a source server
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - drs:DescribeSourceServers
     * - drs:GetReplicationConfiguration
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_CreateExtendedSourceServer.html
     */
    toCreateExtendedSourceServer() {
        return this.to('CreateExtendedSourceServer');
    }
    /**
     * Grants permission to create recovery instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toCreateRecoveryInstanceForDrs() {
        return this.to('CreateRecoveryInstanceForDrs');
    }
    /**
     * Grants permission to create replication configuration template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ec2:CreateSecurityGroup
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSubnets
     * - ec2:GetEbsDefaultKmsKeyId
     * - ec2:GetEbsEncryptionByDefault
     * - kms:CreateGrant
     * - kms:DescribeKey
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_CreateReplicationConfigurationTemplate.html
     */
    toCreateReplicationConfigurationTemplate() {
        return this.to('CreateReplicationConfigurationTemplate');
    }
    /**
     * Grants permission to create a source server
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toCreateSourceServerForDrs() {
        return this.to('CreateSourceServerForDrs');
    }
    /**
     * Grants permission to delete a job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DeleteJob.html
     */
    toDeleteJob() {
        return this.to('DeleteJob');
    }
    /**
     * Grants permission to delete recovery instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DeleteRecoveryInstance.html
     */
    toDeleteRecoveryInstance() {
        return this.to('DeleteRecoveryInstance');
    }
    /**
     * Grants permission to delete replication configuration template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DeleteReplicationConfigurationTemplate.html
     */
    toDeleteReplicationConfigurationTemplate() {
        return this.to('DeleteReplicationConfigurationTemplate');
    }
    /**
     * Grants permission to delete source server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DeleteSourceServer.html
     */
    toDeleteSourceServer() {
        return this.to('DeleteSourceServer');
    }
    /**
     * Grants permission to describe job log items
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeJobLogItems.html
     */
    toDescribeJobLogItems() {
        return this.to('DescribeJobLogItems');
    }
    /**
     * Grants permission to describe jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeJobs.html
     */
    toDescribeJobs() {
        return this.to('DescribeJobs');
    }
    /**
     * Grants permission to describe recovery instances
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - drs:DescribeSourceServers
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeRecoveryInstances.html
     */
    toDescribeRecoveryInstances() {
        return this.to('DescribeRecoveryInstances');
    }
    /**
     * Grants permission to describe recovery snapshots
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeRecoverySnapshots.html
     */
    toDescribeRecoverySnapshots() {
        return this.to('DescribeRecoverySnapshots');
    }
    /**
     * Grants permission to describe replication configuration template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeReplicationConfigurationTemplates.html
     */
    toDescribeReplicationConfigurationTemplates() {
        return this.to('DescribeReplicationConfigurationTemplates');
    }
    /**
     * Grants permission to describe replication server associations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toDescribeReplicationServerAssociationsForDrs() {
        return this.to('DescribeReplicationServerAssociationsForDrs');
    }
    /**
     * Grants permission to describe snapshot requests
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toDescribeSnapshotRequestsForDrs() {
        return this.to('DescribeSnapshotRequestsForDrs');
    }
    /**
     * Grants permission to describe source servers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DescribeSourceServers.html
     */
    toDescribeSourceServers() {
        return this.to('DescribeSourceServers');
    }
    /**
     * Grants permission to disconnect recovery instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DisconnectRecoveryInstance.html
     */
    toDisconnectRecoveryInstance() {
        return this.to('DisconnectRecoveryInstance');
    }
    /**
     * Grants permission to disconnect source server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_DisconnectSourceServer.html
     */
    toDisconnectSourceServer() {
        return this.to('DisconnectSourceServer');
    }
    /**
     * Grants permission to get agent command
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentCommandForDrs() {
        return this.to('GetAgentCommandForDrs');
    }
    /**
     * Grants permission to get agent confirmed resume info
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentConfirmedResumeInfoForDrs() {
        return this.to('GetAgentConfirmedResumeInfoForDrs');
    }
    /**
     * Grants permission to get agent installation assets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentInstallationAssetsForDrs() {
        return this.to('GetAgentInstallationAssetsForDrs');
    }
    /**
     * Grants permission to get agent replication info
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentReplicationInfoForDrs() {
        return this.to('GetAgentReplicationInfoForDrs');
    }
    /**
     * Grants permission to get agent runtime configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentRuntimeConfigurationForDrs() {
        return this.to('GetAgentRuntimeConfigurationForDrs');
    }
    /**
     * Grants permission to get agent snapshot credits
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetAgentSnapshotCreditsForDrs() {
        return this.to('GetAgentSnapshotCreditsForDrs');
    }
    /**
     * Grants permission to get channel commands
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetChannelCommandsForDrs() {
        return this.to('GetChannelCommandsForDrs');
    }
    /**
     * Grants permission to get failback command
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetFailbackCommandForDrs() {
        return this.to('GetFailbackCommandForDrs');
    }
    /**
     * Grants permission to get failback launch requested
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetFailbackLaunchRequestedForDrs() {
        return this.to('GetFailbackLaunchRequestedForDrs');
    }
    /**
     * Grants permission to get failback replication configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_GetFailbackReplicationConfiguration.html
     */
    toGetFailbackReplicationConfiguration() {
        return this.to('GetFailbackReplicationConfiguration');
    }
    /**
     * Grants permission to get launch configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_GetLaunchConfiguration.html
     */
    toGetLaunchConfiguration() {
        return this.to('GetLaunchConfiguration');
    }
    /**
     * Grants permission to get replication configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_GetReplicationConfiguration.html
     */
    toGetReplicationConfiguration() {
        return this.to('GetReplicationConfiguration');
    }
    /**
     * Grants permission to get suggested failback client device mapping
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toGetSuggestedFailbackClientDeviceMappingForDrs() {
        return this.to('GetSuggestedFailbackClientDeviceMappingForDrs');
    }
    /**
     * Grants permission to initialize service
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:AddRoleToInstanceProfile
     * - iam:CreateInstanceProfile
     * - iam:CreateServiceLinkedRole
     * - iam:GetInstanceProfile
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_InitializeService.html
     */
    toInitializeService() {
        return this.to('InitializeService');
    }
    /**
     * Grants permission to issue an agent certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toIssueAgentCertificateForDrs() {
        return this.to('IssueAgentCertificateForDrs');
    }
    /**
     * Grants permission to list extensible source servers
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - drs:DescribeSourceServers
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_ListExtensibleSourceServers.html
     */
    toListExtensibleSourceServers() {
        return this.to('ListExtensibleSourceServers');
    }
    /**
     * Grants permission to list staging accounts
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_ListStagingAccounts.html
     */
    toListStagingAccounts() {
        return this.to('ListStagingAccounts');
    }
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to notify agent authentication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyAgentAuthenticationForDrs() {
        return this.to('NotifyAgentAuthenticationForDrs');
    }
    /**
     * Grants permission to notify agent is connected
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyAgentConnectedForDrs() {
        return this.to('NotifyAgentConnectedForDrs');
    }
    /**
     * Grants permission to notify agent is disconnected
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyAgentDisconnectedForDrs() {
        return this.to('NotifyAgentDisconnectedForDrs');
    }
    /**
     * Grants permission to notify agent replication progress
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyAgentReplicationProgressForDrs() {
        return this.to('NotifyAgentReplicationProgressForDrs');
    }
    /**
     * Grants permission to notify consistency attained
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyConsistencyAttainedForDrs() {
        return this.to('NotifyConsistencyAttainedForDrs');
    }
    /**
     * Grants permission to notify replication server authentication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyReplicationServerAuthenticationForDrs() {
        return this.to('NotifyReplicationServerAuthenticationForDrs');
    }
    /**
     * Grants permission to notify replicator volume events
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toNotifyVolumeEventForDrs() {
        return this.to('NotifyVolumeEventForDrs');
    }
    /**
     * Grants permission to retry data replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_RetryDataReplication.html
     */
    toRetryDataReplication() {
        return this.to('RetryDataReplication');
    }
    /**
     * Grants permission to reverse replication
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - drs:DescribeReplicationConfigurationTemplates
     * - drs:DescribeSourceServers
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_ReverseReplication.html
     */
    toReverseReplication() {
        return this.to('ReverseReplication');
    }
    /**
     * Grants permission to send agent logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendAgentLogsForDrs() {
        return this.to('SendAgentLogsForDrs');
    }
    /**
     * Grants permission to send agent metrics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendAgentMetricsForDrs() {
        return this.to('SendAgentMetricsForDrs');
    }
    /**
     * Grants permission to send channel command result
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendChannelCommandResultForDrs() {
        return this.to('SendChannelCommandResultForDrs');
    }
    /**
     * Grants permission to send client logs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendClientLogsForDrs() {
        return this.to('SendClientLogsForDrs');
    }
    /**
     * Grants permission to send client metrics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendClientMetricsForDrs() {
        return this.to('SendClientMetricsForDrs');
    }
    /**
     * Grants permission to send volume throughput statistics
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toSendVolumeStatsForDrs() {
        return this.to('SendVolumeStatsForDrs');
    }
    /**
     * Grants permission to start failback launch
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_StartFailbackLaunch.html
     */
    toStartFailbackLaunch() {
        return this.to('StartFailbackLaunch');
    }
    /**
     * Grants permission to start recovery
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - drs:CreateRecoveryInstanceForDrs
     * - drs:ListTagsForResource
     * - ec2:AttachVolume
     * - ec2:AuthorizeSecurityGroupEgress
     * - ec2:AuthorizeSecurityGroupIngress
     * - ec2:CreateLaunchTemplate
     * - ec2:CreateLaunchTemplateVersion
     * - ec2:CreateSnapshot
     * - ec2:CreateTags
     * - ec2:CreateVolume
     * - ec2:DeleteLaunchTemplateVersions
     * - ec2:DeleteSnapshot
     * - ec2:DeleteVolume
     * - ec2:DescribeAccountAttributes
     * - ec2:DescribeAvailabilityZones
     * - ec2:DescribeImages
     * - ec2:DescribeInstanceAttribute
     * - ec2:DescribeInstanceStatus
     * - ec2:DescribeInstanceTypes
     * - ec2:DescribeInstances
     * - ec2:DescribeLaunchTemplateVersions
     * - ec2:DescribeLaunchTemplates
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSnapshots
     * - ec2:DescribeSubnets
     * - ec2:DescribeVolumes
     * - ec2:DetachVolume
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifyLaunchTemplate
     * - ec2:RevokeSecurityGroupEgress
     * - ec2:RunInstances
     * - ec2:StartInstances
     * - ec2:StopInstances
     * - ec2:TerminateInstances
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_StartRecovery.html
     */
    toStartRecovery() {
        return this.to('StartRecovery');
    }
    /**
     * Grants permission to start replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_StartReplication.html
     */
    toStartReplication() {
        return this.to('StartReplication');
    }
    /**
     * Grants permission to stop failback
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_StopFailback.html
     */
    toStopFailback() {
        return this.to('StopFailback');
    }
    /**
     * Grants permission to stop replication
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_StopReplication.html
     */
    toStopReplication() {
        return this.to('StopReplication');
    }
    /**
     * Grants permission to assign a resource tag
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifCreateAction()
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to terminate recovery instances
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - drs:DescribeSourceServers
     * - ec2:DeleteVolume
     * - ec2:DescribeInstances
     * - ec2:DescribeVolumes
     * - ec2:TerminateInstances
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_TerminateRecoveryInstances.html
     */
    toTerminateRecoveryInstances() {
        return this.to('TerminateRecoveryInstances');
    }
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update agent backlog
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateAgentBacklogForDrs() {
        return this.to('UpdateAgentBacklogForDrs');
    }
    /**
     * Grants permission to update agent conversion info
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateAgentConversionInfoForDrs() {
        return this.to('UpdateAgentConversionInfoForDrs');
    }
    /**
     * Grants permission to update agent replication info
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateAgentReplicationInfoForDrs() {
        return this.to('UpdateAgentReplicationInfoForDrs');
    }
    /**
     * Grants permission to update agent replication process state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateAgentReplicationProcessStateForDrs() {
        return this.to('UpdateAgentReplicationProcessStateForDrs');
    }
    /**
     * Grants permission to update agent source properties
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateAgentSourcePropertiesForDrs() {
        return this.to('UpdateAgentSourcePropertiesForDrs');
    }
    /**
     * Grants permission to update failback client device mapping
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateFailbackClientDeviceMappingForDrs() {
        return this.to('UpdateFailbackClientDeviceMappingForDrs');
    }
    /**
     * Grants permission to update failback client last seen
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateFailbackClientLastSeenForDrs() {
        return this.to('UpdateFailbackClientLastSeenForDrs');
    }
    /**
     * Grants permission to update failback replication configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UpdateFailbackReplicationConfiguration.html
     */
    toUpdateFailbackReplicationConfiguration() {
        return this.to('UpdateFailbackReplicationConfiguration');
    }
    /**
     * Grants permission to update launch configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UpdateLaunchConfiguration.html
     */
    toUpdateLaunchConfiguration() {
        return this.to('UpdateLaunchConfiguration');
    }
    /**
     * Grants permission to update a replication certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/drs-apis.html
     */
    toUpdateReplicationCertificateForDrs() {
        return this.to('UpdateReplicationCertificateForDrs');
    }
    /**
     * Grants permission to update replication configuration
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateSecurityGroup
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSubnets
     * - ec2:GetEbsDefaultKmsKeyId
     * - ec2:GetEbsEncryptionByDefault
     * - kms:CreateGrant
     * - kms:DescribeKey
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UpdateReplicationConfiguration.html
     */
    toUpdateReplicationConfiguration() {
        return this.to('UpdateReplicationConfiguration');
    }
    /**
     * Grants permission to update replication configuration template
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateSecurityGroup
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSubnets
     * - ec2:GetEbsDefaultKmsKeyId
     * - ec2:GetEbsEncryptionByDefault
     * - kms:CreateGrant
     * - kms:DescribeKey
     *
     * https://docs.aws.amazon.com/drs/latest/APIReference/API_UpdateReplicationConfigurationTemplate.html
     */
    toUpdateReplicationConfigurationTemplate() {
        return this.to('UpdateReplicationConfigurationTemplate');
    }
    /**
     * Adds a resource of type JobResource to the statement
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/failback-overview.html
     *
     * @param jobID - Identifier for the jobID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onJobResource(jobID, account, region, partition) {
        return this.on(`arn:${partition || Drs.defaultPartition}:drs:${region || '*'}:${account || '*'}:job/${jobID}`);
    }
    /**
     * Adds a resource of type RecoveryInstanceResource to the statement
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/recovery-instances.html
     *
     * @param recoveryInstanceID - Identifier for the recoveryInstanceID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifEC2InstanceARN()
     */
    onRecoveryInstanceResource(recoveryInstanceID, account, region, partition) {
        return this.on(`arn:${partition || Drs.defaultPartition}:drs:${region || '*'}:${account || '*'}:recovery-instance/${recoveryInstanceID}`);
    }
    /**
     * Adds a resource of type ReplicationConfigurationTemplateResource to the statement
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/replication-settings-template.html
     *
     * @param replicationConfigurationTemplateID - Identifier for the replicationConfigurationTemplateID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReplicationConfigurationTemplateResource(replicationConfigurationTemplateID, account, region, partition) {
        return this.on(`arn:${partition || Drs.defaultPartition}:drs:${region || '*'}:${account || '*'}:replication-configuration-template/${replicationConfigurationTemplateID}`);
    }
    /**
     * Adds a resource of type SourceServerResource to the statement
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/source-servers.html
     *
     * @param sourceServerID - Identifier for the sourceServerID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSourceServerResource(sourceServerID, account, region, partition) {
        return this.on(`arn:${partition || Drs.defaultPartition}:drs:${region || '*'}:${account || '*'}:source-server/${sourceServerID}`);
    }
    /**
     * Filters access by the name of a resource-creating API action
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/supported-iam-actions-tagging.html
     *
     * Applies to actions:
     * - .toTagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCreateAction(value, operator) {
        return this.if(`CreateAction`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the EC2 instance the request originated from
     *
     * https://docs.aws.amazon.com/drs/latest/userguide/security_iam_authentication.html
     *
     * Applies to resource types:
     * - RecoveryInstanceResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifEC2InstanceARN(value, operator) {
        return this.if(`EC2InstanceARN`, value, operator || 'StringLike');
    }
}
exports.Drs = Drs;
_a = JSII_RTTI_SYMBOL_1;
Drs[_a] = { fqn: "iam-floyd.Drs", version: "0.499.0" };
//# sourceMappingURL=data:application/json;base64,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