"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Freetier = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [freetier](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsfreetier.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Freetier extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [freetier](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsfreetier.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'freetier';
        this.accessLevelList = {
            Read: [
                'GetFreeTierAlertPreference',
                'GetFreeTierUsage'
            ],
            Write: [
                'PutFreeTierAlertPreference'
            ]
        };
    }
    /**
     * Allow or deny IAM users permission to get free tier alert preference (email address)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/tracking-free-tier-usage.html
     */
    toGetFreeTierAlertPreference() {
        return this.to('GetFreeTierAlertPreference');
    }
    /**
     * Allow or deny IAM users permission to get free tier usage limits and MTD usage status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/tracking-free-tier-usage.html
     */
    toGetFreeTierUsage() {
        return this.to('GetFreeTierUsage');
    }
    /**
     * Allow or deny IAM users permission to set free tier alert preference (email address)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/tracking-free-tier-usage.html
     */
    toPutFreeTierAlertPreference() {
        return this.to('PutFreeTierAlertPreference');
    }
}
exports.Freetier = Freetier;
_a = JSII_RTTI_SYMBOL_1;
Freetier[_a] = { fqn: "iam-floyd.Freetier", version: "0.499.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZnJlZXRpZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJmcmVldGllci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUNBLHNDQUE0QztBQUU1Qzs7OztHQUlHO0FBQ0gsTUFBYSxRQUFTLFNBQVEsd0JBQWU7SUFHM0M7Ozs7T0FJRztJQUNILFlBQVksR0FBWTtRQUN0QixLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7UUFSTixrQkFBYSxHQUFHLFVBQVUsQ0FBQztRQTRDeEIsb0JBQWUsR0FBb0I7WUFDM0MsSUFBSSxFQUFFO2dCQUNKLDRCQUE0QjtnQkFDNUIsa0JBQWtCO2FBQ25CO1lBQ0QsS0FBSyxFQUFFO2dCQUNMLDRCQUE0QjthQUM3QjtTQUNGLENBQUM7SUEzQ0YsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDRCQUE0QjtRQUNqQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsNEJBQTRCLENBQUMsQ0FBQztJQUMvQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw0QkFBNEI7UUFDakMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDRCQUE0QixDQUFDLENBQUM7SUFDL0MsQ0FBQzs7QUEzQ0gsNEJBc0RDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQWNjZXNzTGV2ZWxMaXN0IH0gZnJvbSAnLi4vc2hhcmVkL2FjY2Vzcy1sZXZlbCc7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tICcuLi9zaGFyZWQnO1xuXG4vKipcbiAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbZnJlZXRpZXJdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zZXJ2aWNlLWF1dGhvcml6YXRpb24vbGF0ZXN0L3JlZmVyZW5jZS9saXN0X2F3c2ZyZWV0aWVyLmh0bWwpLlxuICpcbiAqIEBwYXJhbSBzaWQgW1NJRF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19zaWQuaHRtbCkgb2YgdGhlIHN0YXRlbWVudFxuICovXG5leHBvcnQgY2xhc3MgRnJlZXRpZXIgZXh0ZW5kcyBQb2xpY3lTdGF0ZW1lbnQge1xuICBwdWJsaWMgc2VydmljZVByZWZpeCA9ICdmcmVldGllcic7XG5cbiAgLyoqXG4gICAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbZnJlZXRpZXJdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zZXJ2aWNlLWF1dGhvcml6YXRpb24vbGF0ZXN0L3JlZmVyZW5jZS9saXN0X2F3c2ZyZWV0aWVyLmh0bWwpLlxuICAgKlxuICAgKiBAcGFyYW0gc2lkIFtTSURdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfc2lkLmh0bWwpIG9mIHRoZSBzdGF0ZW1lbnRcbiAgICovXG4gIGNvbnN0cnVjdG9yKHNpZD86IHN0cmluZykge1xuICAgIHN1cGVyKHNpZCk7XG4gIH1cblxuICAvKipcbiAgICogQWxsb3cgb3IgZGVueSBJQU0gdXNlcnMgcGVybWlzc2lvbiB0byBnZXQgZnJlZSB0aWVyIGFsZXJ0IHByZWZlcmVuY2UgKGVtYWlsIGFkZHJlc3MpXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXdzYWNjb3VudGJpbGxpbmcvbGF0ZXN0L2Fib3V0djIvdHJhY2tpbmctZnJlZS10aWVyLXVzYWdlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEZyZWVUaWVyQWxlcnRQcmVmZXJlbmNlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRGcmVlVGllckFsZXJ0UHJlZmVyZW5jZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEFsbG93IG9yIGRlbnkgSUFNIHVzZXJzIHBlcm1pc3Npb24gdG8gZ2V0IGZyZWUgdGllciB1c2FnZSBsaW1pdHMgYW5kIE1URCB1c2FnZSBzdGF0dXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hd3NhY2NvdW50YmlsbGluZy9sYXRlc3QvYWJvdXR2Mi90cmFja2luZy1mcmVlLXRpZXItdXNhZ2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0RnJlZVRpZXJVc2FnZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0RnJlZVRpZXJVc2FnZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEFsbG93IG9yIGRlbnkgSUFNIHVzZXJzIHBlcm1pc3Npb24gdG8gc2V0IGZyZWUgdGllciBhbGVydCBwcmVmZXJlbmNlIChlbWFpbCBhZGRyZXNzKVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hd3NhY2NvdW50YmlsbGluZy9sYXRlc3QvYWJvdXR2Mi90cmFja2luZy1mcmVlLXRpZXItdXNhZ2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvUHV0RnJlZVRpZXJBbGVydFByZWZlcmVuY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1B1dEZyZWVUaWVyQWxlcnRQcmVmZXJlbmNlJyk7XG4gIH1cblxuICBwcm90ZWN0ZWQgYWNjZXNzTGV2ZWxMaXN0OiBBY2Nlc3NMZXZlbExpc3QgPSB7XG4gICAgUmVhZDogW1xuICAgICAgJ0dldEZyZWVUaWVyQWxlcnRQcmVmZXJlbmNlJyxcbiAgICAgICdHZXRGcmVlVGllclVzYWdlJ1xuICAgIF0sXG4gICAgV3JpdGU6IFtcbiAgICAgICdQdXRGcmVlVGllckFsZXJ0UHJlZmVyZW5jZSdcbiAgICBdXG4gIH07XG59XG4iXX0=