"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Greengrass = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [greengrass](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotgreengrass.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Greengrass extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [greengrass](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotgreengrass.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'greengrass';
        this.accessLevelList = {
            Write: [
                'AssociateRoleToGroup',
                'CreateConnectorDefinition',
                'CreateConnectorDefinitionVersion',
                'CreateCoreDefinition',
                'CreateCoreDefinitionVersion',
                'CreateDeployment',
                'CreateDeviceDefinition',
                'CreateDeviceDefinitionVersion',
                'CreateFunctionDefinition',
                'CreateFunctionDefinitionVersion',
                'CreateGroup',
                'CreateGroupCertificateAuthority',
                'CreateGroupVersion',
                'CreateLoggerDefinition',
                'CreateLoggerDefinitionVersion',
                'CreateResourceDefinition',
                'CreateResourceDefinitionVersion',
                'CreateSoftwareUpdateJob',
                'CreateSubscriptionDefinition',
                'CreateSubscriptionDefinitionVersion',
                'DeleteConnectorDefinition',
                'DeleteCoreDefinition',
                'DeleteDeviceDefinition',
                'DeleteFunctionDefinition',
                'DeleteGroup',
                'DeleteLoggerDefinition',
                'DeleteResourceDefinition',
                'DeleteSubscriptionDefinition',
                'DisassociateRoleFromGroup',
                'DisassociateServiceRoleFromAccount',
                'ResetDeployments',
                'StartBulkDeployment',
                'StopBulkDeployment',
                'UpdateConnectivityInfo',
                'UpdateConnectorDefinition',
                'UpdateCoreDefinition',
                'UpdateDeviceDefinition',
                'UpdateFunctionDefinition',
                'UpdateGroup',
                'UpdateGroupCertificateConfiguration',
                'UpdateLoggerDefinition',
                'UpdateResourceDefinition',
                'UpdateSubscriptionDefinition',
                'UpdateThingRuntimeConfiguration'
            ],
            'Permissions management': [
                'AssociateServiceRoleToAccount'
            ],
            Read: [
                'Discover',
                'GetAssociatedRole',
                'GetBulkDeploymentStatus',
                'GetConnectivityInfo',
                'GetConnectorDefinition',
                'GetConnectorDefinitionVersion',
                'GetCoreDefinition',
                'GetCoreDefinitionVersion',
                'GetDeploymentStatus',
                'GetDeviceDefinition',
                'GetDeviceDefinitionVersion',
                'GetFunctionDefinition',
                'GetFunctionDefinitionVersion',
                'GetGroup',
                'GetGroupCertificateAuthority',
                'GetGroupCertificateConfiguration',
                'GetGroupVersion',
                'GetLoggerDefinition',
                'GetLoggerDefinitionVersion',
                'GetResourceDefinition',
                'GetResourceDefinitionVersion',
                'GetServiceRoleForAccount',
                'GetSubscriptionDefinition',
                'GetSubscriptionDefinitionVersion',
                'GetThingRuntimeConfiguration',
                'ListBulkDeploymentDetailedReports',
                'ListTagsForResource'
            ],
            List: [
                'ListBulkDeployments',
                'ListConnectorDefinitionVersions',
                'ListConnectorDefinitions',
                'ListCoreDefinitionVersions',
                'ListCoreDefinitions',
                'ListDeployments',
                'ListDeviceDefinitionVersions',
                'ListDeviceDefinitions',
                'ListFunctionDefinitionVersions',
                'ListFunctionDefinitions',
                'ListGroupCertificateAuthorities',
                'ListGroupVersions',
                'ListGroups',
                'ListLoggerDefinitionVersions',
                'ListLoggerDefinitions',
                'ListResourceDefinitionVersions',
                'ListResourceDefinitions',
                'ListSubscriptionDefinitionVersions',
                'ListSubscriptionDefinitions'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to associate a role with a group. The role's permissions must allow Greengrass core Lambda functions and connectors to perform actions in other AWS services
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/associateroletogroup-put.html
     */
    toAssociateRoleToGroup() {
        return this.to('AssociateRoleToGroup');
    }
    /**
     * Grants permission to associate a role with your account. AWS IoT Greengrass uses this role to access your Lambda functions and AWS IoT resources
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/associateserviceroletoaccount-put.html
     */
    toAssociateServiceRoleToAccount() {
        return this.to('AssociateServiceRoleToAccount');
    }
    /**
     * Grants permission to create a connector definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/createconnectordefinition-post.html
     */
    toCreateConnectorDefinition() {
        return this.to('CreateConnectorDefinition');
    }
    /**
     * Grants permission to create a version of an existing connector definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/createconnectordefinitionversion-post.html
     */
    toCreateConnectorDefinitionVersion() {
        return this.to('CreateConnectorDefinitionVersion');
    }
    /**
     * Grants permission to create a core definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/createcoredefinition-post.html
     */
    toCreateCoreDefinition() {
        return this.to('CreateCoreDefinition');
    }
    /**
     * Grants permission to create a version of an existing core definition. Greengrass groups must each contain exactly one Greengrass core
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/createcoredefinitionversion-post.html
     */
    toCreateCoreDefinitionVersion() {
        return this.to('CreateCoreDefinitionVersion');
    }
    /**
     * Grants permission to create a deployment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/createdeployment-post.html
     */
    toCreateDeployment() {
        return this.to('CreateDeployment');
    }
    /**
     * Grants permission to create a device definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/createdevicedefinition-post.html
     */
    toCreateDeviceDefinition() {
        return this.to('CreateDeviceDefinition');
    }
    /**
     * Grants permission to create a version of an existing device definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/createdevicedefinitionversion-post.html
     */
    toCreateDeviceDefinitionVersion() {
        return this.to('CreateDeviceDefinitionVersion');
    }
    /**
     * Grants permission to create a Lambda function definition to be used in a group that contains a list of Lambda functions and their configurations
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/createfunctiondefinition-post.html
     */
    toCreateFunctionDefinition() {
        return this.to('CreateFunctionDefinition');
    }
    /**
     * Grants permission to create a version of an existing Lambda function definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/createfunctiondefinitionversion-post.html
     */
    toCreateFunctionDefinitionVersion() {
        return this.to('CreateFunctionDefinitionVersion');
    }
    /**
     * Grants permission to create a group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/creategroup-post.html
     */
    toCreateGroup() {
        return this.to('CreateGroup');
    }
    /**
     * Grants permission to create a CA for the group, or rotate the existing CA
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/creategroupcertificateauthority-post.html
     */
    toCreateGroupCertificateAuthority() {
        return this.to('CreateGroupCertificateAuthority');
    }
    /**
     * Grants permission to create a version of a group that has already been defined
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/creategroupversion-post.html
     */
    toCreateGroupVersion() {
        return this.to('CreateGroupVersion');
    }
    /**
     * Grants permission to create a logger definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/createloggerdefinition-post.html
     */
    toCreateLoggerDefinition() {
        return this.to('CreateLoggerDefinition');
    }
    /**
     * Grants permission to create a version of an existing logger definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/createloggerdefinitionversion-post.html
     */
    toCreateLoggerDefinitionVersion() {
        return this.to('CreateLoggerDefinitionVersion');
    }
    /**
     * Grants permission to create a resource definition that contains a list of resources to be used in a group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/createresourcedefinition-post.html
     */
    toCreateResourceDefinition() {
        return this.to('CreateResourceDefinition');
    }
    /**
     * Grants permission to create a version of an existing resource definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/createresourcedefinitionversion-post.html
     */
    toCreateResourceDefinitionVersion() {
        return this.to('CreateResourceDefinitionVersion');
    }
    /**
     * Grants permission to create an AWS IoT job that will trigger your Greengrass cores to update the software they are running
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/createsoftwareupdatejob-post.html
     */
    toCreateSoftwareUpdateJob() {
        return this.to('CreateSoftwareUpdateJob');
    }
    /**
     * Grants permission to create a subscription definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/createsubscriptiondefinition-post.html
     */
    toCreateSubscriptionDefinition() {
        return this.to('CreateSubscriptionDefinition');
    }
    /**
     * Grants permission to create a version of an existing subscription definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/createsubscriptiondefinitionversion-post.html
     */
    toCreateSubscriptionDefinitionVersion() {
        return this.to('CreateSubscriptionDefinitionVersion');
    }
    /**
     * Grants permission to delete a connector definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/deleteconnectordefinition-delete.html
     */
    toDeleteConnectorDefinition() {
        return this.to('DeleteConnectorDefinition');
    }
    /**
     * Grants permission to delete a core definition. Deleting a definition that is currently in use in a deployment affects future deployments
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/deletecoredefinition-delete.html
     */
    toDeleteCoreDefinition() {
        return this.to('DeleteCoreDefinition');
    }
    /**
     * Grants permission to delete a device definition. Deleting a definition that is currently in use in a deployment affects future deployments
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/deletedevicedefinition-delete.html
     */
    toDeleteDeviceDefinition() {
        return this.to('DeleteDeviceDefinition');
    }
    /**
     * Grants permission to delete a Lambda function definition. Deleting a definition that is currently in use in a deployment affects future deployments
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/deletefunctiondefinition-delete.html
     */
    toDeleteFunctionDefinition() {
        return this.to('DeleteFunctionDefinition');
    }
    /**
     * Grants permission to delete a group that is not currently in use in a deployment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/deletegroup-delete.html
     */
    toDeleteGroup() {
        return this.to('DeleteGroup');
    }
    /**
     * Grants permission to delete a logger definition. Deleting a definition that is currently in use in a deployment affects future deployments
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/deleteloggerdefinition-delete.html
     */
    toDeleteLoggerDefinition() {
        return this.to('DeleteLoggerDefinition');
    }
    /**
     * Grants permission to delete a resource definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/deleteresourcedefinition-delete.html
     */
    toDeleteResourceDefinition() {
        return this.to('DeleteResourceDefinition');
    }
    /**
     * Grants permission to delete a subscription definition. Deleting a definition that is currently in use in a deployment affects future deployments
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/deletesubscriptiondefinition-delete.html
     */
    toDeleteSubscriptionDefinition() {
        return this.to('DeleteSubscriptionDefinition');
    }
    /**
     * Grants permission to disassociate the role from a group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/disassociaterolefromgroup-delete.html
     */
    toDisassociateRoleFromGroup() {
        return this.to('DisassociateRoleFromGroup');
    }
    /**
     * Grants permission to disassociate the service role from an account. Without a service role, deployments will not work
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/disassociateservicerolefromaccount-delete.html
     */
    toDisassociateServiceRoleFromAccount() {
        return this.to('DisassociateServiceRoleFromAccount');
    }
    /**
     * Grants permission to retrieve information required to connect to a Greengrass core
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/latest/developerguide/gg-discover-api.html
     */
    toDiscover() {
        return this.to('Discover');
    }
    /**
     * Grants permission to retrieve the role associated with a group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getassociatedrole-get.html
     */
    toGetAssociatedRole() {
        return this.to('GetAssociatedRole');
    }
    /**
     * Grants permission to return the status of a bulk deployment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getbulkdeploymentstatus-get.html
     */
    toGetBulkDeploymentStatus() {
        return this.to('GetBulkDeploymentStatus');
    }
    /**
     * Grants permission to retrieve the connectivity information for a core
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getconnectivityinfo-get.html
     */
    toGetConnectivityInfo() {
        return this.to('GetConnectivityInfo');
    }
    /**
     * Grants permission to retrieve information about a connector definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getconnectordefinition-get.html
     */
    toGetConnectorDefinition() {
        return this.to('GetConnectorDefinition');
    }
    /**
     * Grants permission to retrieve information about a connector definition version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getconnectordefinitionversion-get.html
     */
    toGetConnectorDefinitionVersion() {
        return this.to('GetConnectorDefinitionVersion');
    }
    /**
     * Grants permission to retrieve information about a core definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getcoredefinition-get.html
     */
    toGetCoreDefinition() {
        return this.to('GetCoreDefinition');
    }
    /**
     * Grants permission to retrieve information about a core definition version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getcoredefinitionversion-get.html
     */
    toGetCoreDefinitionVersion() {
        return this.to('GetCoreDefinitionVersion');
    }
    /**
     * Grants permission to return the status of a deployment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getdeploymentstatus-get.html
     */
    toGetDeploymentStatus() {
        return this.to('GetDeploymentStatus');
    }
    /**
     * Grants permission to retrieve information about a device definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getdevicedefinition-get.html
     */
    toGetDeviceDefinition() {
        return this.to('GetDeviceDefinition');
    }
    /**
     * Grants permission to retrieve information about a device definition version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getdevicedefinitionversion-get.html
     */
    toGetDeviceDefinitionVersion() {
        return this.to('GetDeviceDefinitionVersion');
    }
    /**
     * Grants permission to retrieve information about a Lambda function definition, such as its creation time and latest version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getfunctiondefinition-get.html
     */
    toGetFunctionDefinition() {
        return this.to('GetFunctionDefinition');
    }
    /**
     * Grants permission to retrieve information about a Lambda function definition version, such as which Lambda functions are included in the version and their configurations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getfunctiondefinitionversion-get.html
     */
    toGetFunctionDefinitionVersion() {
        return this.to('GetFunctionDefinitionVersion');
    }
    /**
     * Grants permission to retrieve information about a group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getgroup-get.html
     */
    toGetGroup() {
        return this.to('GetGroup');
    }
    /**
     * Grants permission to return the public key of the CA associated with a group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getgroupcertificateauthority-get.html
     */
    toGetGroupCertificateAuthority() {
        return this.to('GetGroupCertificateAuthority');
    }
    /**
     * Grants permission to retrieve the current configuration for the CA used by a group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getgroupcertificateconfiguration-get.html
     */
    toGetGroupCertificateConfiguration() {
        return this.to('GetGroupCertificateConfiguration');
    }
    /**
     * Grants permission to retrieve information about a group version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getgroupversion-get.html
     */
    toGetGroupVersion() {
        return this.to('GetGroupVersion');
    }
    /**
     * Grants permission to retrieve information about a logger definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getloggerdefinition-get.html
     */
    toGetLoggerDefinition() {
        return this.to('GetLoggerDefinition');
    }
    /**
     * Grants permission to retrieve information about a logger definition version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getloggerdefinitionversion-get.html
     */
    toGetLoggerDefinitionVersion() {
        return this.to('GetLoggerDefinitionVersion');
    }
    /**
     * Grants permission to retrieve information about a resource definition, such as its creation time and latest version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getresourcedefinition-get.html
     */
    toGetResourceDefinition() {
        return this.to('GetResourceDefinition');
    }
    /**
     * Grants permission to retrieve information about a resource definition version, such as which resources are included in the version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getresourcedefinitionversion-get.html
     */
    toGetResourceDefinitionVersion() {
        return this.to('GetResourceDefinitionVersion');
    }
    /**
     * Grants permission to retrieve the service role that is attached to an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getserviceroleforaccount-get.html
     */
    toGetServiceRoleForAccount() {
        return this.to('GetServiceRoleForAccount');
    }
    /**
     * Grants permission to retrieve information about a subscription definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getsubscriptiondefinition-get.html
     */
    toGetSubscriptionDefinition() {
        return this.to('GetSubscriptionDefinition');
    }
    /**
     * Grants permission to retrieve information about a subscription definition version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getsubscriptiondefinitionversion-get.html
     */
    toGetSubscriptionDefinitionVersion() {
        return this.to('GetSubscriptionDefinitionVersion');
    }
    /**
     * Grants permission to retrieve runtime configuration of a thing
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/getthingruntimeconfiguration-get.html
     */
    toGetThingRuntimeConfiguration() {
        return this.to('GetThingRuntimeConfiguration');
    }
    /**
     * Grants permission to retrieve a paginated list of the deployments that have been started in a bulk deployment operation and their current deployment status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listbulkdeploymentdetailedreports-get.html
     */
    toListBulkDeploymentDetailedReports() {
        return this.to('ListBulkDeploymentDetailedReports');
    }
    /**
     * Grants permission to retrieve a list of bulk deployments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listbulkdeployments-get.html
     */
    toListBulkDeployments() {
        return this.to('ListBulkDeployments');
    }
    /**
     * Grants permission to list the versions of a connector definition
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listconnectordefinitionversions-get.html
     */
    toListConnectorDefinitionVersions() {
        return this.to('ListConnectorDefinitionVersions');
    }
    /**
     * Grants permission to retrieve a list of connector definitions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listconnectordefinitions-get.html
     */
    toListConnectorDefinitions() {
        return this.to('ListConnectorDefinitions');
    }
    /**
     * Grants permission to list the versions of a core definition
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listcoredefinitionversions-get.html
     */
    toListCoreDefinitionVersions() {
        return this.to('ListCoreDefinitionVersions');
    }
    /**
     * Grants permission to retrieve a list of core definitions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listcoredefinitions-get.html
     */
    toListCoreDefinitions() {
        return this.to('ListCoreDefinitions');
    }
    /**
     * Grants permission to retrieve a list of all deployments for a group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listdeployments-get.html
     */
    toListDeployments() {
        return this.to('ListDeployments');
    }
    /**
     * Grants permission to list the versions of a device definition
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listdevicedefinitionversions-get.html
     */
    toListDeviceDefinitionVersions() {
        return this.to('ListDeviceDefinitionVersions');
    }
    /**
     * Grants permission to retrieve a list of device definitions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listdevicedefinitions-get.html
     */
    toListDeviceDefinitions() {
        return this.to('ListDeviceDefinitions');
    }
    /**
     * Grants permission to list the versions of a Lambda function definition
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listfunctiondefinitionversions-get.html
     */
    toListFunctionDefinitionVersions() {
        return this.to('ListFunctionDefinitionVersions');
    }
    /**
     * Grants permission to retrieve a list of Lambda function definitions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listfunctiondefinitions-get.html
     */
    toListFunctionDefinitions() {
        return this.to('ListFunctionDefinitions');
    }
    /**
     * Grants permission to retrieve a list of current CAs for a group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listgroupcertificateauthorities-get.html
     */
    toListGroupCertificateAuthorities() {
        return this.to('ListGroupCertificateAuthorities');
    }
    /**
     * Grants permission to list the versions of a group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listgroupversions-get.html
     */
    toListGroupVersions() {
        return this.to('ListGroupVersions');
    }
    /**
     * Grants permission to retrieve a list of groups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listgroups-get.html
     */
    toListGroups() {
        return this.to('ListGroups');
    }
    /**
     * Grants permission to list the versions of a logger definition
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listloggerdefinitionversions-get.html
     */
    toListLoggerDefinitionVersions() {
        return this.to('ListLoggerDefinitionVersions');
    }
    /**
     * Grants permission to retrieve a list of logger definitions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listloggerdefinitions-get.html
     */
    toListLoggerDefinitions() {
        return this.to('ListLoggerDefinitions');
    }
    /**
     * Grants permission to list the versions of a resource definition
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listresourcedefinitionversions-get.html
     */
    toListResourceDefinitionVersions() {
        return this.to('ListResourceDefinitionVersions');
    }
    /**
     * Grants permission to retrieve a list of resource definitions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listresourcedefinitions-get.html
     */
    toListResourceDefinitions() {
        return this.to('ListResourceDefinitions');
    }
    /**
     * Grants permission to list the versions of a subscription definition
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listsubscriptiondefinitionversions-get.html
     */
    toListSubscriptionDefinitionVersions() {
        return this.to('ListSubscriptionDefinitionVersions');
    }
    /**
     * Grants permission to retrieve a list of subscription definitions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listsubscriptiondefinitions-get.html
     */
    toListSubscriptionDefinitions() {
        return this.to('ListSubscriptionDefinitions');
    }
    /**
     * Grants permission to list the tags for a resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/listtagsforresource-get.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to reset a group's deployments
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/resetdeployments-post.html
     */
    toResetDeployments() {
        return this.to('ResetDeployments');
    }
    /**
     * Grants permission to deploy multiple groups in one operation
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/startbulkdeployment-post.html
     */
    toStartBulkDeployment() {
        return this.to('StartBulkDeployment');
    }
    /**
     * Grants permission to stop the execution of a bulk deployment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/stopbulkdeployment-put.html
     */
    toStopBulkDeployment() {
        return this.to('StopBulkDeployment');
    }
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/tagresource-post.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/untagresource-delete.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update the connectivity information for a Greengrass core. Any devices that belong to the group that has this core will receive this information in order to find the location of the core and connect to it
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/updateconnectivityinfo-put.html
     */
    toUpdateConnectivityInfo() {
        return this.to('UpdateConnectivityInfo');
    }
    /**
     * Grants permission to update a connector definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/updateconnectordefinition-put.html
     */
    toUpdateConnectorDefinition() {
        return this.to('UpdateConnectorDefinition');
    }
    /**
     * Grants permission to update a core definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/updatecoredefinition-put.html
     */
    toUpdateCoreDefinition() {
        return this.to('UpdateCoreDefinition');
    }
    /**
     * Grants permission to update a device definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/updatedevicedefinition-put.html
     */
    toUpdateDeviceDefinition() {
        return this.to('UpdateDeviceDefinition');
    }
    /**
     * Grants permission to update a Lambda function definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/updatefunctiondefinition-put.html
     */
    toUpdateFunctionDefinition() {
        return this.to('UpdateFunctionDefinition');
    }
    /**
     * Grants permission to update a group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/updategroup-put.html
     */
    toUpdateGroup() {
        return this.to('UpdateGroup');
    }
    /**
     * Grants permission to update the certificate expiry time for a group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/updategroupcertificateconfiguration-put.html
     */
    toUpdateGroupCertificateConfiguration() {
        return this.to('UpdateGroupCertificateConfiguration');
    }
    /**
     * Grants permission to update a logger definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/updateloggerdefinition-put.html
     */
    toUpdateLoggerDefinition() {
        return this.to('UpdateLoggerDefinition');
    }
    /**
     * Grants permission to update a resource definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/updateresourcedefinition-put.html
     */
    toUpdateResourceDefinition() {
        return this.to('UpdateResourceDefinition');
    }
    /**
     * Grants permission to update a subscription definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/updatesubscriptiondefinition-put.html
     */
    toUpdateSubscriptionDefinition() {
        return this.to('UpdateSubscriptionDefinition');
    }
    /**
     * Grants permission to update runtime configuration of a thing
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/updatethingruntimeconfiguration-put.html
     */
    toUpdateThingRuntimeConfiguration() {
        return this.to('UpdateThingRuntimeConfiguration');
    }
    /**
     * Adds a resource of type connectivityInfo to the statement
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/definitions-connectivityinfo.html
     *
     * @param thingName - Identifier for the thingName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onConnectivityInfo(thingName, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/things/${thingName}/connectivityInfo`);
    }
    /**
     * Adds a resource of type certificateAuthority to the statement
     *
     * https://docs.aws.amazon.com/greengrass/latest/developerguide/gg-sec.html
     *
     * @param groupId - Identifier for the groupId.
     * @param certificateAuthorityId - Identifier for the certificateAuthorityId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCertificateAuthority(groupId, certificateAuthorityId, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/groups/${groupId}/certificateauthorities/${certificateAuthorityId}`);
    }
    /**
     * Adds a resource of type deployment to the statement
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/definitions-createdeploymentrequest.html
     *
     * @param groupId - Identifier for the groupId.
     * @param deploymentId - Identifier for the deploymentId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDeployment(groupId, deploymentId, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/groups/${groupId}/deployments/${deploymentId}`);
    }
    /**
     * Adds a resource of type bulkDeployment to the statement
     *
     * https://docs.aws.amazon.com/greengrass/latest/developerguide/bulk-deploy-cli.html
     *
     * @param bulkDeploymentId - Identifier for the bulkDeploymentId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onBulkDeployment(bulkDeploymentId, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/bulk/deployments/${bulkDeploymentId}`);
    }
    /**
     * Adds a resource of type group to the statement
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/definitions-groupinformation.html
     *
     * @param groupId - Identifier for the groupId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onGroup(groupId, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/groups/${groupId}`);
    }
    /**
     * Adds a resource of type groupVersion to the statement
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/definitions-groupversion.html
     *
     * @param groupId - Identifier for the groupId.
     * @param versionId - Identifier for the versionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onGroupVersion(groupId, versionId, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/groups/${groupId}/versions/${versionId}`);
    }
    /**
     * Adds a resource of type coreDefinition to the statement
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/definitions-core.html
     *
     * @param coreDefinitionId - Identifier for the coreDefinitionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCoreDefinition(coreDefinitionId, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/definition/cores/${coreDefinitionId}`);
    }
    /**
     * Adds a resource of type coreDefinitionVersion to the statement
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/definitions-coredefinitionversion.html
     *
     * @param coreDefinitionId - Identifier for the coreDefinitionId.
     * @param versionId - Identifier for the versionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCoreDefinitionVersion(coreDefinitionId, versionId, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/definition/cores/${coreDefinitionId}/versions/${versionId}`);
    }
    /**
     * Adds a resource of type deviceDefinition to the statement
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/definitions-device.html
     *
     * @param deviceDefinitionId - Identifier for the deviceDefinitionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDeviceDefinition(deviceDefinitionId, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/definition/devices/${deviceDefinitionId}`);
    }
    /**
     * Adds a resource of type deviceDefinitionVersion to the statement
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/definitions-devicedefinitionversion.html
     *
     * @param deviceDefinitionId - Identifier for the deviceDefinitionId.
     * @param versionId - Identifier for the versionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDeviceDefinitionVersion(deviceDefinitionId, versionId, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/definition/devices/${deviceDefinitionId}/versions/${versionId}`);
    }
    /**
     * Adds a resource of type functionDefinition to the statement
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/definitions-function.html
     *
     * @param functionDefinitionId - Identifier for the functionDefinitionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFunctionDefinition(functionDefinitionId, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/definition/functions/${functionDefinitionId}`);
    }
    /**
     * Adds a resource of type functionDefinitionVersion to the statement
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/definitions-functiondefinitionversion.html
     *
     * @param functionDefinitionId - Identifier for the functionDefinitionId.
     * @param versionId - Identifier for the versionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onFunctionDefinitionVersion(functionDefinitionId, versionId, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/definition/functions/${functionDefinitionId}/versions/${versionId}`);
    }
    /**
     * Adds a resource of type subscriptionDefinition to the statement
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/definitions-subscription.html
     *
     * @param subscriptionDefinitionId - Identifier for the subscriptionDefinitionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSubscriptionDefinition(subscriptionDefinitionId, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/definition/subscriptions/${subscriptionDefinitionId}`);
    }
    /**
     * Adds a resource of type subscriptionDefinitionVersion to the statement
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/definitions-subscriptiondefinitionversion.html
     *
     * @param subscriptionDefinitionId - Identifier for the subscriptionDefinitionId.
     * @param versionId - Identifier for the versionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSubscriptionDefinitionVersion(subscriptionDefinitionId, versionId, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/definition/subscriptions/${subscriptionDefinitionId}/versions/${versionId}`);
    }
    /**
     * Adds a resource of type loggerDefinition to the statement
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/definitions-logger.html
     *
     * @param loggerDefinitionId - Identifier for the loggerDefinitionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLoggerDefinition(loggerDefinitionId, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/definition/loggers/${loggerDefinitionId}`);
    }
    /**
     * Adds a resource of type loggerDefinitionVersion to the statement
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/definitions-loggerdefinitionversion.html
     *
     * @param loggerDefinitionId - Identifier for the loggerDefinitionId.
     * @param versionId - Identifier for the versionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onLoggerDefinitionVersion(loggerDefinitionId, versionId, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/definition/loggers/${loggerDefinitionId}/versions/${versionId}`);
    }
    /**
     * Adds a resource of type resourceDefinition to the statement
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/definitions-resource.html
     *
     * @param resourceDefinitionId - Identifier for the resourceDefinitionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onResourceDefinition(resourceDefinitionId, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/definition/resources/${resourceDefinitionId}`);
    }
    /**
     * Adds a resource of type resourceDefinitionVersion to the statement
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/definitions-resourcedefinitionversion.html
     *
     * @param resourceDefinitionId - Identifier for the resourceDefinitionId.
     * @param versionId - Identifier for the versionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onResourceDefinitionVersion(resourceDefinitionId, versionId, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/definition/resources/${resourceDefinitionId}/versions/${versionId}`);
    }
    /**
     * Adds a resource of type connectorDefinition to the statement
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/definitions-connector.html
     *
     * @param connectorDefinitionId - Identifier for the connectorDefinitionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConnectorDefinition(connectorDefinitionId, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/definition/connectors/${connectorDefinitionId}`);
    }
    /**
     * Adds a resource of type connectorDefinitionVersion to the statement
     *
     * https://docs.aws.amazon.com/greengrass/v1/apireference/definitions-connectordefinitionversion.html
     *
     * @param connectorDefinitionId - Identifier for the connectorDefinitionId.
     * @param versionId - Identifier for the versionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onConnectorDefinitionVersion(connectorDefinitionId, versionId, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/definition/connectors/${connectorDefinitionId}/versions/${versionId}`);
    }
    /**
     * Adds a resource of type thing to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/thing-registry.html
     *
     * @param thingName - Identifier for the thingName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onThing(thingName, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:iot:${region || '*'}:${account || '*'}:thing/${thingName}`);
    }
    /**
     * Adds a resource of type thingRuntimeConfig to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/thing-registry.html
     *
     * @param thingName - Identifier for the thingName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onThingRuntimeConfig(thingName, account, region, partition) {
        return this.on(`arn:${partition || Greengrass.defaultPartition}:greengrass:${region || '*'}:${account || '*'}:/greengrass/things/${thingName}/runtimeconfig`);
    }
}
exports.Greengrass = Greengrass;
_a = JSII_RTTI_SYMBOL_1;
Greengrass[_a] = { fqn: "iam-floyd.Greengrass", version: "0.499.0" };
//# sourceMappingURL=data:application/json;base64,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