import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [kendra-ranking](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonkendraintelligentranking.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class KendraRanking extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [kendra-ranking](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonkendraintelligentranking.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a RescoreExecutionPlan
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_Ranking_CreateRescoreExecutionPlan.html
     */
    toCreateRescoreExecutionPlan(): this;
    /**
     * Grants permission to delete a RescoreExecutionPlan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_Ranking_DeleteRescoreExecutionPlan.html
     */
    toDeleteRescoreExecutionPlan(): this;
    /**
     * Grants permission to describe a RescoreExecutionPlan
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_Ranking_DescribeRescoreExecutionPlan.html
     */
    toDescribeRescoreExecutionPlan(): this;
    /**
     * Grants permission to list all RescoreExecutionPlans
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_Ranking_ListRescoreExecutionPlans.html
     */
    toListRescoreExecutionPlans(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_Ranking_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to Rescore documents with Kendra Intelligent Ranking
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_Ranking_Rescore.html
     */
    toRescore(): this;
    /**
     * Grants permission to tag a resource with given key value pairs
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_Ranking_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove the tag with the given key from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_Ranking_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a RescoreExecutionPlan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_Ranking_UpdateRescoreExecutionPlan.html
     */
    toUpdateRescoreExecutionPlan(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type rescore-execution-plan to the statement
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/search-service-rerank.html
     *
     * @param rescoreExecutionPlanId - Identifier for the rescoreExecutionPlanId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRescoreExecutionPlan(rescoreExecutionPlanId: string, account?: string, region?: string, partition?: string): this;
}
