"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mechanicalturk = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [mechanicalturk](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmechanicalturk.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Mechanicalturk extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [mechanicalturk](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmechanicalturk.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'mechanicalturk';
        this.accessLevelList = {
            Write: [
                'AcceptQualificationRequest',
                'ApproveAssignment',
                'AssociateQualificationWithWorker',
                'CreateAdditionalAssignmentsForHIT',
                'CreateHIT',
                'CreateHITType',
                'CreateHITWithHITType',
                'CreateQualificationType',
                'CreateWorkerBlock',
                'DeleteHIT',
                'DeleteQualificationType',
                'DeleteWorkerBlock',
                'DisassociateQualificationFromWorker',
                'NotifyWorkers',
                'RejectAssignment',
                'RejectQualificationRequest',
                'SendBonus',
                'SendTestEventNotification',
                'UpdateExpirationForHIT',
                'UpdateHITReviewStatus',
                'UpdateHITTypeOfHIT',
                'UpdateNotificationSettings',
                'UpdateQualificationType'
            ],
            Read: [
                'GetAccountBalance',
                'GetAssignment',
                'GetFileUploadURL',
                'GetHIT',
                'GetQualificationScore',
                'GetQualificationType'
            ],
            List: [
                'ListAssignmentsForHIT',
                'ListBonusPayments',
                'ListHITs',
                'ListHITsForQualificationType',
                'ListQualificationRequests',
                'ListQualificationTypes',
                'ListReviewPolicyResultsForHIT',
                'ListReviewableHITs',
                'ListWorkerBlocks',
                'ListWorkersWithQualificationType'
            ]
        };
    }
    /**
     * The AcceptQualificationRequest operation grants a Worker's request for a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AcceptQualificationRequestOperation.html
     */
    toAcceptQualificationRequest() {
        return this.to('AcceptQualificationRequest');
    }
    /**
     * The ApproveAssignment operation approves the results of a completed assignment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ApproveAssignmentOperation.html
     */
    toApproveAssignment() {
        return this.to('ApproveAssignment');
    }
    /**
     * The AssociateQualificationWithWorker operation gives a Worker a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AssociateQualificationWithWorkerOperation.html
     */
    toAssociateQualificationWithWorker() {
        return this.to('AssociateQualificationWithWorker');
    }
    /**
     * The CreateAdditionalAssignmentsForHIT operation increases the maximum number of assignments of an existing HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateAdditionalAssignmentsForHITOperation.html
     */
    toCreateAdditionalAssignmentsForHIT() {
        return this.to('CreateAdditionalAssignmentsForHIT');
    }
    /**
     * The CreateHIT operation creates a new HIT (Human Intelligence Task)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITOperation.html
     */
    toCreateHIT() {
        return this.to('CreateHIT');
    }
    /**
     * The CreateHITType operation creates a new HIT type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITTypeOperation.html
     */
    toCreateHITType() {
        return this.to('CreateHITType');
    }
    /**
     * The CreateHITWithHITType operation creates a new Human Intelligence Task (HIT) using an existing HITTypeID generated by the CreateHITType operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITWithHITTypeOperation.html
     */
    toCreateHITWithHITType() {
        return this.to('CreateHITWithHITType');
    }
    /**
     * The CreateQualificationType operation creates a new Qualification type, which is represented by a QualificationType data structure
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateQualificationTypeOperation.html
     */
    toCreateQualificationType() {
        return this.to('CreateQualificationType');
    }
    /**
     * The CreateWorkerBlock operation allows you to prevent a Worker from working on your HITs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateWorkerBlockOperation.html
     */
    toCreateWorkerBlock() {
        return this.to('CreateWorkerBlock');
    }
    /**
     * The DeleteHIT operation disposes of a HIT that is no longer needed
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteHITOperation.html
     */
    toDeleteHIT() {
        return this.to('DeleteHIT');
    }
    /**
     * The DeleteQualificationType disposes a Qualification type and disposes any HIT types that are associated with the Qualification type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteQualificationTypeOperation.html
     */
    toDeleteQualificationType() {
        return this.to('DeleteQualificationType');
    }
    /**
     * The DeleteWorkerBlock operation allows you to reinstate a blocked Worker to work on your HITs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteWorkerBlockOperation.html
     */
    toDeleteWorkerBlock() {
        return this.to('DeleteWorkerBlock');
    }
    /**
     * The DisassociateQualificationFromWorker revokes a previously granted Qualification from a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DisassociateQualificationFromWorkerOperation.html
     */
    toDisassociateQualificationFromWorker() {
        return this.to('DisassociateQualificationFromWorker');
    }
    /**
     * The GetAccountBalance operation retrieves the amount of money in your Amazon Mechanical Turk account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAccountBalanceOperation.html
     */
    toGetAccountBalance() {
        return this.to('GetAccountBalance');
    }
    /**
     * The GetAssignment retrieves an assignment with an AssignmentStatus value of Submitted, Approved, or Rejected, using the assignment's ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAssignmentOperation.html
     */
    toGetAssignment() {
        return this.to('GetAssignment');
    }
    /**
     * The GetFileUploadURL operation generates and returns a temporary URL
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetFileUploadURLOperation.html
     */
    toGetFileUploadURL() {
        return this.to('GetFileUploadURL');
    }
    /**
     * The GetHIT operation retrieves the details of the specified HIT
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetHITOperation.html
     */
    toGetHIT() {
        return this.to('GetHIT');
    }
    /**
     * The GetQualificationScore operation returns the value of a Worker's Qualification for a given Qualification type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationScoreOperation.html
     */
    toGetQualificationScore() {
        return this.to('GetQualificationScore');
    }
    /**
     * The GetQualificationType operation retrieves information about a Qualification type using its ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationTypeOperation.html
     */
    toGetQualificationType() {
        return this.to('GetQualificationType');
    }
    /**
     * The ListAssignmentsForHIT operation retrieves completed assignments for a HIT
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListAssignmentsForHITOperation.html
     */
    toListAssignmentsForHIT() {
        return this.to('ListAssignmentsForHIT');
    }
    /**
     * The ListBonusPayments operation retrieves the amounts of bonuses you have paid to Workers for a given HIT or assignment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListBonusPaymentsOperation.html
     */
    toListBonusPayments() {
        return this.to('ListBonusPayments');
    }
    /**
     * The ListHITs operation returns all of a Requester's HITs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsOperation.html
     */
    toListHITs() {
        return this.to('ListHITs');
    }
    /**
     * The ListHITsForQualificationType operation returns the HITs that use the given QualififcationType for a QualificationRequirement
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsForQualificationTypeOperation.html
     */
    toListHITsForQualificationType() {
        return this.to('ListHITsForQualificationType');
    }
    /**
     * The ListQualificationRequests operation retrieves requests for Qualifications of a particular Qualification type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationRequestsOperation.html
     */
    toListQualificationRequests() {
        return this.to('ListQualificationRequests');
    }
    /**
     * The ListQualificationTypes operation searches for Qualification types using the specified search query, and returns a list of Qualification types
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationTypesOperation.html
     */
    toListQualificationTypes() {
        return this.to('ListQualificationTypes');
    }
    /**
     * The ListReviewPolicyResultsForHIT operation retrieves the computed results and the actions taken in the course of executing your Review Policies during a CreateHIT operation
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewPolicyResultsForHITOperation.html
     */
    toListReviewPolicyResultsForHIT() {
        return this.to('ListReviewPolicyResultsForHIT');
    }
    /**
     * The ListReviewableHITs operation returns all of a Requester's HITs that have not been approved or rejected
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewableHITsOperation.html
     */
    toListReviewableHITs() {
        return this.to('ListReviewableHITs');
    }
    /**
     * The ListWorkersBlocks operation retrieves a list of Workers who are blocked from working on your HITs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkerBlocksOperation.html
     */
    toListWorkerBlocks() {
        return this.to('ListWorkerBlocks');
    }
    /**
     * The ListWorkersWithQualificationType operation returns all of the Workers with a given Qualification type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkersWithQualificationTypeOperation.html
     */
    toListWorkersWithQualificationType() {
        return this.to('ListWorkersWithQualificationType');
    }
    /**
     * The NotifyWorkers operation sends an email to one or more Workers that you specify with the Worker ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_NotifyWorkersOperation.html
     */
    toNotifyWorkers() {
        return this.to('NotifyWorkers');
    }
    /**
     * The RejectAssignment operation rejects the results of a completed assignment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectAssignmentOperation.html
     */
    toRejectAssignment() {
        return this.to('RejectAssignment');
    }
    /**
     * The RejectQualificationRequest operation rejects a user's request for a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectQualificationRequestOperation.html
     */
    toRejectQualificationRequest() {
        return this.to('RejectQualificationRequest');
    }
    /**
     * The SendBonus operation issues a payment of money from your account to a Worker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendBonusOperation.html
     */
    toSendBonus() {
        return this.to('SendBonus');
    }
    /**
     * The SendTestEventNotification operation causes Amazon Mechanical Turk to send a notification message as if a HIT event occurred, according to the provided notification specification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendTestEventNotificationOperation.html
     */
    toSendTestEventNotification() {
        return this.to('SendTestEventNotification');
    }
    /**
     * The UpdateExpirationForHIT operation allows you extend the expiration time of a HIT beyond is current expiration or expire a HIT immediately
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateExpirationForHITOperation.html
     */
    toUpdateExpirationForHIT() {
        return this.to('UpdateExpirationForHIT');
    }
    /**
     * The UpdateHITReviewStatus operation toggles the status of a HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITReviewStatusOperation.html
     */
    toUpdateHITReviewStatus() {
        return this.to('UpdateHITReviewStatus');
    }
    /**
     * The UpdateHITTypeOfHIT operation allows you to change the HITType properties of a HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITTypeOfHITOperation.html
     */
    toUpdateHITTypeOfHIT() {
        return this.to('UpdateHITTypeOfHIT');
    }
    /**
     * The UpdateNotificationSettings operation creates, updates, disables or re-enables notifications for a HIT type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateNotificationSettingsOperation.html
     */
    toUpdateNotificationSettings() {
        return this.to('UpdateNotificationSettings');
    }
    /**
     * The UpdateQualificationType operation modifies the attributes of an existing Qualification type, which is represented by a QualificationType data structure
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateQualificationTypeOperation.html
     */
    toUpdateQualificationType() {
        return this.to('UpdateQualificationType');
    }
}
exports.Mechanicalturk = Mechanicalturk;
_a = JSII_RTTI_SYMBOL_1;
Mechanicalturk[_a] = { fqn: "iam-floyd.Mechanicalturk", version: "0.499.0" };
//# sourceMappingURL=data:application/json;base64,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