import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [aoss](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonopensearchserverless.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Aoss extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [aoss](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonopensearchserverless.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to get attributes for one or more collections
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_BatchGetCollection.html
     */
    toBatchGetCollection(): this;
    /**
     * Grants permission to get attributes for one or more VPC endpoints
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_BatchGetVpcEndpoint.html
     */
    toBatchGetVpcEndpoint(): this;
    /**
     * Grants permission to create a data access policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_CreateAccessPolicy.html
     */
    toCreateAccessPolicy(): this;
    /**
     * Grants permission to create a serverless collection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_CreateCollection.html
     */
    toCreateCollection(): this;
    /**
     * Grants permission to create a serverless security configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_CreateSecurityConfig.html
     */
    toCreateSecurityConfig(): this;
    /**
     * Grants permission to create a network or encryption policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_CreateSecurityPolicy.html
     */
    toCreateSecurityPolicy(): this;
    /**
     * Grants permission to create an OpenSearch-Serverless-managed interface VPC endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_CreateVpcEndpoint.html
     */
    toCreateVpcEndpoint(): this;
    /**
     * Grants permission to delete a data access policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_DeleteAccessPolicy.html
     */
    toDeleteAccessPolicy(): this;
    /**
     * Grants permission to delete a serverless collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_DeleteCollection.html
     */
    toDeleteCollection(): this;
    /**
     * Grants permission to delete a security configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_DeleteSecurityConfig.html
     */
    toDeleteSecurityConfig(): this;
    /**
     * Grants permission to delete a security policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_DeleteSecurityPolicy.html
     */
    toDeleteSecurityPolicy(): this;
    /**
     * Grants permission to delete an OpenSearch Serverless-managed interface VPC endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_DeleteVpcEndpoint.html
     */
    toDeleteVpcEndpoint(): this;
    /**
     * Grants permission to get information about a data access policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_GetAccessPolicy.html
     */
    toGetAccessPolicy(): this;
    /**
     * Grants permission to get account settings, including capacity settings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_GetAccountSettings.html
     */
    toGetAccountSettings(): this;
    /**
     * Grants permission to get statistis about the security policies in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_GetPoliciesStats.html
     */
    toGetPoliciesStats(): this;
    /**
     * Grants permission to get information about a serverless security configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_GetSecurityConfig.html
     */
    toGetSecurityConfig(): this;
    /**
     * Grants permission to get information about a security policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_GetSecurityPolicy.html
     */
    toGetSecurityPolicy(): this;
    /**
     * Grants permission to list data access policies
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_ListAccessPolicies.html
     */
    toListAccessPolicies(): this;
    /**
     * Grants permission to list collections
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_ListCollections.html
     */
    toListCollections(): this;
    /**
     * Grants permission to list security configurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_ListSecurityConfigs.html
     */
    toListSecurityConfigs(): this;
    /**
     * Grants permission to list security policies
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_ListSecurityPolicies.html
     */
    toListSecurityPolicies(): this;
    /**
     * Grants permission to list tags for a collection
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list OpenSearch Serverless-managed VPC endpoints
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_ListVpcEndpoints.html
     */
    toListVpcEndpoints(): this;
    /**
     * Grants permission to tag a serverless collection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a collection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a data access policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_UpdateAccessPolicy.html
     */
    toUpdateAccessPolicy(): this;
    /**
     * Grants permission to update account settings, including capacity settings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_UpdateAccountSettings.html
     */
    toUpdateAccountSettings(): this;
    /**
     * Grants permission to update a collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_UpdateCollection.html
     */
    toUpdateCollection(): this;
    /**
     * Grants permission to update a security configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_UpdateSecurityConfig.html
     */
    toUpdateSecurityConfig(): this;
    /**
     * Grants permission to update a security policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_UpdateSecurityPolicy.html
     */
    toUpdateSecurityPolicy(): this;
    /**
     * Grants permission to update an OpenSearch Serverless-managed VPC endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_UpdateVpcEndpoint.html
     */
    toUpdateVpcEndpoint(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type Collection to the statement
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-overview.html
     *
     * @param collectionId - Identifier for the collectionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCollection(collectionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the identifier of the collection
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/security-iam-serverless.html#security_iam_serverless-conditionkeys
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCollectionId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the collection name
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/security-iam-serverless.html#security_iam_serverless-conditionkeys
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCollection(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the index
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/security-iam-serverless.html#security_iam_serverless-conditionkeys
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifIndex(value: string | string[], operator?: Operator | string): this;
}
