import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [payments](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspayments.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Payments extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [payments](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awspayments.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a payment instrument
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toCreatePaymentInstrument(): this;
    /**
     * Grants permission to delete a payment instrument
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toDeletePaymentInstrument(): this;
    /**
     * Grants permission to get information about a payment instrument
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toGetPaymentInstrument(): this;
    /**
     * Grants permission to get payment status of invoices
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toGetPaymentStatus(): this;
    /**
     * Grants permission to get payment preferences (preferred payment currency, preferred payment method, etc.)
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toListPaymentPreferences(): this;
    /**
     * Grants permission to make a payment, authenticate a payment, verify a payment method, and generate a funding request document for Advance Pay
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toMakePayment(): this;
    /**
     * Grants permission to update payment preferences (preferred payment currency, preferred payment method, etc.)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toUpdatePaymentPreferences(): this;
    protected accessLevelList: AccessLevelList;
}
