import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [rekognition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrekognition.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Rekognition extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [rekognition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrekognition.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to compare faces in the source input image with each face detected in the target input image
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CompareFaces.html
     */
    toCompareFaces(): this;
    /**
     * Grants permission to copy an existing model version to a new model version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CopyProjectVersion.html
     */
    toCopyProjectVersion(): this;
    /**
     * Grants permission to create a collection in an AWS Region
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateCollection.html
     */
    toCreateCollection(): this;
    /**
     * Grants permission to create a new Amazon Rekognition Custom Labels dataset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateDataset.html
     */
    toCreateDataset(): this;
    /**
     * Grants permission to create an Amazon Rekognition Custom Labels project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateProject.html
     */
    toCreateProject(): this;
    /**
     * Grants permission to begin training a new version of a model
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateProjectVersion.html
     */
    toCreateProjectVersion(): this;
    /**
     * Grants permission to create an Amazon Rekognition stream processor
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateStreamProcessor.html
     */
    toCreateStreamProcessor(): this;
    /**
     * Grants permission to delete the specified collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DeleteCollection.html
     */
    toDeleteCollection(): this;
    /**
     * Grants permission to delete an existing Amazon Rekognition Custom Labels dataset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DeleteDataset.html
     */
    toDeleteDataset(): this;
    /**
     * Grants permission to delete faces from a collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DeleteFaces.html
     */
    toDeleteFaces(): this;
    /**
     * Grants permission to delete a project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DeleteProject.html
     */
    toDeleteProject(): this;
    /**
     * Grants permission to delete a resource policy attached to a project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DeleteProjectPolicy.html
     */
    toDeleteProjectPolicy(): this;
    /**
     * Grants permission to delete a model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DeleteProjectVersion.html
     */
    toDeleteProjectVersion(): this;
    /**
     * Grants permission to delete the specified stream processor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DeleteStreamProcessor.html
     */
    toDeleteStreamProcessor(): this;
    /**
     * Grants permission to read details about a collection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DescribeCollection.html
     */
    toDescribeCollection(): this;
    /**
     * Grants permission to describe an Amazon Rekognition Custom Labels dataset
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DescribeDataset.html
     */
    toDescribeDataset(): this;
    /**
     * Grants permission to list the versions of a model in an Amazon Rekognition Custom Labels project
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DescribeProjectVersions.html
     */
    toDescribeProjectVersions(): this;
    /**
     * Grants permission to list Amazon Rekognition Custom Labels projects
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DescribeProjects.html
     */
    toDescribeProjects(): this;
    /**
     * Grants permission to get information about the specified stream processor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DescribeStreamProcessor.html
     */
    toDescribeStreamProcessor(): this;
    /**
     * Grants permission to detect custom labels in a supplied image
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DetectCustomLabels.html
     */
    toDetectCustomLabels(): this;
    /**
     * Grants permission to detect human faces within an image provided as input
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DetectFaces.html
     */
    toDetectFaces(): this;
    /**
     * Grants permission to detect instances of real-world labels within an image provided as input
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DetectLabels.html
     */
    toDetectLabels(): this;
    /**
     * Grants permission to detect moderation labels within the input image
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DetectModerationLabels.html
     */
    toDetectModerationLabels(): this;
    /**
     * Grants permission to detect Personal Protective Equipment in the input image
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DetectProtectiveEquipment.html
     */
    toDetectProtectiveEquipment(): this;
    /**
     * Grants permission to detect text in the input image and convert it into machine-readable text
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DetectText.html
     */
    toDetectText(): this;
    /**
     * Grants permission to distribute the entries in a training dataset across the training dataset and the test dataset for a project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_DistributeDatasetEntries.html
     */
    toDistributeDatasetEntries(): this;
    /**
     * Grants permission to read the name, and additional information, of a celebrity
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_GetCelebrityInfo.html
     */
    toGetCelebrityInfo(): this;
    /**
     * Grants permission to read the celebrity recognition results found in a stored video by an asynchronous celebrity recognition job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_GetCelebrityRecognition.html
     */
    toGetCelebrityRecognition(): this;
    /**
     * Grants permission to read the content moderation analysis results found in a stored video by an asynchronous content moderation job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_GetContentModeration.html
     */
    toGetContentModeration(): this;
    /**
     * Grants permission to read the faces detection results found in a stored video by an asynchronous face detection job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_GetFaceDetection.html
     */
    toGetFaceDetection(): this;
    /**
     * Grants permission to read the matching collection faces found in a stored video by an asynchronous face search job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_GetFaceSearch.html
     */
    toGetFaceSearch(): this;
    /**
     * Grants permission to read the label detected resuls found in a stored video by an asynchronous label detection job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_GetLabelDetection.html
     */
    toGetLabelDetection(): this;
    /**
     * Grants permission to read the list of persons detected in a stored video by an asynchronous person tracking job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_GetPersonTracking.html
     */
    toGetPersonTracking(): this;
    /**
     * Grants permission to get the vdeo segments found in a stored video by an asynchronous segment detection job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_GetSegmentDetection.html
     */
    toGetSegmentDetection(): this;
    /**
     * Grants permission to get the text found in a stored video by an asynchronous text detection job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_GetTextDetection.html
     */
    toGetTextDetection(): this;
    /**
     * Grants permission to update an existing collection with faces detected in the input image
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_IndexFaces.html
     */
    toIndexFaces(): this;
    /**
     * Grants permission to read the collection Id's in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_ListCollections.html
     */
    toListCollections(): this;
    /**
     * Grants permission to list the dataset entries in an existing Amazon Rekognition Custom Labels dataset
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_ListDatasetEntries.html
     */
    toListDatasetEntries(): this;
    /**
     * Grants permission to list the labels in a dataset
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_ListDatasetLabels.html
     */
    toListDatasetLabels(): this;
    /**
     * Grants permission to read metadata for faces in the specificed collection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_ListFaces.html
     */
    toListFaces(): this;
    /**
     * Grants permission to list the resource policies attached to a project
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_ListProjectPolicies.html
     */
    toListProjectPolicies(): this;
    /**
     * Grants permission to get a list of your stream processors
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_ListStreamProcessors.html
     */
    toListStreamProcessors(): this;
    /**
     * Grants permission to return a list of tags associated with a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to attach a resource policy to a project
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_PutProjectPolicy.html
     */
    toPutProjectPolicy(): this;
    /**
     * Grants permission to detect celebrities in the input image
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_RecognizeCelebrities.html
     */
    toRecognizeCelebrities(): this;
    /**
     * Grants permission to search the specificed collection for the supplied face ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_SearchFaces.html
     */
    toSearchFaces(): this;
    /**
     * Grants permission to search the specificed collection for the largest face in the input image
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_SearchFacesByImage.html
     */
    toSearchFacesByImage(): this;
    /**
     * Grants permission to start the asynchronous recognition of celebrities in a stored video
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StartCelebrityRecognition.html
     */
    toStartCelebrityRecognition(): this;
    /**
     * Grants permission to start asynchronous detection of explicit or suggestive adult content in a stored video
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StartContentModeration.html
     */
    toStartContentModeration(): this;
    /**
     * Grants permission to start asynchronous detection of faces in a stored video
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StartFaceDetection.html
     */
    toStartFaceDetection(): this;
    /**
     * Grants permission to start an asynchronous search for faces in a collection that match the faces of persons detected in a stored video
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StartFaceSearch.html
     */
    toStartFaceSearch(): this;
    /**
     * Grants permission to start asynchronous detection of labels in a stored video
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StartLabelDetection.html
     */
    toStartLabelDetection(): this;
    /**
     * Grants permission to start the asynchronous tracking of persons in a stored video
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StartPersonTracking.html
     */
    toStartPersonTracking(): this;
    /**
     * Grants permission to start running a model version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StartProjectVersion.html
     */
    toStartProjectVersion(): this;
    /**
     * Grants permission to start the asynchronous detection of segments in a stored video
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StartSegmentDetection.html
     */
    toStartSegmentDetection(): this;
    /**
     * Grants permission to start running a stream processor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StartStreamProcessor.html
     */
    toStartStreamProcessor(): this;
    /**
     * Grants permission to start the asynchronous detection of text in a stored video
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StartTextDetection.html
     */
    toStartTextDetection(): this;
    /**
     * Grants permission to stop a running model version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StopProjectVersion.html
     */
    toStopProjectVersion(): this;
    /**
     * Grants permission to stop a running stream processor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_StopStreamProcessor.html
     */
    toStopStreamProcessor(): this;
    /**
     * Grants permission to add one or more tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove one or more tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to add or update one or more JSON Lines (entries) in a dataset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_UpdateDatasetEntries.html
     */
    toUpdateDatasetEntries(): this;
    /**
     * Grants permission to modify properties for a stream processor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rekognition/latest/APIReference/API_UpdateStreamProcessor.html
     */
    toUpdateStreamProcessor(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type collection to the statement
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/collections.html
     *
     * @param collectionId - Identifier for the collectionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCollection(collectionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type streamprocessor to the statement
     *
     * https://docs.aws.amazon.com/rekognition/latest/dg/streaming-video.html
     *
     * @param streamprocessorId - Identifier for the streamprocessorId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onStreamprocessor(streamprocessorId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type project to the statement
     *
     * https://docs.aws.amazon.com/rekognition/latest/customlabels-dg/mp-create-project.html
     *
     * @param projectName - Identifier for the projectName.
     * @param creationTimestamp - Identifier for the creationTimestamp.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onProject(projectName: string, creationTimestamp: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type projectversion to the statement
     *
     * https://docs.aws.amazon.com/rekognition/latest/customlabels-dg/training-model.html
     *
     * @param projectName - Identifier for the projectName.
     * @param versionName - Identifier for the versionName.
     * @param creationTimestamp - Identifier for the creationTimestamp.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProjectversion(projectName: string, versionName: string, creationTimestamp: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type dataset to the statement
     *
     * https://docs.aws.amazon.com/rekognition/latest/customlabels-dg/creating-datasets.html
     *
     * @param projectName - Identifier for the projectName.
     * @param datasetType - Identifier for the datasetType.
     * @param creationTimestamp - Identifier for the creationTimestamp.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDataset(projectName: string, datasetType: string, creationTimestamp: string, account?: string, region?: string, partition?: string): this;
}
