import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [scn](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Scn extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [scn](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to add AWS Supply Chain administrator permission to federated user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toAssignAdminPermissionsToUser(): this;
    /**
     * Grants permission to create a new AWS Supply Chain instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toCreateInstance(): this;
    /**
     * Grants permission to create IAM Identity Center application for a AWS Supply Chain instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toCreateSSOApplication(): this;
    /**
     * Grants permission to delete an AWS Supply Chain instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toDeleteInstance(): this;
    /**
     * Grants permission to delete IAM Identity Center application of the AWS Supply Chain instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toDeleteSSOApplication(): this;
    /**
     * Grants permission to view details of an AWS Supply Chain instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toDescribeInstance(): this;
    /**
     * Grants permission to list AWS Supply Chain administrators of an instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toListAdminUsers(): this;
    /**
     * Grants permission to view the AWS Supply Chain instances associated with an AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toListInstances(): this;
    /**
     * Grants permission to remove AWS Supply Chain administrator permission from federated user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toRemoveAdminPermissionsForUser(): this;
    /**
     * Grants permission to update an AWS Supply Chain instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toUpdateInstance(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type instance to the statement
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onInstance(instanceId: string, account?: string, region?: string, partition?: string): this;
}
