# vag
Web-API für Echtzeitinformationen der VAG Nürnberg

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v1
- Package version: 0.1.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

```sh
pip install deutschland[vag]
```

### poetry install

```sh
poetry add deutschland -E vag
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

## Usage

Import the package:
```python
from deutschland import vag
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
from deutschland import vag
from pprint import pprint
from deutschland.vag.api import abfahrten_api
from deutschland.vag.model.abfahrten_api_response import AbfahrtenAPIResponse
# Defining the host is optional and defaults to https://start.vag.de/dm
# See configuration.py for a list of all supported configuration parameters.
configuration = vag.Configuration(
    host = "https://start.vag.de/dm"
)



# Enter a context with an instance of the API client
with vag.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = abfahrten_api.AbfahrtenApi(api_client)
    netvu = "netvu_example" # str | Netz des Verkehrsunternehmen, aktuell \"VAG\" oder \"VGN\"
    haltid = "haltid_example" # str | Haltestellenkennung je nach NetVU - VGN-Kennung oder die HaltID der VAG
    product = "product_example" # str | Betriebszweig der VAG Bus, Tram, UBahn, SBahn, RBahn. Querystring: product=Bus,Tram (optional)
    timespan = 1 # int | Zeitfenster für die Abfrage in Minuten (?timespan=10) (optional)
    timedelay = 1 # int | Zeitliche Verschiebung für die Anfrage in Minuten (?timedelay=5) (optional)
    limitcount = 1 # int | Maximale Anzahl der zurückgelieferten Abfahrten (optional)

    try:
        # Liefert die Abfahrten zu einer bestimmten Haltestelle
        api_response = api_instance.abfahrten_get1(netvu, haltid, product=product, timespan=timespan, timedelay=timedelay, limitcount=limitcount)
        pprint(api_response)
    except vag.ApiException as e:
        print("Exception when calling AbfahrtenApi->abfahrten_get1: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://start.vag.de/dm*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AbfahrtenApi* | [**abfahrten_get1**](docs/AbfahrtenApi.md#abfahrten_get1) | **GET** /api/v1/abfahrten/{netvu}/{haltid} | Liefert die Abfahrten zu einer bestimmten Haltestelle
*AbfahrtenApi* | [**abfahrten_get2**](docs/AbfahrtenApi.md#abfahrten_get2) | **GET** /api/v1/abfahrten/{netvu}/{haltid}/{line} | Liefert die Abfahrten zu einer bestimmten Haltestelle
*FahrtenApi* | [**fahrten_get**](docs/FahrtenApi.md#fahrten_get) | **GET** /api/v1/fahrten/{betriebszweig} | Liefert alle laufenden und startenden Fahrten zu dem angegebenen Betriebszweig innerhalb des angegebenen Zeitfenster.
*FahrtenApi* | [**fahrten_get_fahrt1**](docs/FahrtenApi.md#fahrten_get_fahrt1) | **GET** /api/v1/fahrten/{betriebszweig}/{fahrtnummer} | Liefert die Fahrt des angegebenen Betriebszweig mit der Fahrtnummer und dem aktuellen Betriebstag
*FahrtenApi* | [**fahrten_get_fahrt2**](docs/FahrtenApi.md#fahrten_get_fahrt2) | **GET** /api/v1/fahrten/{betriebszweig}/{betriebstag}/{fahrtnummer} | Liefert die Fahrt des angegebenen Betriebszweig mit der Fahrtnummer und dem angegebenen Betriebstag
*HaltestellenApi* | [**haltestellen_get_by_location**](docs/HaltestellenApi.md#haltestellen_get_by_location) | **GET** /api/v1/haltestellen/{netvu}/location | Liefert die Liste mit den Haltestellen zu der Umkreissuche
*HaltestellenApi* | [**haltestellen_get_by_name**](docs/HaltestellenApi.md#haltestellen_get_by_name) | **GET** /api/v1/haltestellen/{netvu} | Liefert die Liste mit den Haltestellen zu dem angegebenen Haltestellenname (Optional)


## Documentation For Models

 - [AbfahrtDto](docs/AbfahrtDto.md)
 - [AbfahrtenAPIResponse](docs/AbfahrtenAPIResponse.md)
 - [FahrtDto](docs/FahrtDto.md)
 - [FahrtenAPIResponse](docs/FahrtenAPIResponse.md)
 - [FahrwegHaltepositionDto](docs/FahrwegHaltepositionDto.md)
 - [HaltestelleDto](docs/HaltestelleDto.md)
 - [HaltestellenAPIResponse](docs/HaltestellenAPIResponse.md)
 - [Metadata](docs/Metadata.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

kontakt@bund.dev


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in vag.apis and vag.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from deutschland.vag.api.default_api import DefaultApi`
- `from deutschland.vag.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
from deutschland import vag
from deutschland.vag.apis import *
from deutschland.vag.models import *
```

