"""
    VAG API

    Web-API für Echtzeitinformationen der VAG Nürnberg  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: kontakt@bund.dev
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from deutschland.vag.api_client import ApiClient
from deutschland.vag.api_client import Endpoint as _Endpoint
from deutschland.vag.model.haltestellen_api_response import HaltestellenAPIResponse
from deutschland.vag.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)


class HaltestellenApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.haltestellen_get_by_location_endpoint = _Endpoint(
            settings={
                "response_type": (HaltestellenAPIResponse,),
                "auth": [],
                "endpoint_path": "/api/v1/haltestellen/{netvu}/location",
                "operation_id": "haltestellen_get_by_location",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "netvu",
                    "lon",
                    "lat",
                    "radius",
                ],
                "required": [
                    "netvu",
                    "lon",
                    "lat",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "netvu": (str,),
                    "lon": (float,),
                    "lat": (float,),
                    "radius": (int,),
                },
                "attribute_map": {
                    "netvu": "netvu",
                    "lon": "lon",
                    "lat": "lat",
                    "radius": "radius",
                },
                "location_map": {
                    "netvu": "path",
                    "lon": "query",
                    "lat": "query",
                    "radius": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": [
                    "application/json",
                    "text/json",
                    "application/xml",
                    "text/xml",
                ],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.haltestellen_get_by_name_endpoint = _Endpoint(
            settings={
                "response_type": (HaltestellenAPIResponse,),
                "auth": [],
                "endpoint_path": "/api/v1/haltestellen/{netvu}",
                "operation_id": "haltestellen_get_by_name",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "netvu",
                    "name",
                ],
                "required": [
                    "netvu",
                    "name",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "netvu": (str,),
                    "name": (str,),
                },
                "attribute_map": {
                    "netvu": "netvu",
                    "name": "name",
                },
                "location_map": {
                    "netvu": "path",
                    "name": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": [
                    "application/json",
                    "text/json",
                    "application/xml",
                    "text/xml",
                ],
                "content_type": [],
            },
            api_client=api_client,
        )

    def haltestellen_get_by_location(self, netvu, lon, lat, **kwargs):
        """Liefert die Liste mit den Haltestellen zu der Umkreissuche  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.haltestellen_get_by_location(netvu, lon, lat, async_req=True)
        >>> result = thread.get()

        Args:
            netvu (str): Netz des Verkehrsunternehmen, aktuell \"VAG\" oder \"VGN\"
            lon (float): Longitude für die Umkreissuche in WGS 84 Format in Grad
            lat (float): Latitude für die Umkreissuche in WGS 84 Format in Grad

        Keyword Args:
            radius (int): Radius für die Umkreissuche. Defaultwert = 1000 Meter.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            HaltestellenAPIResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["netvu"] = netvu
        kwargs["lon"] = lon
        kwargs["lat"] = lat
        return self.haltestellen_get_by_location_endpoint.call_with_http_info(**kwargs)

    def haltestellen_get_by_name(self, netvu, name, **kwargs):
        """Liefert die Liste mit den Haltestellen zu dem angegebenen Haltestellenname (Optional)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.haltestellen_get_by_name(netvu, name, async_req=True)
        >>> result = thread.get()

        Args:
            netvu (str): Netz des Verkehrsunternehmen, aktuell \"VAG\" oder \"VGN\"
            name (str): Name der Haltestelle (like)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            HaltestellenAPIResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["netvu"] = netvu
        kwargs["name"] = name
        return self.haltestellen_get_by_name_endpoint.call_with_http_info(**kwargs)
